/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.DiagnosisMorphologyRule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosisMorphologyRule3
extends DiagnosisMorphologyRule {
    protected static Logger logger = LoggerFactory.getLogger(DiagnosisMorphologyRule3.class);

    public DiagnosisMorphologyRule3(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the basis of diagnosis and morphology/behaviour combination.\n\nThe rule uses a list of valid combinations of basis of diagnosis and morphology.\n\nSome morphology/behaviour combinations are unlikely to appear for certain basis of diagnosis.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        this.loadFields();
        String morphology = this.getFieldValue(this.morphology_field);
        String bod = this.getFieldValue(this.bod_field);
        String age = this.getFieldValue(this.age_field);
        String topography = this.getFieldValue(this.topography_field);
        String behaviour = this.getFieldValue(this.behaviour_field);
        String sex = this.getFieldValue(this.sex_field);
        if (this.containOneEmptyElement(new String[]{morphology, bod})) {
            return this.getRuleOutput();
        }
        if (!this.isIntegerValue(bod)) {
            return this.getRuleOutput();
        }
        int bodInt = this.parseIntegerValue(bod);
        if (bodInt != 6) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(this.topography_field)) {
            topography = topography.toUpperCase();
        }
        this.performDiagnosisMorphologyCheck(morphology, bod, age, topography, behaviour, sex);
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
    }
}

