/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.BoDCondition;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiagnosisMorphologyRule
extends CrossFieldRule {
    protected Field morphology_field;
    protected Field bod_field;
    protected Field age_field;
    protected Field topography_field;
    protected Field behaviour_field;
    protected Field sex_field;
    protected Map<Integer, List<BoDCondition>> allBoDConditions = null;
    protected static Logger logger = LoggerFactory.getLogger(DiagnosisMorphologyRule.class);

    public DiagnosisMorphologyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
    }

    protected boolean init() {
        this.allBoDConditions = this.initializeDiagnosisMorphologyCheck();
        return this.allBoDConditions != null;
    }

    public Map<Integer, List<BoDCondition>> initializeDiagnosisMorphologyCheck() {
        List<String> BoD0Set = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        if (BoD0Set == null) {
            return null;
        }
        List<String> BoD1Set = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(1).getFileName());
        if (BoD1Set == null) {
            return null;
        }
        List<String> BoD2Set = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(2).getFileName());
        if (BoD2Set == null) {
            return null;
        }
        List<String> BoD4Set = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(3).getFileName());
        if (BoD4Set == null) {
            return null;
        }
        List<String> BoD5Set = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(4).getFileName());
        if (BoD5Set == null) {
            return null;
        }
        HashMap<Integer, List<BoDCondition>> allBoDConditions = new HashMap<Integer, List<BoDCondition>>();
        ArrayList<BoDCondition> bodList = new ArrayList<BoDCondition>();
        bodList.add(new BoDCondition(BoD0Set, true));
        allBoDConditions.put(0, bodList);
        bodList = new ArrayList();
        bodList.add(new BoDCondition(BoD1Set, true));
        allBoDConditions.put(1, bodList);
        bodList = new ArrayList();
        bodList.add(new BoDCondition(BoD2Set, true));
        bodList.add(new BoDCondition("8960", 0, 8, true));
        bodList.add(new BoDCondition("9380", "C717", true));
        bodList.add(new BoDCondition("9384", null, "1", true));
        bodList.add(new BoDCondition("9500", 0, 9, true));
        bodList.add(new BoDCondition("9510", 0, 5, true));
        List<String> stringList = BoDCondition.getListFromRange("9530", "9539");
        List<String> secondList = BoDCondition.getListFromRange("C700", "C709");
        bodList.add(new BoDCondition(stringList, secondList, true));
        allBoDConditions.put(2, bodList);
        bodList = new ArrayList();
        bodList.add(new BoDCondition(BoD4Set, true));
        stringList = BoDCondition.getListFromRange("8270", "8281");
        bodList.add(new BoDCondition(stringList, "C751", true));
        BoDCondition sexCondition = new BoDCondition("9100", 15, 49, true);
        sexCondition.setSex("2");
        bodList.add(sexCondition);
        bodList.add(new BoDCondition("9500", 0, 9, true));
        bodList.add(new BoDCondition("9732", 40, 123, true));
        bodList.add(new BoDCondition("9761", 50, 123, true));
        allBoDConditions.put(4, bodList);
        bodList = new ArrayList();
        bodList.add(new BoDCondition(BoD5Set, false));
        allBoDConditions.put(5, bodList);
        allBoDConditions.put(7, bodList);
        bodList = new ArrayList();
        stringList = BoDCondition.getListFromRange("9590", "9992");
        bodList.add(new BoDCondition("8000", false));
        bodList.add(new BoDCondition(stringList, false));
        allBoDConditions.put(6, bodList);
        return allBoDConditions;
    }

    protected void loadFields() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        this.morphology_field = ruleConfiguration.getFieldByPosition(1);
        this.bod_field = ruleConfiguration.getFieldByPosition(2);
        this.age_field = ruleConfiguration.getFieldByPosition(3);
        this.topography_field = ruleConfiguration.getFieldByPosition(4);
        this.behaviour_field = ruleConfiguration.getFieldByPosition(5);
        this.sex_field = ruleConfiguration.getFieldByPosition(6);
    }

    protected void performDiagnosisMorphologyCheck(String morphology, String bod, String age, String topography, String behaviour, String sex) {
        int ageInt = -1;
        if (!this.isEmpty(age) && this.isIntegerValue(age)) {
            ageInt = this.parseIntegerValue(age);
        }
        int bodInt = this.parseIntegerValue(bod);
        if (!this.isEmpty(behaviour) && behaviour.equals("2") && bodInt != 7 && bodInt != 5) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - BoD: " + bod + "  Behaviour: " + behaviour);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(this.bod_field, bod));
            fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
            this.addErrorDetail(fieldValues);
            return;
        }
        boolean isPositive = true;
        List<BoDCondition> listOfConditions = this.allBoDConditions.get(bodInt);
        for (BoDCondition condition : listOfConditions) {
            boolean found = false;
            Set<String> set = null;
            List<String> list = null;
            String singleMorphology = null;
            Collection<String> collection = null;
            isPositive = condition.isAllowed();
            set = condition.getMorphologySet();
            if (set != null) {
                collection = set;
            } else {
                list = condition.getMorphologyList();
                if (list != null) {
                    collection = list;
                }
            }
            if (collection != null) {
                found = collection.contains(morphology);
            }
            if ((singleMorphology = condition.getMorphology()) != null) {
                found = singleMorphology.equals(morphology);
            }
            if (!found) continue;
            if (condition.onlyMorphology()) {
                if (!isPositive) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID - (1) BoD: " + bod + "  Morphology: " + morphology);
                    }
                    ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                    fieldValues.add(new FieldValue(this.morphology_field, morphology));
                    fieldValues.add(new FieldValue(this.bod_field, bod));
                    this.addErrorDetail(fieldValues);
                    return;
                }
                return;
            }
            if (ageInt >= 0 && condition.involvesAge()) {
                boolean isAgeSupported = false;
                if (ageInt >= condition.getStartAge() && ageInt <= condition.getEndAge()) {
                    isAgeSupported = true;
                }
                if (condition.involvesSex()) {
                    boolean isSexSupported = false;
                    if (!this.isEmpty(sex) && condition.getSex().equals(sex)) {
                        isSexSupported = true;
                    }
                    if (isPositive && (!isAgeSupported || !isSexSupported) || !isPositive && isAgeSupported && isSexSupported) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("INVALID - BoD: " + bod + "  Morphology: " + morphology + "  Age: " + age + "  Sex: " + sex);
                        }
                        ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                        fieldValues.add(new FieldValue(this.morphology_field, morphology));
                        fieldValues.add(new FieldValue(this.bod_field, bod));
                        fieldValues.add(new FieldValue(this.age_field, age));
                        fieldValues.add(new FieldValue(this.sex_field, sex));
                        this.addErrorDetail(fieldValues);
                        return;
                    }
                } else if (isPositive && !isAgeSupported || !isPositive && isAgeSupported) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID - BoD: " + bod + "  Morphology: " + morphology + "  Age: " + age);
                    }
                    ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                    fieldValues.add(new FieldValue(this.morphology_field, morphology));
                    fieldValues.add(new FieldValue(this.bod_field, bod));
                    fieldValues.add(new FieldValue(this.age_field, age));
                    this.addErrorDetail(fieldValues);
                    return;
                }
            }
            if (topography != null && condition.involvesTopography()) {
                boolean isTopographySupported = false;
                if (condition.getTopography() != null && topography.equals(condition.getTopography())) {
                    isTopographySupported = true;
                } else if (condition.getTopographyList() != null && condition.getTopographyList().contains(topography)) {
                    isTopographySupported = true;
                }
                if (isPositive && !isTopographySupported || !isPositive && isTopographySupported) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID - BoD: " + bod + "  Morphology: " + morphology + "  Topography: " + topography);
                    }
                    ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                    fieldValues.add(new FieldValue(this.morphology_field, morphology));
                    fieldValues.add(new FieldValue(this.bod_field, bod));
                    fieldValues.add(new FieldValue(this.topography_field, topography));
                    this.addErrorDetail(fieldValues);
                    return;
                }
            }
            if (behaviour != null && condition.involvesBehaviour()) {
                boolean isBehaviourAccepted = behaviour.equals(condition.getBehaviour());
                if (isPositive && !isBehaviourAccepted || !isPositive && isBehaviourAccepted) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID - BoD: " + bod + "  Morphology: " + morphology + "  Behaviour: " + behaviour);
                    }
                    ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                    fieldValues.add(new FieldValue(this.morphology_field, morphology));
                    fieldValues.add(new FieldValue(this.bod_field, bod));
                    fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                    this.addErrorDetail(fieldValues);
                    return;
                }
            }
            return;
        }
        if (isPositive) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - (2) BoD: " + bod + "  Morphology: " + morphology);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(this.morphology_field, morphology));
            fieldValues.add(new FieldValue(this.bod_field, bod));
            this.addErrorDetail(fieldValues);
            return;
        }
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_BOD.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_AGE.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2014.INCIDENCE_SEX.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("DiagnosisMorphologyRule1.csv", "", "", "List of morphology values for BOD = 0"));
        files.add(new LocalFile("DiagnosisMorphologyRule2.csv", "", "", "List of morphology values for BOD = 1"));
        files.add(new LocalFile("DiagnosisMorphologyRule3.csv", "", "", "List of morphology values for BOD = 2"));
        files.add(new LocalFile("DiagnosisMorphologyRule4.csv", "", "", "List of morphology values for BOD = 4"));
        files.add(new LocalFile("DiagnosisMorphologyRule5.csv", "", "", "List of morphology values for BOD = 5 or 7"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

