/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRangeRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DateRangeRule.class);

    public DateRangeRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that date fields are consistent.\n\ni.e. Day is not greater than number of days in given month.\nMonth is not greater than 12.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field day_field = ruleConfiguration.getFieldByPosition(1);
        Field month_field = ruleConfiguration.getFieldByPosition(2);
        Field year_field = ruleConfiguration.getFieldByPosition(3);
        String day = this.getFieldValue(day_field);
        String month = this.getFieldValue(month_field);
        String year = this.getFieldValue(year_field);
        if (!this.isValidAndNotUnknownField(day_field, day)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndNotUnknownField(month_field, month)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndNotUnknownField(year_field, year)) {
            return this.getRuleOutput();
        }
        if (!this.isDayValid(day, month, year)) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID_DATE " + day_field.getName() + ": " + day + "/" + month + "/" + year);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(day_field, day));
            fieldValues.add(new FieldValue(month_field, month));
            fieldValues.add(new FieldValue(year_field, year));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    protected boolean isDayValid(String dayAsString, String monthAsString, String yearAsString) {
        int day = 0;
        int month = 0;
        int year = 0;
        try {
            day = Integer.parseInt(dayAsString);
            month = Integer.parseInt(monthAsString);
            year = Integer.parseInt(yearAsString);
        }
        catch (NumberFormatException e) {
            return true;
        }
        if (day >= 1 && day <= 30) {
            if (day == 29) {
                boolean isLeapYear;
                boolean bl = isLeapYear = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
                return isLeapYear || month != 2;
            }
            if (day == 30) {
                return month != 2;
            }
            return true;
        }
        if (day == 31) {
            return month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12;
        }
        return false;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        this.setDefaultSchemaView(DefaultSchemaID.INCIDENCE_2014_DEFAULT.id);
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_DAY_DOB.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOB.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

