/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateLastVitalStatusRule1
extends CrossFieldRule {
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    protected static Logger logger = LoggerFactory.getLogger(DateLastVitalStatusRule1.class);

    public DateLastVitalStatusRule1(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that Date of Last Known Vital Status is consistent with Date of Birth and Date of Incidence.\n\ni.e. Date of Last Known Vital Status occurs after Date of Birth.\nDate of Last Known Vital Status occurs after Date of Incidence.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        boolean emptyElementInDoIOrDoF;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field dayDoB_field = ruleConfiguration.getFieldByPosition(1);
        Field monthDoB_field = ruleConfiguration.getFieldByPosition(2);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(3);
        Field dayDoI_field = ruleConfiguration.getFieldByPosition(4);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(5);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(6);
        Field dayDoFU_field = ruleConfiguration.getFieldByPosition(7);
        Field monthDoFu_field = ruleConfiguration.getFieldByPosition(8);
        Field yearDoFU_field = ruleConfiguration.getFieldByPosition(9);
        String dayDoB = this.getFieldValue(dayDoB_field);
        String monthDoB = this.getFieldValue(monthDoB_field);
        String yearDoB = this.getFieldValue(yearDoB_field);
        String dayDoI = this.getFieldValue(dayDoI_field);
        String monthDoI = this.getFieldValue(monthDoI_field);
        String yearDoI = this.getFieldValue(yearDoI_field);
        String dayDoFU = this.getFieldValue(dayDoFU_field);
        String monthDoFU = this.getFieldValue(monthDoFu_field);
        String yearDoFU = this.getFieldValue(yearDoFU_field);
        boolean isValid = false;
        boolean emptyElementInDoBOrDoF = this.containOneEmptyElement(new String[]{dayDoB, monthDoB, yearDoB, dayDoFU, monthDoFU, yearDoFU});
        if (!emptyElementInDoBOrDoF && !dayDoB_field.isUnknownValue(dayDoB) && !dayDoFU_field.isUnknownValue(dayDoFU) && !monthDoB_field.isUnknownValue(monthDoB) && !monthDoFu_field.isUnknownValue(monthDoFU) && !yearDoB_field.isUnknownValue(yearDoB) && !yearDoFU_field.isUnknownValue(yearDoFU) && this.isValidField(dayDoB_field) && this.isValidField(dayDoFU_field) && this.isValidField(monthDoB_field) && this.isValidField(monthDoFu_field) && this.isValidField(yearDoB_field) && this.isValidField(yearDoFU_field)) {
            String doB_string = dayDoB + "-" + monthDoB + "-" + yearDoB;
            String doFU_string = dayDoFU + "-" + monthDoFU + "-" + yearDoFU;
            isValid = true;
            try {
                Date dateOfBirth = dateFormat.parse(doB_string);
                Date dateOfFollowUp = dateFormat.parse(doFU_string);
                if (dateOfBirth.getTime() > dateOfFollowUp.getTime()) {
                    isValid = false;
                }
            }
            catch (ParseException e) {
                isValid = false;
            }
            if (!isValid) {
                if (logger.isDebugEnabled()) {
                    logger.debug("INVALID - DoB: " + dayDoB + "/" + monthDoB + "/" + yearDoB + "  DoF: " + dayDoFU + "/" + monthDoFU + "/" + yearDoFU);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(dayDoB_field, dayDoB));
                fieldValues.add(new FieldValue(monthDoB_field, monthDoB));
                fieldValues.add(new FieldValue(yearDoB_field, yearDoB));
                fieldValues.add(new FieldValue(dayDoFU_field, dayDoFU));
                fieldValues.add(new FieldValue(monthDoFu_field, monthDoFU));
                fieldValues.add(new FieldValue(yearDoFU_field, yearDoFU));
                this.addErrorDetail(fieldValues);
            }
        }
        if (!(emptyElementInDoIOrDoF = this.containOneEmptyElement(new String[]{dayDoI, monthDoI, yearDoI, dayDoFU, monthDoFU, yearDoFU})) && !dayDoI_field.isUnknownValue(dayDoI) && !dayDoFU_field.isUnknownValue(dayDoFU) && !monthDoI_field.isUnknownValue(monthDoI) && !monthDoFu_field.isUnknownValue(monthDoFU) && !yearDoI_field.isUnknownValue(yearDoI) && !yearDoFU_field.isUnknownValue(yearDoFU) && this.isValidField(dayDoI_field) && this.isValidField(dayDoFU_field) && this.isValidField(monthDoI_field) && this.isValidField(monthDoFu_field) && this.isValidField(yearDoI_field) && this.isValidField(yearDoFU_field)) {
            String doI_string = dayDoI + "-" + monthDoI + "-" + yearDoI;
            String doFU_string = dayDoFU + "-" + monthDoFU + "-" + yearDoFU;
            isValid = true;
            try {
                Date dateIncidence = dateFormat.parse(doI_string);
                Date dateFollow = dateFormat.parse(doFU_string);
                if (dateIncidence.getTime() > dateFollow.getTime()) {
                    isValid = false;
                }
            }
            catch (ParseException e) {
                isValid = false;
            }
            if (!isValid) {
                if (logger.isDebugEnabled()) {
                    logger.debug("INVALID - DoI: " + dayDoI + "/" + monthDoI + "/" + yearDoI + "  DoF: " + dayDoFU + "/" + monthDoFU + "/" + yearDoFU);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(dayDoI_field, dayDoI));
                fieldValues.add(new FieldValue(monthDoI_field, monthDoI));
                fieldValues.add(new FieldValue(yearDoI_field, yearDoI));
                fieldValues.add(new FieldValue(dayDoFU_field, dayDoFU));
                fieldValues.add(new FieldValue(monthDoFu_field, monthDoFU));
                fieldValues.add(new FieldValue(yearDoFU_field, yearDoFU));
                this.addErrorDetail(fieldValues);
            }
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_DAY_DOB.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOB.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_DAY_DOI.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2014.INCIDENCE_DAY_FU.id, false);
        RuleParameter param8 = new RuleParameter(8, DefaultFieldIDencr2014.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param9 = new RuleParameter(9, DefaultFieldIDencr2014.INCIDENCE_YEAR_FU.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        defaultRuleParameters.add(param8);
        defaultRuleParameters.add(param9);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

