/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateBirthIncidenceRule1
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DateBirthIncidenceRule1.class);

    public DateBirthIncidenceRule1(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that Date of Birth and Date of Incidence are consistent.\n\ni.e. Date of Incidence occurs after Date of Birth.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        int dayDoI_int;
        int monthDoI_int;
        int yearDoI_int;
        String yearDoI;
        String monthDoI;
        String dayDoI;
        String yearDoB;
        String monthDoB;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field dayDoB_field = ruleConfiguration.getFieldByPosition(1);
        Field monthDoB_field = ruleConfiguration.getFieldByPosition(2);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(3);
        Field dayDoI_field = ruleConfiguration.getFieldByPosition(4);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(5);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(6);
        String dayDoB = this.getFieldValue(dayDoB_field);
        if (this.containOneEmptyElement(new String[]{dayDoB, monthDoB = this.getFieldValue(monthDoB_field), yearDoB = this.getFieldValue(yearDoB_field), dayDoI = this.getFieldValue(dayDoI_field), monthDoI = this.getFieldValue(monthDoI_field), yearDoI = this.getFieldValue(yearDoI_field)})) {
            return this.getRuleOutput();
        }
        if (yearDoB_field.isUnknownValue(yearDoB) || yearDoI_field.isUnknownValue(yearDoI)) {
            return this.getRuleOutput();
        }
        if (!this.isValidField(yearDoB_field) || !this.isValidField(yearDoI_field)) {
            return this.getRuleOutput();
        }
        int yearDoB_int = this.parseIntegerValue(yearDoB);
        if (yearDoB_int > (yearDoI_int = this.parseIntegerValue(yearDoI))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - yearB: " + yearDoB);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(yearDoB_field, yearDoB));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        if (yearDoB_int < yearDoI_int) {
            return this.getRuleOutput();
        }
        if (!this.isValidField(monthDoB_field) || !this.isValidField(monthDoI_field)) {
            return this.getRuleOutput();
        }
        int monthDoB_int = this.parseIntegerValue(monthDoB);
        if (monthDoB_int > (monthDoI_int = this.parseIntegerValue(monthDoI))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - monthB: " + monthDoB);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(monthDoB_field, monthDoB));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        if (monthDoB_int < monthDoI_int) {
            return this.getRuleOutput();
        }
        if (!this.isValidField(dayDoB_field) || !this.isValidField(dayDoI_field)) {
            return this.getRuleOutput();
        }
        int dayDoB_int = this.parseIntegerValue(dayDoB);
        if (dayDoB_int > (dayDoI_int = this.parseIntegerValue(dayDoI))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - monthB: " + monthDoB);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(dayDoB_field, dayDoB));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_DAY_DOB.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOB.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_DAY_DOI.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

