/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BehaviourMorphologyTopographyRule
extends CrossFieldRule {
    protected List<String> configDataBehMorph = null;
    protected List<String> configDataTopo1 = null;
    protected List<String> configDataTopo2 = null;
    protected List<String> configDataTopo3 = null;
    protected List<String> configDataTopo4 = null;
    protected List<String> configDataTopo5 = null;
    protected static Logger logger = LoggerFactory.getLogger(BehaviourMorphologyTopographyRule.class);

    public BehaviourMorphologyTopographyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of behaviour and morphology/topography.\n");
    }

    protected boolean init() {
        this.configDataBehMorph = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        if (this.configDataBehMorph == null) {
            return false;
        }
        this.configDataTopo1 = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(1).getFileName());
        if (this.configDataTopo1 == null) {
            return false;
        }
        this.configDataTopo2 = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(2).getFileName());
        if (this.configDataTopo2 == null) {
            return false;
        }
        this.configDataTopo3 = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(3).getFileName());
        if (this.configDataTopo3 == null) {
            return false;
        }
        this.configDataTopo4 = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(4).getFileName());
        if (this.configDataTopo4 == null) {
            return false;
        }
        this.configDataTopo5 = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(5).getFileName());
        return this.configDataTopo5 != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String topography;
        String behaviour;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(1);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(2);
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        String morphology = this.getFieldValue(morphology_field);
        if (this.containOneEmptyElement(new String[]{morphology, behaviour = this.getFieldValue(behaviour_field), topography = this.getFieldValue(topography_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isIntegerValue(behaviour)) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        int behaviourInt = this.parseIntegerValue(behaviour);
        String behMorphPair = morphology + ";" + behaviour;
        boolean isValid = true;
        if (behaviourInt == 0) {
            if (this.configDataBehMorph.contains(behMorphPair) && !this.configDataTopo1.contains(topography)) {
                isValid = false;
            }
        } else if (behaviourInt == 1) {
            if (this.configDataBehMorph.contains(behMorphPair) && !this.configDataTopo2.contains(topography)) {
                isValid = false;
            }
        } else if (behaviourInt == 2) {
            if (this.configDataTopo4.contains(morphology)) {
                if (!this.configDataTopo5.contains(topography)) {
                    isValid = false;
                }
            } else if (this.configDataBehMorph.contains(behMorphPair) && !this.configDataTopo3.contains(topography)) {
                isValid = false;
            }
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("applyCheck(): INVALID - Morphology: " + morphology + "  Behaviour: " + behaviour + "  Topography: " + topography);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(morphology_field, morphology));
            fieldValues.add(new FieldValue(behaviour_field, behaviour));
            fieldValues.add(new FieldValue(topography_field, topography));
            this.addErrorDetail(fieldValues);
        }
        return RuleOutput.VALID;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("BehaviourMorphologyRule.csv", "", "", "List of allowed morphology and behaviour pairs"));
        files.add(new LocalFile("BehaviourMorphologyTopographyRule1.csv", "", "", "List of topography values allowed when behaviour = 0"));
        files.add(new LocalFile("BehaviourMorphologyTopographyRule2.csv", "", "", "List of topography values allowed when behaviour = 1"));
        files.add(new LocalFile("BehaviourMorphologyTopographyRule3.csv", "", "", "List of topography values allowed when behaviour = 2"));
        files.add(new LocalFile("BehaviourMorphologyTopographyRule4.csv", "", "", "List of exception morphology values when behaviour = 2"));
        files.add(new LocalFile("BehaviourMorphologyTopographyRule5.csv", "", "", "List of exception topography values when behaviour = 2"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

