/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BehaviourMorphologyRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(BehaviourMorphologyRule.class);
    protected List<String> configData = null;

    public BehaviourMorphologyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule checks that the morphology/behaviour combination is included in ICD-O-3.\n");
    }

    protected boolean init() {
        this.configData = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        return this.configData != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(1);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(2);
        String morphology = this.getFieldValue(morphology_field);
        String behaviour = this.getFieldValue(behaviour_field);
        if (this.containOneEmptyElement(new String[]{morphology, behaviour})) {
            return this.getRuleOutput();
        }
        if (!this.isValidField(morphology_field)) {
            return this.getRuleOutput();
        }
        if (!this.isValidField(behaviour_field)) {
            return this.getRuleOutput();
        }
        if (!this.configData.contains(morphology + ";" + behaviour)) {
            if (logger.isDebugEnabled()) {
                logger.debug("applyCheck(): INVALID - Morphology: " + morphology + "  Behaviour: " + behaviour);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(morphology_field, morphology));
            fieldValues.add(new FieldValue(behaviour_field, behaviour));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("BehaviourMorphologyRule.csv", "", "", "List of morphology and behaviour pairs allowed"));
        this.ruleConfiguration.setConfigurationFiles(files);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

