/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeBirthIncidenceRule1
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(AgeBirthIncidenceRule1.class);

    public AgeBirthIncidenceRule1(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("The rule calculates the age as (Date of Incidence - Date of Birth) in years and it compares it with the Age value provided in the record.\n\nThe Calculated Age must not differ more than one year from the Age value provided.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field age_field = ruleConfiguration.getFieldByPosition(1);
        Field dayDoB_field = ruleConfiguration.getFieldByPosition(2);
        Field monthDoB_field = ruleConfiguration.getFieldByPosition(3);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(4);
        Field dayDoI_field = ruleConfiguration.getFieldByPosition(5);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(6);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(7);
        String age = this.getFieldValue(age_field);
        String dayDoB = this.getFieldValue(dayDoB_field);
        String monthDoB = this.getFieldValue(monthDoB_field);
        String yearDoB = this.getFieldValue(yearDoB_field);
        String dayDoI = this.getFieldValue(dayDoI_field);
        String monthDoI = this.getFieldValue(monthDoI_field);
        String yearDoI = this.getFieldValue(yearDoI_field);
        if (this.isEmpty(age)) {
            return this.getRuleOutput();
        }
        boolean isValid = true;
        boolean emptyMonthOrYearIn_DoB_DoI = this.containOneEmptyElement(new String[]{monthDoB, yearDoB, monthDoI, yearDoI});
        if (!(emptyMonthOrYearIn_DoB_DoI || age_field.isUnknownValue(age) || yearDoB_field.isUnknownValue(yearDoB) || yearDoI_field.isUnknownValue(yearDoI))) {
            int ageCalculated = 0;
            boolean isAgeCalculated = true;
            if (this.isValidAndNotUnknownField(monthDoB_field, monthDoB) && this.isValidAndNotUnknownField(monthDoI_field, monthDoI) && this.isValidField(yearDoB_field) && this.isValidField(yearDoI_field)) {
                int monthDoBInt = Integer.parseInt(monthDoB);
                int yearDoBInt = Integer.parseInt(yearDoB);
                int monthDoIInt = Integer.parseInt(monthDoI);
                int yearDoIInt = Integer.parseInt(yearDoI);
                ageCalculated = (yearDoIInt * 12 + monthDoIInt - (yearDoBInt * 12 + monthDoBInt)) / 12;
            } else if (this.isValidField(yearDoB_field) && this.isValidField(yearDoI_field)) {
                int yearDoBInt = Integer.parseInt(yearDoB);
                int yearDoIInt = Integer.parseInt(yearDoI);
                ageCalculated = yearDoIInt - yearDoBInt;
            } else if (this.isValidField(dayDoB_field) && this.isValidField(dayDoI_field) && this.isValidField(monthDoB_field) && this.isValidField(monthDoI_field) && this.isValidField(yearDoB_field) && this.isValidField(yearDoI_field)) {
                ageCalculated = 1;
            } else {
                isAgeCalculated = false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Comparing Age: " + age + "  wich calculated: " + ageCalculated + this.formatDates(dayDoB, monthDoB, yearDoB, dayDoI, monthDoI, yearDoI));
            }
            if (isAgeCalculated) {
                if (this.isValidField(age_field)) {
                    int ageInt = this.parseIntegerValue(age);
                    if (Math.abs(ageInt - ageCalculated) > 1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("INVALID - Age: " + age + "  Calculated: " + ageCalculated + this.formatDates(dayDoB, monthDoB, yearDoB, dayDoI, monthDoI, yearDoI));
                        }
                        isValid = false;
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID - Age: " + age + "  Calculated: " + ageCalculated + this.formatDates(dayDoB, monthDoB, yearDoB, dayDoI, monthDoI, yearDoI));
                    }
                    isValid = false;
                }
            } else if (!(this.isValidField(age_field) && this.isValidField(yearDoB_field) && this.isValidField(yearDoI_field))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("INVALID - Age: " + age + "  Calculated: " + ageCalculated + this.formatDates(dayDoB, monthDoB, yearDoB, dayDoI, monthDoI, yearDoI));
                }
                isValid = false;
            }
        }
        if (!isValid) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(age_field, age));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_AGE.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_DAY_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOB.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_DAY_DOI.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }

    protected String formatDates(String dayDoB, String monthDoB, String yearDoB, String dayDoI, String monthDoI, String yearDoI) {
        StringBuilder builder = new StringBuilder();
        builder.append(" - DoB: ");
        builder.append(dayDoB);
        builder.append("/");
        builder.append(monthDoB);
        builder.append("/");
        builder.append(yearDoB);
        builder.append(" - DoI: ");
        builder.append(dayDoI);
        builder.append("/");
        builder.append(monthDoI);
        builder.append("/");
        builder.append(yearDoI);
        return builder.toString();
    }
}

