/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopographyParser {
    protected int topoStart = -1;
    protected int topoEnd = -1;
    public static final char COLUM_SEPARATOR = ';';
    public static final char SEPARATOR = ',';
    public static final String RANGE = "-";
    public static final String ANY = "Any";
    public static final char TOPO_START = 'C';
    public static final int WRONG_TOPO = -1;
    protected static Logger logger = LoggerFactory.getLogger(TopographyParser.class);

    public List<String> expandTopographiesAsIntegerRange(String line, int topoIndex) {
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographiesAsIntegerRange() - Input line: " + line);
        }
        List<String> linesExpandedBySeparator = this.expandTopographies(line, topoIndex);
        ArrayList<String> list = new ArrayList<String>();
        String columnSeparator = String.valueOf(';');
        for (String row : linesExpandedBySeparator) {
            if (logger.isTraceEnabled()) {
                logger.trace("expandTopographiesAsIntegerRange() - Handling line: " + row);
            }
            String topography = row.split(columnSeparator)[topoIndex];
            int[] range = this.expandTopographies(topography);
            StringBuilder builder = new StringBuilder();
            builder.append(range[0]);
            builder.append(columnSeparator);
            builder.append(range[1]);
            String newRow = new String(row);
            newRow = newRow.replace(topography, builder);
            list.add(newRow);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("expandTopographiesAsIntegerRange() - New line: " + newRow);
        }
        return list;
    }

    public List<String> expandTopographies(String line, int topoIndex) {
        String columnSeparator = String.valueOf(';');
        String topographies = line.split(columnSeparator)[topoIndex];
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographies() - Input topographies: " + topographies);
        }
        String separator = String.valueOf(',');
        String[] tokens = topographies.split(separator);
        ArrayList<String> expandedTopographies = new ArrayList<String>();
        for (String token : tokens) {
            if (logger.isTraceEnabled()) {
                logger.trace("expandTopographies() - Handling token: " + token);
            }
            String newLine = new String(line);
            newLine = newLine.replace(topographies, token);
            expandedTopographies.add(newLine);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("expandTopographies() - Added line: " + newLine);
        }
        return expandedTopographies;
    }

    public int[] expandTopographies(String topographyRange) {
        Object range;
        if (topographyRange == null) {
            String message = "Found null list of Topographies";
            logger.warn("expandTopographies(): " + message);
        }
        String topography = new String(topographyRange.trim());
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("expandTopographies() - Input topography (raw): #" + topographyRange + "#");
            logger.info("expandTopographies() - Input topography (trimmed): #" + topography + "#");
        }
        if (topography.contains(RANGE)) {
            if (debug) {
                logger.info("expandTopographies() - Handling topo's range: " + topography);
            }
            range = String.valueOf(RANGE);
            Object[] topo = topography.split((String)range);
            String topoStartRaw = topo[0];
            String topoEndRaw = topo[1];
            if (debug) {
                logger.info("expandTopographies() - Split topo's range : " + Arrays.toString(topo));
            }
            if (this.isUnspecificTopography(topoStartRaw)) {
                this.topoStart = this.getInitialTopography(topoStartRaw);
            } else {
                topoStartRaw = topoStartRaw.substring(1, topoStartRaw.length());
                this.topoStart = Integer.parseInt(topoStartRaw);
            }
            if (this.isUnspecificTopography(topoEndRaw)) {
                this.topoEnd = this.getFinalTopography(topoEndRaw);
            } else {
                topoEndRaw = topoEndRaw.substring(1, topoEndRaw.length());
                this.topoEnd = Integer.parseInt(topoEndRaw);
            }
            if (debug) {
                logger.info("expandTopographies() - Integer topo_range (multiple): " + this.topoStart + " -> " + this.topoEnd);
            }
        } else {
            if (debug) {
                logger.trace("expandTopographies() - Handling single_topo: " + topography);
            }
            if (this.isUnspecificTopography(topography)) {
                this.topoStart = this.getInitialTopography(topography);
                this.topoEnd = this.getFinalTopography(topography);
            } else if (!ANY.equalsIgnoreCase(topography)) {
                String valueAsString = topography.substring(1, topography.length());
                this.topoStart = Integer.parseInt(valueAsString);
                this.topoEnd = Integer.parseInt(valueAsString);
            } else {
                this.topoStart = 0;
                this.topoEnd = 999;
                if (debug) {
                    logger.info("expandTopographies() - Handled keyword: " + topography);
                }
            }
            if (debug) {
                logger.info("expandTopographies() - Integer topo_range (single): " + this.topoStart + " -> " + this.topoEnd);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographies() - Expanded topographis: " + this.topoStart + " -> " + this.topoEnd);
        }
        range = new int[]{this.topoStart, this.topoEnd};
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographies() - Returnin array: " + Arrays.toString((int[])range));
        }
        return range;
    }

    public boolean isSpecificTopography(String code) {
        if (code == null) {
            logger.error("isSpecificTopography() - Found null topography code");
            return false;
        }
        if (ANY.equalsIgnoreCase(code)) {
            return false;
        }
        if (code.charAt(0) != 'C') {
            logger.error("isSpecificTopography() - Found wrong topography prefix (different from 'C'): " + code);
            return false;
        }
        return code.length() == 4;
    }

    public boolean isUnspecificTopography(String code) {
        if (code == null) {
            logger.error("isUnspecificTopography() - Found null topography code");
            return false;
        }
        if (ANY.equalsIgnoreCase(code)) {
            return false;
        }
        if (code.charAt(0) != 'C') {
            logger.error("isUnspecificTopography() - Found wrong topography prefix (different from 'C'): " + code);
            return false;
        }
        return code.length() == 3;
    }

    public int parseTopography(String code) {
        int topographyInt = -1;
        if (logger.isTraceEnabled()) {
            logger.trace("parseTopography() - Input Topography code: " + code);
        }
        if (code == null) {
            return -1;
        }
        if (code.length() < 3 || code.length() > 4) {
            return -1;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("parseTopography() - Parsing Topography code: " + code);
        }
        try {
            int factor = this.isUnspecificTopography(code) ? 10 : 1;
            String topography = code.substring(1, code.length());
            topographyInt = factor * Integer.parseInt(topography);
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("parseTopography() - Wrong Topography code: " + code);
            }
            return -1;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("parseTopography() - Parsed Topography code: " + topographyInt);
        }
        return topographyInt;
    }

    public int getInitialTopography(String code) {
        if (!this.isUnspecificTopography(code)) {
            logger.error("getInitialTopography() - Found wrong topography code: " + code);
            return -1;
        }
        int initialValue = this.parseTopography(code);
        if (logger.isTraceEnabled()) {
            logger.trace("getInitialTopography() - Initial value: " + initialValue);
        }
        return initialValue;
    }

    public int getFinalTopography(String code) {
        if (!this.isUnspecificTopography(code)) {
            logger.error("getFinalTopography() - Found wrong topography code: " + code);
            return -1;
        }
        int finalValue = this.parseTopography(code) + 9;
        if (logger.isTraceEnabled()) {
            logger.trace("getFinalTopography() - Final value: " + finalValue);
        }
        return finalValue;
    }

    public int getTopoStart() {
        return this.topoStart;
    }

    public void setTopoStart(int topoStart) {
        this.topoStart = topoStart;
    }

    public int getTopoEnd() {
        return this.topoEnd;
    }

    public void setTopoEnd(int topoEnd) {
        this.topoEnd = topoEnd;
    }
}

