/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMValues;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMEditionTableData {
    public String Stage;
    public String T;
    public String N;
    public String M;
    public String Grade;
    public String Risk;
    public String Serum;
    public String Mitotic;
    public String tableId;
    public boolean anyPT;
    public boolean anyPN;
    public boolean anyPM;
    protected boolean verbose;
    protected static Logger logger = LoggerFactory.getLogger(TNMEditionTableData.class);

    public void buildCacheData() {
        this.buildAnyPT();
        this.buildAnyPN();
        this.buildAnyPM();
        if (this.Grade != null) {
            this.Grade = "," + this.Grade.replaceAll("\\s", "") + ",";
        }
    }

    public boolean isSupported(TNMValues tnmValues) {
        if (this.anyPT && !tnmValues.isPathologicalT()) {
            return false;
        }
        if (this.anyPN && !tnmValues.isPathologicalN()) {
            return false;
        }
        return !this.anyPM || tnmValues.isPathologicalM();
    }

    public boolean matchesTNMValues(String tValue, String nValue, String mValue, String grade, String anyT, String anyN, String anyM, String anyGrade) {
        if (this.isVerbose()) {
            String inputTNM = tValue + " | " + nValue + " | " + mValue;
            String classTNM = this.T + " | " + this.N + " | " + this.M;
            String abyTNM = anyT + " | " + anyN + " | " + anyM;
            logger.info("matchesTNMValues() - Input TNM     : " + inputTNM);
            logger.info("matchesTNMValues() - Input Grade   : " + grade);
            logger.info("matchesTNMValues() - This TNM      : " + classTNM);
            logger.info("matchesTNMValues() - This Grade    : " + this.Grade);
            logger.info("matchesTNMValues() - Any TNM       : " + abyTNM);
            logger.info("matchesTNMValues() - Any Grade     : " + anyGrade);
        }
        if (this.T != null && !this.isAllowedValue(tValue, this.T, anyT)) {
            if (this.isVerbose()) {
                logger.info("matchesTNMValues() - Invalid T     : " + tValue + " | " + this.T);
            }
            return false;
        }
        if (this.N != null && !this.isAllowedValue(nValue, this.N, anyN)) {
            if (this.isVerbose()) {
                logger.info("matchesTNMValues() - Invalid N     : " + nValue + " | " + this.N);
            }
            return false;
        }
        if (this.M != null && !this.isAllowedValue(mValue, this.M, anyM)) {
            if (this.isVerbose()) {
                logger.info("matchesTNMValues() - Invalid M     : " + mValue + " | " + this.M);
            }
            return false;
        }
        if (this.Grade != null && grade != null && !this.isAllowedValue(grade, this.Grade, anyGrade)) {
            if (this.isVerbose()) {
                logger.info("matchesTNMValues() - Invalid Grade : " + grade + " | " + this.Grade);
            }
            return false;
        }
        return true;
    }

    public void adjustAllAllowedValues(boolean verbose) {
        this.T = this.adjustAllowedValue(this.T, verbose);
        this.N = this.adjustAllowedValue(this.N, verbose);
        this.M = this.adjustAllowedValue(this.M, verbose);
    }

    protected String adjustAllowedValue(String value, boolean verbose) {
        String result = new String(value);
        Pattern validTokenWithSuffix = Pattern.compile(",[a-zA-Z]\\d[^,]{1,},");
        Matcher matcher = validTokenWithSuffix.matcher(value);
        boolean allowedWithSuffix = matcher.find();
        if (allowedWithSuffix) {
            Pattern tokenPattern = Pattern.compile(",([a-zA-Z]\\d)[^,]*");
            Matcher tokenMatcher = tokenPattern.matcher(value);
            result = tokenMatcher.replaceAll(",$1");
            if (this.verbose) {
                logger.info("adjustAllowedValue() - ALLOWED_VALUE       = " + value);
                logger.info("adjustAllowedValue() - Allowed with suffix ? " + allowedWithSuffix);
                logger.info("adjustAllowedValue() - ALLOWED_CUT         = " + result);
            }
        }
        return result;
    }

    protected boolean isAllowedValue(String value, String allowed, String anyList) {
        if (this.verbose) {
            logger.info("isAllowedValue() - Record's value       = " + value);
            logger.info("isAllowedValue() - Allowed's value      = " + allowed);
            logger.info("isAllowedValue() - Any value            = " + anyList);
        }
        return allowed == null || !(allowed.equals(",any,") ? anyList.length() > 0 && anyList.indexOf("," + value + ",") < 0 : allowed.indexOf("," + value + ",") < 0);
    }

    protected void buildAnyPT() {
        if (this.T == null) {
            return;
        }
        this.T = "," + this.T.replaceAll("\\s", "") + ",";
        if (this.T.equalsIgnoreCase(",anypT,")) {
            this.anyPT = true;
        }
    }

    protected void buildAnyPN() {
        if (this.N == null) {
            return;
        }
        this.N = "," + this.N.replaceAll("\\s", "") + ",";
        if (this.N.equalsIgnoreCase(",anypN,")) {
            this.anyPN = true;
        }
    }

    protected void buildAnyPM() {
        if (this.M == null) {
            return;
        }
        this.M = "," + this.M.replaceAll("\\s", "") + ",";
        if (this.M.equalsIgnoreCase(",anypM,")) {
            this.anyPM = true;
        }
    }

    public String getStage() {
        return this.Stage;
    }

    public void setStage(String Stage) {
        this.Stage = Stage;
    }

    public String getT() {
        return this.T;
    }

    public void setT(String T) {
        this.T = T;
    }

    public String getN() {
        return this.N;
    }

    public void setN(String N) {
        this.N = N;
    }

    public String getM() {
        return this.M;
    }

    public void setM(String M) {
        this.M = M;
    }

    public String getGrade() {
        return this.Grade;
    }

    public void setGrade(String Grade) {
        this.Grade = Grade;
    }

    public String getRisk() {
        return this.Risk;
    }

    public void setRisk(String Risk) {
        this.Risk = Risk;
    }

    public String getSerum() {
        return this.Serum;
    }

    public void setSerum(String Serum) {
        this.Serum = Serum;
    }

    public String getMitotic() {
        return this.Mitotic;
    }

    public void setMitotic(String Mitotic) {
        this.Mitotic = Mitotic;
    }

    public boolean getAnyPT() {
        return this.anyPT;
    }

    public boolean getAnyPN() {
        return this.anyPN;
    }

    public boolean getAnyPM() {
        return this.anyPM;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilder tableValue = new StringBuilder();
        Formatter formatter = new Formatter(tableValue, Locale.ENGLISH);
        formatter.format("%-10s", this.tableId);
        formatter.close();
        builder.append(tableValue.toString());
        StringBuilder stageValue = new StringBuilder();
        formatter = new Formatter(stageValue, Locale.ENGLISH);
        formatter.format("%5s%-5s", "Stage=", this.Stage);
        formatter.close();
        builder.append(stageValue.toString());
        StringBuilder tnm = new StringBuilder();
        formatter = new Formatter(tnm, Locale.ENGLISH);
        formatter.format("%2s%-10s%2s%-10s%2s%-10s", "T=", this.T, "N=", this.N, "M=", this.M);
        formatter.close();
        builder.append(" ");
        builder.append(tnm.toString());
        if (this.Grade != null) {
            builder.append(", grade=");
            builder.append(this.Grade);
        }
        if (this.Risk != null) {
            builder.append(", risk=");
            builder.append(this.Risk);
        }
        if (this.Serum != null) {
            builder.append(", serum=");
            builder.append(this.Serum);
        }
        if (this.Mitotic != null) {
            builder.append(", mitotic=");
            builder.append(this.Mitotic);
        }
        return builder.toString();
    }
}

