/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.MorphologyGroup;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEdition;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEditionTableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMEditionTable {
    protected String id;
    protected String description;
    protected String topography;
    protected String topographyExcept;
    protected String morphology;
    protected String age;
    protected List<TNMEditionTableData> data;
    protected List<String> topographies;
    protected List<String> excludedTopographies;
    protected List<String> morphologies;
    protected int ageBoundary;
    protected String ageOperator;
    protected String anyT;
    protected String anyN;
    protected String anyM;
    protected String anyGrade;
    protected boolean verbose;
    protected static Logger logger = LoggerFactory.getLogger(TNMEditionTable.class);

    public void buildCacheData(List<MorphologyGroup> morphologyGroups) {
        this.buildTopographyList();
        this.buildTopographyExceptList();
        this.buildMorphologyList(morphologyGroups);
        this.buildAge();
        this.buildAnyTNMLists();
    }

    public boolean addressTopography(String topography) {
        if (this.topographies == null) {
            return true;
        }
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("addressTopography() - Checking if topography " + topography + " is in " + this.id + " (excluded topos: " + String.valueOf(this.excludedTopographies) + ")");
            logger.info("addressTopography() - Topographies in this table: " + String.valueOf(this.topographies));
        }
        if (this.topographies.contains("any")) {
            return true;
        }
        if (this.topographies.contains(topography)) {
            if (this.excludedTopographies == null) {
                if (debug) {
                    logger.info("addressTopography() - Topography: " + topography + " FOUND in " + this.id + " (no_exclude_values)");
                }
                return true;
            }
            if (this.excludedTopographies.contains(topography)) {
                if (debug) {
                    logger.info("addressTopography() - Topography: " + topography + " EXCLUDED by " + this.id);
                }
                return false;
            }
            if (debug) {
                logger.info("addressTopography() - Topography: " + topography + " FOUND in " + this.id + " (with_exclude_values)");
            }
            return true;
        }
        if (debug) {
            logger.info("addressTopography() - Topography: " + topography + " NOT_FOUND in " + this.id);
        }
        return false;
    }

    public boolean addressMorphology(String morphology) {
        if (this.morphologies == null) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addressMorphology() - Checking if morphology " + morphology + " regards " + this.id);
        }
        if (this.morphologies.contains("any")) {
            return true;
        }
        return this.morphologies.contains(morphology);
    }

    public boolean addressAge(String ageAsString) {
        if (this.age == null || this.ageOperator == null) {
            return true;
        }
        if (this.age.equals("any") || this.age.length() <= 0 || this.ageOperator == null) {
            return true;
        }
        if (ageAsString.length() <= 0) {
            return false;
        }
        int ageVerifyVal = Integer.parseInt(ageAsString);
        return this.ageOperator.equals("=") ? ageVerifyVal == this.ageBoundary : (this.ageOperator.equals("<") ? ageVerifyVal < this.ageBoundary : (this.ageOperator.equals("<=") ? ageVerifyVal <= this.ageBoundary : (this.ageOperator.equals(">") ? ageVerifyVal > this.ageBoundary : this.ageOperator.equals(">=") && ageVerifyVal >= this.ageBoundary)));
    }

    public boolean addressStage(String stage) {
        if (this.data == null) {
            return false;
        }
        for (TNMEditionTableData table : this.data) {
            String tableStage = table.getStage();
            if (tableStage == null || !tableStage.equalsIgnoreCase(stage)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidTNMCombination(TNMEditionTableData row, String tValue, String nValue, String mValue, String grade) {
        if (row == null) {
            return false;
        }
        if (this.isVerbose()) {
            row.setVerbose(true);
        }
        if (row.matchesTNMValues(tValue, nValue, mValue, grade, this.anyT, this.anyN, this.anyM, this.anyGrade)) {
            return true;
        }
        if (this.isVerbose()) {
            row.setVerbose(false);
        }
        return false;
    }

    public List<TNMEditionTableData> getStageData(String stage) {
        if (stage == null) {
            return null;
        }
        boolean isNumeric = this.isNumericStage(stage);
        ArrayList<TNMEditionTableData> list = new ArrayList<TNMEditionTableData>();
        if (this.verbose) {
            int dataRows = this.data == null ? 0 : this.data.size();
            logger.info("getStageData() - Input record's stage: " + stage + " (is numeric ? " + isNumeric + ")");
            logger.info("getStageData() - Checking TNM table with " + dataRows + " \"Stage\" rows");
        }
        for (TNMEditionTableData row : this.data) {
            boolean matched = false;
            String rowStage = row.getStage();
            if (this.verbose) {
                logger.info("getStageData() - Comparing value from record " + stage + " VS values from table " + rowStage);
            }
            if (isNumeric) {
                String rowStageAsNumber = this.getNumericStage(rowStage);
                String recordStageAsNumber = this.getNumericStage(stage);
                if (this.verbose) {
                    logger.info("getStageData() - Converted numeric stage " + stage + " -> " + recordStageAsNumber);
                }
                matched = recordStageAsNumber.equalsIgnoreCase(rowStageAsNumber);
            } else {
                matched = stage.equalsIgnoreCase(rowStage);
            }
            if (!matched) continue;
            list.add(row);
        }
        return list;
    }

    public void setData(List<TNMEditionTableData> data) {
        if (logger.isTraceEnabled()) {
            logger.trace("setData() - Storing list of TNMEditionTableData for table: " + this.id);
            logger.trace("setData() - Data: " + String.valueOf(data));
        }
        for (TNMEditionTableData table : data) {
            table.setTableId(this.id);
        }
        this.data = data;
    }

    protected boolean isNumericStage(String stage) {
        String pattern = "^(\\d+|I{1,3}|IV|V|VI{1,3}|IX|X)$";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(stage);
        return matcher.matches() && stage.matches("\\d+|I{1,3}|IV|V|VI{1,3}|IX|X");
    }

    protected String getNumericStage(String stage) {
        if (stage == null) {
            return null;
        }
        if (stage.length() >= 2 && stage.substring(0, 2).equals("IV")) {
            return "IV";
        }
        String pattern = "^(\\d+|I{1,3}|IV|V|VI{1,3}|IX|X)";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(stage);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    protected void buildTopographyList() {
        if (this.topography == null) {
            return;
        }
        this.topography = this.topography.replaceAll("\\s", "");
        this.topographies = this.getRange(this.topography);
    }

    protected void buildTopographyExceptList() {
        if (this.topographyExcept == null) {
            return;
        }
        this.topographyExcept = this.topographyExcept.replaceAll("\\s", "");
        this.excludedTopographies = this.getRange(this.topographyExcept);
    }

    protected void buildMorphologyList(List<MorphologyGroup> morphologyGroups) {
        if (this.morphology == null) {
            return;
        }
        if (this.morphology.equals("any")) {
            return;
        }
        for (MorphologyGroup morphologyGroup : morphologyGroups) {
            String groupId = morphologyGroup.getId();
            if (groupId == null || !this.morphology.equals(groupId)) continue;
            this.morphologies = morphologyGroup.getMorphologyValues();
            break;
        }
    }

    protected void buildAge() {
        if (this.age == null) {
            return;
        }
        this.age = this.age.replaceAll("\\s", "");
        String the_age = new String(this.age);
        this.ageOperator = the_age.substring(0, 1);
        if (the_age.length() > 1 && the_age.substring(1, 2).equals("=")) {
            this.ageOperator = this.ageOperator + "=";
            the_age = the_age.substring(2);
        } else {
            the_age = the_age.substring(1);
        }
        this.ageBoundary = Integer.parseInt(the_age);
    }

    protected void buildAnyTNMLists() {
        this.anyT = new String();
        this.anyN = new String();
        this.anyM = new String();
        this.anyGrade = new String();
        if (this.data == null) {
            return;
        }
        for (TNMEditionTableData table : this.data) {
            String grade;
            String M;
            String N;
            table.buildCacheData();
            String T = "," + table.getT() + ",";
            if (T != null && T.indexOf("any") < 0 && this.anyT.indexOf(T) < 0) {
                this.anyT = this.anyT + T;
            }
            if ((N = "," + table.getN() + ",") != null && N.indexOf("any") < 0 && this.anyN.indexOf(N) < 0) {
                this.anyN = this.anyN + N;
            }
            if ((M = "," + table.getM() + ",") != null && M.indexOf("any") < 0 && this.anyM.indexOf(M) < 0) {
                this.anyM = this.anyM + M;
            }
            if ((grade = "," + table.getGrade() + ",") == null || grade.indexOf("any") >= 0 || this.anyGrade.indexOf(grade) >= 0) continue;
            this.anyGrade = this.anyGrade + grade;
        }
        this.anyT = this.anyT.replaceAll("\\,{2,}", ",");
        this.anyN = this.anyN.replaceAll("\\,{2,}", ",");
        this.anyM = this.anyM.replaceAll("\\,{2,}", ",");
        this.anyGrade = this.anyGrade.replaceAll("\\,{2,}", ",");
        if (this.verbose) {
            logger.info("buildAnyTNMLists() - Any T value : " + this.anyT);
            logger.info("buildAnyTNMLists() - Any N value : " + this.anyN);
            logger.info("buildAnyTNMLists() - Any M value : " + this.anyM);
            logger.info("buildAnyTNMLists() - Any Grade   : " + this.anyGrade);
        }
    }

    protected List<String> getRange(String expression) {
        if (expression == null) {
            logger.warn("getRange() - Ignoring null expression");
            return null;
        }
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("");
            logger.info("getRange() - Expanding expression : " + expression);
            logger.info("");
        }
        String[] tokens = expression.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String item : tokens) {
            if (debug) {
                logger.info("");
                logger.info("getRange() - Handling token       : " + item);
            }
            if (item.indexOf(45) < 0) {
                if (item.length() >= 4) {
                    result.add(item);
                    continue;
                }
                if (debug) {
                    logger.info("getRange() - Expanding value      : " + item);
                }
                for (int i = 0; i <= 9; ++i) {
                    String topo = item + String.valueOf(i);
                    result.add(topo);
                }
            } else {
                int i;
                Object[] limits = item.split("-");
                if (debug) {
                    logger.info("getRange() - Split on hyphen      : " + Arrays.toString(limits));
                }
                if (limits.length != 2 || ((String)limits[0]).length() <= 1 || ((String)limits[1]).length() <= 1) continue;
                for (i = ((String)limits[0]).length(); i < 4; ++i) {
                    limits[0] = (String)limits[0] + "0";
                }
                for (i = ((String)limits[1]).length(); i < 4; ++i) {
                    limits[1] = (String)limits[1] + "9";
                }
                if (debug) {
                    logger.info("getRange() - Adjusted tokens      : " + Arrays.toString(limits));
                }
                int startRange = Integer.parseInt(((String)limits[0]).substring(1));
                int endRange = Integer.parseInt(((String)limits[1]).substring(1));
                if (debug) {
                    logger.info("getRange() - Defined ranges       : " + startRange + " -> " + endRange);
                }
                for (int i2 = startRange; i2 <= endRange; ++i2) {
                    String value = ((String)limits[0]).substring(0, 1) + String.format("%03d", i2);
                    result.add(value);
                }
            }
            if (!debug) continue;
            logger.info("getRange() -         RESULT       : " + String.valueOf(result));
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTopography() {
        return this.topography;
    }

    public void setTopography(String topography) {
        this.topography = topography;
    }

    public String getTopographyExcept() {
        return this.topographyExcept;
    }

    public void setTopographyExcept(String topographyExcept) {
        this.topographyExcept = topographyExcept;
    }

    public String getMorphology() {
        return this.morphology;
    }

    public void setMorphology(String morphology) {
        this.morphology = morphology;
    }

    public String getAge() {
        return this.age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public List<TNMEditionTableData> getData() {
        return this.data;
    }

    public List<String> getTopographyList() {
        return this.topographies;
    }

    public List<String> getTopographyExceptList() {
        return this.excludedTopographies;
    }

    public List<String> getMorphologyList() {
        return this.morphologies;
    }

    public String getAgeOperator() {
        return this.ageOperator;
    }

    public int getAgeBoundary() {
        return this.ageBoundary;
    }

    public String getAnyT() {
        return this.anyT;
    }

    public String getAnyN() {
        return this.anyN;
    }

    public String getAnyM() {
        return this.anyM;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        builder.append(" -> topography:");
        builder.append(this.topography);
        if (this.topographyExcept != null) {
            builder.append(" except:");
            builder.append(this.topographyExcept);
        }
        builder.append(", morphology:");
        builder.append(this.morphology);
        if (this.age != null) {
            builder.append(", age:");
            builder.append(this.age);
        }
        if (this.ageOperator != null) {
            builder.append(", operator:");
            builder.append(this.ageOperator);
        }
        if (this.data != null && this.data.size() > 0) {
            builder.append(", data:");
            builder.append(this.data.size());
            builder.append(" elements\n");
            builder.append("1st data row: ");
            builder.append(this.data.get(0).toString());
            if (this.data.size() > 1) {
                builder.append("\n");
                builder.append("2nd data row: ");
                builder.append(this.data.get(1).toString());
            }
            if (this.data.size() > 4) {
                builder.append("\n..\n");
                builder.append("5th data row: ");
                builder.append(this.data.get(4).toString());
            }
        }
        return builder.toString();
    }

    public String getCacheAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        builder.append(" (cached):");
        builder.append("\n - Topography : ");
        builder.append(this.topographies);
        if (this.topographyExcept != null) {
            builder.append("\n - Except     : ");
            builder.append(this.excludedTopographies);
        }
        builder.append("\n - Morphology : ");
        if (this.morphologies != null) {
            builder.append(TNMEdition.getSample(this.morphologies, 10));
        } else {
            builder.append("null (\"any\" in config file)");
        }
        if (this.age != null) {
            builder.append("\n - Age bound  : ");
            builder.append(this.ageOperator);
            builder.append(" (boundary = ");
            builder.append(this.ageBoundary);
            builder.append(")");
        }
        builder.append("\n - T values   : ");
        builder.append(this.anyT);
        builder.append("\n - N values   : ");
        builder.append(this.anyN);
        builder.append("\n - M values   : ");
        builder.append(this.anyM);
        return builder.toString();
    }
}

