/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.MorphologyGroup;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEditionTable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMEdition {
    protected String number;
    protected List<MorphologyGroup> morphologies;
    protected List<TNMEditionTable> tables;
    protected static Logger logger = LoggerFactory.getLogger(TNMEdition.class);

    public void buildCacheData() {
        if (this.morphologies != null) {
            for (MorphologyGroup morphologyGroup : this.morphologies) {
                morphologyGroup.buildCacheData();
            }
        }
        ListIterator<TNMEditionTable> iterator = this.tables.listIterator();
        while (iterator.hasNext()) {
            TNMEditionTable table = iterator.next();
            if (table.getTopography() == null) {
                iterator.remove();
                logger.warn("buildCacheData() - Removed topography table with null topography value: " + table.getId());
                continue;
            }
            table.buildCacheData(this.morphologies);
        }
    }

    public List<TNMEditionTable> getTopographyTables(String topography) {
        ArrayList<TNMEditionTable> result = new ArrayList<TNMEditionTable>();
        boolean debug = logger.isTraceEnabled();
        for (TNMEditionTable table : this.tables) {
            if (debug) {
                logger.info("getTopographyTables() - Evaluating table: " + String.valueOf(table));
            }
            if (!table.addressTopography(topography)) continue;
            result.add(table);
            if (!debug) continue;
            logger.info("getTopographyTables() - Topography: " + topography + " FOUND in " + table.getId());
        }
        return result;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public List<MorphologyGroup> getMorphologies() {
        return this.morphologies;
    }

    public void setMorphologies(List<MorphologyGroup> morphologyGroups) {
        this.morphologies = morphologyGroups;
    }

    public List<TNMEditionTable> getTables() {
        return this.tables;
    }

    public void setTables(List<TNMEditionTable> tables) {
        this.tables = tables;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        List<String> morphologies = this.getAllMorphologyGroupsIDs();
        List<String> topographyTableIDs = this.getAllTopopraphyTableIDs();
        builder.append("TNMEdition:");
        builder.append(this.getNumber());
        builder.append(" - Morphologies:");
        builder.append(morphologies.size());
        if (morphologies != null) {
            builder.append(" (");
            if (morphologies.size() > 1) {
                builder.append(TNMEdition.getSample(morphologies, 5));
            } else {
                MorphologyGroup morphologyGroup = this.getMorphologies().get(0);
                List<String> morphologyValues = morphologyGroup.getMorphologyValues();
                builder.append(TNMEdition.getSample(morphologyValues, 10));
            }
            builder.append(")");
        }
        builder.append(" - TopographyTables:");
        builder.append(topographyTableIDs.size());
        if (topographyTableIDs != null) {
            builder.append(" (");
            builder.append(TNMEdition.getSample(topographyTableIDs, 5));
            builder.append(")");
        }
        return builder.toString();
    }

    public List<String> getAllMorphologyGroupsIDs() {
        ArrayList<String> groupIDs = new ArrayList<String>();
        List<MorphologyGroup> morphologyGroups = this.getMorphologies();
        if (morphologyGroups != null) {
            for (MorphologyGroup morphologyGroup : morphologyGroups) {
                if (morphologyGroup == null) continue;
                groupIDs.add(morphologyGroup.getId());
            }
        }
        return groupIDs;
    }

    public List<String> getAllTopopraphyTableIDs() {
        ArrayList<String> tableIDs = new ArrayList<String>();
        List<TNMEditionTable> topographyTables = this.getTables();
        if (topographyTables != null) {
            for (TNMEditionTable topographyTable : topographyTables) {
                if (topographyTable == null) continue;
                tableIDs.add(topographyTable.getId());
            }
        }
        return tableIDs;
    }

    public static String getSample(List<String> list, int max) {
        int i;
        if (list == null) {
            return "";
        }
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < list.size(); ++i) {
            builder.append(sep);
            builder.append(list.get(i));
            sep = ",";
            if (i >= max - 1) break;
        }
        if (i < list.size()) {
            builder.append("..");
            builder.append(list.get(list.size() - 1));
        }
        return builder.toString();
    }
}

