/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import eu.europa.ec.jrc.qcs.util.RangeProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeParser {
    protected static RangeProducer rangeProducer;
    protected int rangeStart = -1;
    protected int rangeEnd = -1;
    public static final char COLUM_SEPARATOR = ';';
    public static final char SEPARATOR = ',';
    public static final String RANGE = "-";
    public static final String SEP = ",";
    public static final String ANY = "Any";
    public static final int WRONG_BOUND = -1;
    public static final List<String> UNDEF;
    protected static Logger logger;

    public int[] expandIntegers(String string) {
        Object range;
        if (string == null || string.isEmpty()) {
            logger.warn("expandIntegers() - Failed to expand null string");
            return null;
        }
        if (string.contains(RANGE) && string.contains(SEP)) {
            String message = "Hybrid definitions are not handled yet: " + string;
            logger.error("expandIntegers() - " + message);
            throw new UnsupportedOperationException(message);
        }
        if (!string.contains(RANGE)) {
            String message = "Input argument is not a valid range: " + string;
            logger.error("expandIntegers() - " + message);
            throw new IllegalArgumentException(message);
        }
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("expandIntegers() - Input string: " + string);
        }
        if (string.contains(RANGE)) {
            if (debug) {
                logger.info("expandIntegers() - Handling range: " + string);
            }
            range = String.valueOf(RANGE);
            String[] tokens = string.split((String)range);
            this.rangeStart = Integer.parseInt(tokens[0]);
            this.rangeEnd = Integer.parseInt(tokens[1]);
            if (debug) {
                logger.info("expandIntegers() - Integer range): " + this.rangeStart + " -> " + this.rangeEnd);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographies() - Expanded topographis: " + this.rangeStart + " -> " + this.rangeEnd);
        }
        range = new int[]{this.rangeStart, this.rangeEnd};
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographies() - Returnin array: " + Arrays.toString((int[])range));
        }
        return range;
    }

    public String expandIntegersAsString(String string) {
        if (string == null || string.isEmpty()) {
            logger.warn("expandIntegersAsString() - Failed to expand null string");
            return null;
        }
        if (string.contains(RANGE) && string.contains(SEP)) {
            String message = "Hybrid definitions are not handled yet: " + string;
            logger.error("expandIntegersAsString() - " + message);
            throw new UnsupportedOperationException(message);
        }
        if (!string.contains(RANGE)) {
            return string;
        }
        int[] range = this.expandIntegers(string);
        RangeProducer rangeProducer = new RangeProducer();
        if (logger.isTraceEnabled()) {
            logger.trace("expandIntegersAsString() - Expandins string: " + string);
        }
        String listAsAstring = rangeProducer.getRangeValuesAsString(range[0], range[1]);
        return listAsAstring;
    }

    public List<String> expandIntegersAsList(String line, int columnIndex) {
        String separator;
        String[] tokens;
        String columnSeparator = String.valueOf(';');
        String values = line.split(columnSeparator)[columnIndex];
        if (logger.isTraceEnabled()) {
            logger.trace("expandIntegersAsList() - Input line (to be expanded): " + line);
        }
        if ((tokens = values.split(separator = String.valueOf(RANGE))) == null || tokens.length != 2) {
            if (logger.isTraceEnabled()) {
                logger.trace("expandIntegersAsList - Nothing to expand for token: " + values);
            }
            return UNDEF;
        }
        List<String> expandedLine = rangeProducer.getRangeAsList(tokens[0], tokens[1]);
        if (logger.isTraceEnabled()) {
            logger.trace("expandIntegersAsList - Expanded line: " + String.valueOf(expandedLine));
        }
        return expandedLine;
    }

    public int getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(int rangeStart) {
        this.rangeStart = rangeStart;
    }

    public int getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(int rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    static {
        UNDEF = new ArrayList<String>();
        logger = LoggerFactory.getLogger(RangeParser.class);
        rangeProducer = new RangeProducer();
    }
}

