/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphologyGroup {
    protected String id = null;
    protected String description = null;
    protected String data = null;
    protected List<String> morphologyValues = null;
    protected static Logger logger = LoggerFactory.getLogger(MorphologyGroup.class);

    public void buildCacheData() {
        this.exapandMorphologyData();
    }

    protected void exapandMorphologyData() {
        String[] tokens;
        this.morphologyValues = new ArrayList<String>();
        if (this.data == null) {
            return;
        }
        this.data = this.data.replaceAll("\\s", "");
        for (String item : tokens = this.data.split(",")) {
            if (item.indexOf(45) < 0) {
                this.morphologyValues.add(item);
                continue;
            }
            String[] limits = item.split("-");
            if (limits.length != 2 || limits[0].length() <= 3 || limits[1].length() <= 3) continue;
            int startRange = Integer.parseInt(limits[0]);
            int endRange = Integer.parseInt(limits[1]);
            for (int i = startRange; i <= endRange; ++i) {
                this.morphologyValues.add(String.valueOf(i));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<String> getMorphologyValues() {
        return this.morphologyValues;
    }
}

