/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util;

import eu.europa.ec.jrc.qcs.util.RangeProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BoDCondition {
    protected String morphology;
    protected List<String> morphologyList;
    protected Set<String> morphologySet;
    protected String topography;
    protected List<String> topographyList;
    protected String behaviour;
    protected int startAge = -1;
    protected int endAge = -1;
    protected String sex;
    protected boolean allowed;
    public static final String FEMALE = "2";

    public BoDCondition(String morphology, boolean allowed) {
        this.morphology = morphology;
        this.allowed = allowed;
    }

    public BoDCondition(List<String> morphology, boolean allowed) {
        this.morphologyList = morphology;
        this.allowed = allowed;
    }

    public BoDCondition(List<String> morphology, String topography, boolean allowed) {
        this.morphologyList = morphology;
        this.topography = topography;
        this.allowed = allowed;
    }

    public BoDCondition(List<String> morphology, List<String> topography, boolean allowed) {
        this.morphologyList = morphology;
        this.topographyList = topography;
        this.allowed = allowed;
    }

    public BoDCondition(Set<String> morphology, boolean allowed) {
        this.morphologySet = morphology;
        this.allowed = allowed;
    }

    public BoDCondition(String morphology, int startAge, int endAge, boolean allowed) {
        this.morphology = morphology;
        this.startAge = startAge;
        this.endAge = endAge;
        this.allowed = allowed;
    }

    public BoDCondition(String morphology, String topography, boolean allowed) {
        this.morphology = morphology;
        this.topography = topography;
        this.allowed = allowed;
    }

    public BoDCondition(String morphology, String topography, String behaviour, boolean allowed) {
        this.morphology = morphology;
        this.topography = topography;
        this.behaviour = behaviour;
        this.allowed = allowed;
    }

    public boolean onlyMorphology() {
        return this.topography == null && this.topographyList == null && this.behaviour == null && this.startAge < 0 && this.endAge < 0;
    }

    public boolean involvesAge() {
        return this.startAge >= 0 || this.endAge >= 0;
    }

    public boolean involvesTopography() {
        return this.topography != null || this.topographyList != null;
    }

    public boolean involvesBehaviour() {
        return this.behaviour != null;
    }

    public boolean involvesSex() {
        return this.sex != null;
    }

    public String getMorphology() {
        return this.morphology;
    }

    public void setMorphology(String morphology) {
        this.morphology = morphology;
    }

    public List<String> getMorphologyList() {
        return this.morphologyList;
    }

    public void setMorphologyList(List<String> morphologyList) {
        this.morphologyList = morphologyList;
    }

    public Set<String> getMorphologySet() {
        return this.morphologySet;
    }

    public void setMorphologySet(Set<String> morphologySet) {
        this.morphologySet = morphologySet;
    }

    public String getTopography() {
        return this.topography;
    }

    public void setTopography(String topography) {
        this.topography = topography;
    }

    public List<String> getTopographyList() {
        return this.topographyList;
    }

    public void setTopographyList(List<String> topographyList) {
        this.topographyList = topographyList;
    }

    public String getBehaviour() {
        return this.behaviour;
    }

    public void setBehaviour(String behaviour) {
        this.behaviour = behaviour;
    }

    public int getStartAge() {
        return this.startAge;
    }

    public void setStartAge(int startAge) {
        this.startAge = startAge;
    }

    public int getEndAge() {
        return this.endAge;
    }

    public void setEndAge(int endAge) {
        this.endAge = endAge;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.morphology != null) {
            builder.append(this.morphology);
        } else if (this.morphologySet != null) {
            builder.append("MorphoSet(" + this.morphologySet.size() + ") ");
        } else if (this.morphologyList != null) {
            builder.append("MorphoList(" + this.morphologyList.size() + ") ");
        }
        if (this.topography != null) {
            builder.append("-");
            builder.append(this.topography);
        } else if (this.topographyList != null) {
            builder.append("TopoList(" + this.topographyList.size() + ") ");
        }
        if (this.behaviour != null) {
            builder.append("-");
            builder.append(this.behaviour);
        }
        if (this.sex != null) {
            builder.append("-");
            builder.append(this.sex);
        }
        if (this.startAge >= 0 || this.endAge >= 0) {
            builder.append(" (");
            builder.append(this.startAge);
            builder.append("..");
            builder.append(this.endAge);
            builder.append(")");
        }
        builder.append(" -> " + this.allowed);
        return builder.toString();
    }

    public static List<String> getListFromRange(String start, String end) {
        boolean loop = true;
        String value = start;
        ArrayList<String> result = new ArrayList<String>();
        RangeProducer rangeProducer = new RangeProducer();
        while (loop) {
            result.add(value);
            value = rangeProducer.incrementAlphaNumeric(value, true);
            loop = !value.equals(end);
        }
        result.add(value);
        return result;
    }

    public static String formatListOfConditions(List<BoDCondition> list) {
        StringBuilder builder = new StringBuilder();
        for (BoDCondition c : list) {
            builder.append(c);
            builder.append("\n");
        }
        return builder.toString();
    }
}

