/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsBiggerThanRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(IsBiggerThanRule.class);

    public IsBiggerThanRule(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        RuleConfiguration cfg = this.getRuleConfiguration();
        if (cfg.getCaseSensitivity() != CaseSensitivity.INSENSITIVE) {
            String message = "IsBiggerThanRule case sensitivity cannot be set to " + String.valueOf((Object)cfg.getCaseSensitivity()) + ". Forcing to " + String.valueOf((Object)CaseSensitivity.INSENSITIVE);
            logger.error(message);
            cfg.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
        }
        this.setLongDescription("Checks the if the first number is bigger than the second one.\n\nExample: if this rule is applied on the pair (incidenceYear, birthYear), the record is considered valid only if incidenceYear is greater than birthYear.\nIf the incidenceYear is equal or smaller than the birthYear, the record is marked as invalid.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        int yearOfBirth;
        RuleConfiguration configuration = this.getRuleConfiguration();
        Field field_1 = configuration.getFieldByPosition(1);
        Field field_2 = configuration.getFieldByPosition(2);
        String value_1 = this.getFieldValue(field_1);
        String value_2 = this.getFieldValue(field_2);
        int yearOfIncidence = this.parseIntegerValue(value_1);
        boolean isValid = this.isBiggerThan(yearOfIncidence, yearOfBirth = this.parseIntegerValue(value_2));
        if (!isValid) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(field_1, yearOfIncidence));
            fieldValues.add(new FieldValue(field_2, yearOfBirth));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    protected boolean isBiggerThan(int first, int second) {
        return first > second;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param_1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param_2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOB.id, false);
        defaultRuleParameters.add(param_1);
        defaultRuleParameters.add(param_2);
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ruleConfiguration.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
    }
}

