/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield;

import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFunctionRule
extends GenericRule {
    protected static Logger logger = LoggerFactory.getLogger(GenericFunctionRule.class);

    public GenericFunctionRule(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
    }

    @Override
    public boolean validate() {
        Object message;
        if (this.ruleConfiguration.getRuleTarget() != RuleTarget.SOME_FIELDS) {
            message = "Sanity rules cannot be set to " + String.valueOf((Object)this.ruleConfiguration.getRuleTarget()) + ". Forcing it to " + String.valueOf((Object)RuleTarget.SOME_FIELDS);
            this.ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
            if (logger.isWarnEnabled()) {
                logger.warn((String)message);
            }
        }
        if (!super.validate()) {
            message = "Sanity rule with invalid configuration (generic validation failed)";
            logger.error((String)message);
            return false;
        }
        return true;
    }

    @Override
    protected void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        this.ruleConfiguration.setRuleType(RuleType.FUNCTION);
        this.ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
    }
}

