/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerTXT;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericCrossFieldRule
extends GenericRule {
    protected static Logger logger = LoggerFactory.getLogger(GenericCrossFieldRule.class);

    public GenericCrossFieldRule(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
    }

    protected List<String> loadConfigurationData(String filename) {
        List<String> configData;
        String configurationPath = this.getRuleConfiguration().getConfigurationPath();
        if (logger.isDebugEnabled()) {
            logger.debug("loadConfigurationData(file) - configurationPath: " + configurationPath + " -> " + filename);
        }
        if ((configData = this.loadConfigurationData(configurationPath, filename)) == null || configData.isEmpty()) {
            String path = configurationPath.replace("config", "configuration");
            if (logger.isWarnEnabled()) {
                logger.warn("loadConfigurationData(file) - File not found in directory : " + configurationPath);
                logger.warn("loadConfigurationData(file) - Retry with                  : " + path + "/" + filename);
            }
            configData = this.loadConfigurationData(path, filename);
        }
        return configData;
    }

    protected List<String> loadConfigurationData(String basePath, String filename) {
        List<String> configData = null;
        if (logger.isDebugEnabled()) {
            logger.debug("loadConfigurationData(path) - configurationPath: " + basePath + " -> " + filename);
        }
        try {
            FileConnection connection = new FileConnection(filename, basePath);
            FileHandlerTXT<String> fileHandler = new FileHandlerTXT<String>(connection);
            fileHandler.setType(String.class);
            configData = fileHandler.readFile();
        }
        catch (Exception e) {
            if (!basePath.contains("config")) {
                logger.error("loadConfigurationData(path) - Error loading configuration file : " + filename + " : " + e.getMessage());
                logger.error("loadConfigurationData(path) - Configuration path               : " + basePath);
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadConfigurationData(path) - Loaded config file: " + basePath + " -> " + filename);
        }
        return configData;
    }

    @Override
    public boolean validate() {
        Object message;
        if (this.ruleConfiguration.getRuleTarget() != RuleTarget.SOME_FIELDS) {
            message = "Cross-fields rules cannot be set to " + String.valueOf((Object)this.ruleConfiguration.getRuleTarget()) + ". Forcing it to " + String.valueOf((Object)RuleTarget.SOME_FIELDS);
            this.ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
            if (logger.isWarnEnabled()) {
                logger.warn((String)message);
            }
        }
        if (!super.validate()) {
            message = "Cross-fields rule with invalid configuration (generic validation failed)";
            logger.error((String)message);
            return false;
        }
        return true;
    }

    protected List<RuleOutput> getInvalidRuleOutput() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<Field> allFields = ruleConfiguration.getAllFields();
        ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
        for (Field field : allFields) {
            String value = this.getFieldValue(field);
            fieldValues.add(new FieldValue(field, value));
        }
        this.addErrorDetail(fieldValues);
        return this.getRuleOutput();
    }

    @Override
    protected void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        this.ruleConfiguration.setRuleType(RuleType.CROSS_FIELD);
        this.ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
    }
}

