/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield;

import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.GenericFunctionRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeByMonthYear
extends GenericFunctionRule {
    protected static Logger logger = LoggerFactory.getLogger(AgeByMonthYear.class);

    public AgeByMonthYear(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        RuleConfiguration cfg = this.getRuleConfiguration();
        if (cfg.getCaseSensitivity() != CaseSensitivity.INSENSITIVE) {
            String message = "AgeByDayMonthYear case sensitivity cannot be set to " + String.valueOf((Object)cfg.getCaseSensitivity()) + ". Forcing to " + String.valueOf((Object)CaseSensitivity.INSENSITIVE);
            logger.warn(message);
            cfg.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
        }
        this.setLongDescription("Calculates the difference (aka \"age\") between two dates.\n\n1. If any of the year variable is missing or empty, age is set to -1.\n2. The <em>day</em> variable is assumed to have the value \"15\" (this because it's always missing).\n3. If any of the month variable is missing or empty, the age is evaluated by comparing only the year variables.\nIf all variables are correctly defined the age is evaluated using the normal common sense criterion.\n");
    }

    @Override
    protected List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field monthDoB_field = ruleConfiguration.getFieldByPosition(1);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(2);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(3);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(4);
        if (logger.isDebugEnabled()) {
            logger.debug("Calculating age in years for fields: " + String.valueOf(ruleConfiguration.getAllFields()));
        }
        int ageInYears = this.calculateAge(monthDoB_field, yearDoB_field, monthDoI_field, yearDoI_field);
        String age = String.valueOf(ageInYears);
        if (logger.isDebugEnabled()) {
            logger.debug("Calculated age in years = " + age);
        }
        DataRecord record = (DataRecord)this.ruleInput;
        record.setFunctionValue(DefaultRuleID.AGE_BY_MONTH_YEAR.id, age);
        return RuleOutput.VALID;
    }

    protected int calculateAge(Field month_1_field, Field year_1_field, Field month_2_field, Field year_2_field) {
        String month_1 = this.getFieldValue(month_1_field);
        String year_1 = this.getFieldValue(year_1_field);
        String month_2 = this.getFieldValue(month_2_field);
        String year_2 = this.getFieldValue(year_2_field);
        if (!this.isValidField(year_1_field) || !this.isValidField(year_2_field)) {
            return -1;
        }
        int year_1_int = this.parseIntegerValue(year_1);
        int year_2_int = this.parseIntegerValue(year_2);
        int age = year_2_int - year_1_int;
        int day_1_int = 15;
        int day_2_int = 15;
        if (!this.isValidField(month_1_field) || !this.isValidField(month_2_field)) {
            age = year_2_int - year_1_int;
        }
        int roughAge = year_2_int - year_1_int;
        int month_1_int = this.parseIntegerValue(month_1);
        int month_2_int = this.parseIntegerValue(month_2);
        if (this.isValidField(month_1_field) && this.isValidField(year_1_field) && this.isValidField(month_2_field) && this.isValidField(year_2_field)) {
            age = this.adjustAge(roughAge, day_1_int, month_1_int, day_2_int, month_2_int);
        }
        if (age < 0) {
            age = 0;
        }
        return age;
    }

    protected int adjustAge(int age, int day_1, int month_1, int day_2, int month_2) {
        if (this.isBirthdayPassed(day_1, month_1, day_2, month_2)) {
            return age;
        }
        return age - 1;
    }

    protected boolean isBirthdayPassed(int day_1, int month_1, int day_2, int month_2) {
        if (month_2 > month_1) {
            return true;
        }
        return month_2 == month_1 && day_2 >= day_1;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(DefaultSchemaID.INCIDENCE_2020_DEFAULT.id);
        this.ruleConfiguration.setDefaultSchemaView(schemaView);
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        this.ruleConfiguration.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

