/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.basic;

import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFormatRule
extends GenericRule {
    protected static Logger logger = LoggerFactory.getLogger(RecordFormatRule.class);

    public RecordFormatRule(RuleDefinition rule) {
        super(rule);
        if (rule.getCaseSensitivity() != CaseSensitivity.INSENSITIVE) {
            rule.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
            String message = "RecordFormatRule cannot be set to " + String.valueOf((Object)rule.getCaseSensitivity()) + ". Forcing it to " + String.valueOf((Object)rule.getCaseSensitivity());
            logger.error(message);
        }
        this.longDescription = "Checks that each record has exactly the same number of fields (aka colums or variables) of the current schema.";
    }

    @Override
    public List<RuleOutput> applyCheck() {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        int expectedFields = schemaView.getNumberOfFields();
        DataRecord record = (DataRecord)this.ruleInput;
        int numberOfFieldsInRecord = record.getSize();
        if (numberOfFieldsInRecord != expectedFields) {
            this.addSingleError();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(DefaultSchemaID.INCIDENCE_2014_DEFAULT.id);
        this.ruleConfiguration.setDefaultSchemaView(schemaView);
        this.ruleConfiguration.setRuleType(RuleType.RECORD_FORMAT);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setDefaultRuleParameters(RuleParameter.ALL_FIELDS);
    }

    @Override
    public boolean validate() {
        if (this.ruleConfiguration.getRuleTarget() != RuleTarget.ALL_FIELDS) {
            String message = "RecordFormatRule cannot be set to " + String.valueOf((Object)this.ruleConfiguration.getRuleTarget()) + ". Forcing it to " + String.valueOf((Object)RuleTarget.ALL_FIELDS);
            logger.error(message);
            this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        }
        return super.validate();
    }
}

