/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.basic;

import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionalHeaderRule
extends GenericRule {
    protected static Logger logger = LoggerFactory.getLogger(PositionalHeaderRule.class);

    public PositionalHeaderRule(RuleDefinition rule) {
        super(rule);
        this.longDescription = "Checks the header by comparing it with the schema's expected one. This is done looping through the array representation of the input header, and comparing each header's value with the expected one (for that position). Therefore, if the input header has a wrong number of elements, or if they are sorted in a different order, the input record is marked as invalid.";
    }

    @Override
    public List<RuleOutput> applyCheck() {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.info("Applying check on schemaView : " + String.valueOf(schemaView));
        }
        if (debug) {
            logger.info("Applying check on RuleInput : " + String.valueOf(this.ruleInput));
        }
        DataRecord record = (DataRecord)this.ruleInput;
        String[] recordFields = record.getArray();
        int numberOfRecordFields = record.getSize();
        List<RuleParameter> ruleParameters = this.getRuleConfiguration().getRuleParameters();
        if (ruleParameters == RuleParameter.ALL_FIELDS) {
            if (debug) {
                logger.info("Applying check on ALL fields (" + numberOfRecordFields + " fields)");
            }
            for (int position = 1; position <= numberOfRecordFields; ++position) {
                this.checkSinglePosition(schemaView, recordFields, position);
            }
        } else {
            if (debug) {
                logger.info("Applying check on " + ruleParameters.size() + " fields");
            }
            for (RuleParameter ruleParameter : ruleParameters) {
                int fieldID = ruleParameter.getFieldID();
                int position = schemaView.getFieldPosition(fieldID);
                this.checkSinglePosition(schemaView, recordFields, position);
            }
        }
        if (debug) {
            for (RuleOutput ruleOutput : this.getRuleOutput()) {
                logger.info("applyCheck() - ruleOutput : " + String.valueOf(ruleOutput));
                for (RuleOutputDetail ruleOutputDetail : ruleOutput.getAllRuleOutputDetail()) {
                    logger.info("\tRuleOutputDetail : " + String.valueOf(ruleOutputDetail));
                }
            }
        }
        return this.getRuleOutput();
    }

    protected void checkSinglePosition(SchemaView schemaView, String[] recordFields, int position) {
        Field schemaField = schemaView.getFieldByPosition(position);
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.info("checkSinglePosition() - " + position + " -> " + String.valueOf(schemaField));
        }
        if (recordFields[position - 1] == null) {
            this.addErrorDetail(schemaField, null);
            return;
        }
        boolean caseSensitive = this.isCaseSensitive(schemaField);
        String recordField = recordFields[position - 1];
        if (debug) {
            logger.info("checkSinglePosition() - Comparing #" + recordField + "# VS #" + schemaField.getName() + "#");
        }
        if (caseSensitive) {
            if (!recordField.equals(schemaField.getName())) {
                this.addErrorDetail(schemaField, recordField);
            }
        } else if (!recordField.equalsIgnoreCase(schemaField.getName())) {
            this.addErrorDetail(schemaField, recordField);
        }
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(DefaultSchemaID.INCIDENCE_2014_DEFAULT.id);
        this.ruleConfiguration.setDefaultSchemaView(schemaView);
        this.ruleConfiguration.setRuleType(RuleType.HEADER);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setDefaultRuleParameters(RuleParameter.ALL_FIELDS);
    }
}

