/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.basic;

import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedHeaderRule
extends GenericRule {
    protected static Logger logger = LoggerFactory.getLogger(NamedHeaderRule.class);

    public NamedHeaderRule(RuleDefinition rule) {
        super(rule);
        this.longDescription = "Checks the file's header comparing it with the schema's expected one. This is done looping through the array representation of the input header, and checking if each header's value belongs to the list of expected header values. If some headers are not found, an error is raised.\nThis rule detects also 'extra' headers, i.e. finds any headers which is declared in the input file, but it's not expected by the current schema.\nThis is done regardless of the columns order. Therefore, if all headers are present, but not in the expected order, the file's header is considered valid.";
    }

    @Override
    public List<RuleOutput> applyCheck() {
        int i;
        boolean verbose = false;
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        DataRecord record = (DataRecord)this.ruleInput;
        String[] recordFields = record.getArray();
        List<Field> schemaFields = schemaView.getFields();
        ArrayList<String> schemaHeaders = new ArrayList<String>();
        for (Field field : schemaFields) {
            schemaHeaders.add(field.getName());
        }
        ArrayList<String> inputHeaders = new ArrayList<String>(Arrays.asList(recordFields));
        if (this.getRuleConfiguration().getCaseSensitivity() != CaseSensitivity.FIELD_LEVEL) {
            this.handleCaseSensitivity(schemaHeaders, inputHeaders);
        }
        ListIterator iterator = schemaHeaders.listIterator();
        while (iterator.hasNext()) {
            String header = (String)iterator.next();
            String hay = this.getNeedleFromHaystack(header, inputHeaders);
            if (hay == null) continue;
            iterator.remove();
            inputHeaders.remove(new String(hay));
        }
        if (verbose) {
            logger.info("Expected headers, but missing in the input header : " + String.valueOf(schemaHeaders));
        }
        if (verbose) {
            logger.info("Headers present in the input, but not expected    : " + String.valueOf(inputHeaders));
        }
        if (RuleTarget.SOME_FIELDS == this.getRuleConfiguration().getRuleTarget()) {
            this.filterTarget(schemaHeaders);
            inputHeaders = new ArrayList();
        }
        ArrayList<String> detailValues = new ArrayList<String>(schemaHeaders.size());
        boolean guessWrongHeaders = inputHeaders.size() == schemaHeaders.size() && schemaHeaders.size() == inputHeaders.size();
        for (i = 0; i < schemaHeaders.size(); ++i) {
            if (guessWrongHeaders) {
                detailValues.add((String)inputHeaders.get(i));
                continue;
            }
            detailValues.add("Missing");
        }
        if (verbose) {
            logger.info("GuessWrongHeaders = " + guessWrongHeaders + ", details = " + String.valueOf(detailValues));
        }
        for (i = 0; i < schemaHeaders.size(); ++i) {
            String expected = (String)schemaHeaders.get(i);
            this.addErrorDetail(expected, (String)detailValues.get(i));
        }
        if (!guessWrongHeaders && inputHeaders.size() > 0) {
            for (String extra : inputHeaders) {
                this.addErrorDetail(extra);
            }
        }
        return this.getRuleOutput();
    }

    protected void handleCaseSensitivity(List<String> schemaHeaders, List<String> inputHeaders) {
        if (this.getRuleConfiguration().getCaseSensitivity() == CaseSensitivity.SENSITIVE) {
            return;
        }
        if (this.getRuleConfiguration().getCaseSensitivity() == CaseSensitivity.INSENSITIVE) {
            this.toUpperCase(schemaHeaders);
            this.toUpperCase(inputHeaders);
        }
    }

    public void toUpperCase(List<String> list) {
        ListIterator<String> iterator = list.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toUpperCase());
        }
    }

    protected void filterTarget(List<String> missingHeaders) {
        List<String> targetFields = this.getRuleConfiguration().getRuleParametersNames();
        if (this.getRuleConfiguration().getCaseSensitivity() == CaseSensitivity.INSENSITIVE) {
            this.toUpperCase(targetFields);
        }
        ListIterator<String> iterator = missingHeaders.listIterator();
        while (iterator.hasNext()) {
            String needle = iterator.next();
            String hay = this.getNeedleFromHaystack(needle, targetFields);
            if (hay != null) continue;
            iterator.remove();
        }
    }

    protected String getNeedleFromHaystack(String needle, List<String> haystack) {
        if (this.getRuleConfiguration().getCaseSensitivity() != CaseSensitivity.FIELD_LEVEL) {
            if (haystack.contains(needle)) {
                return needle;
            }
        } else {
            SchemaView schemaView = this.getRuleConfiguration().getDefaultSchemaView();
            Field schemaField = schemaView.getFieldByName(needle);
            boolean caseSensitive = this.isCaseSensitive(schemaField);
            for (String hay : haystack) {
                if (!(caseSensitive ? needle.equals(hay) : needle.equalsIgnoreCase(hay))) continue;
                return hay;
            }
        }
        return null;
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(DefaultSchemaID.INCIDENCE_2014_DEFAULT.id);
        this.ruleConfiguration.setDefaultSchemaView(schemaView);
        this.ruleConfiguration.setRuleType(RuleType.HEADER);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setDefaultRuleParameters(RuleParameter.ALL_FIELDS);
    }
}

