/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.basic;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSizeRule
extends GenericRule {
    public static final int MIN_SIZE = 4;
    public static final long MAX_SIZE = 0xA0000000000L;
    protected static Logger logger = LoggerFactory.getLogger(FileSizeRule.class);

    public FileSizeRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("Check that the input file has size between the minimal and maximum allowed size (in bytes, KB or MB).");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        FileConnection connection = this.getFileConnection();
        File file = connection.getFile();
        if (logger.isDebugEnabled()) {
            logger.debug("Checking file        : " + String.valueOf(file));
        }
        long fileSize = file.length();
        if (logger.isDebugEnabled()) {
            logger.debug("File size            : " + fileSize);
        }
        if (fileSize < 4L) {
            this.addSingleError();
        }
        if (fileSize > 0xA0000000000L) {
            this.addSingleError();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        this.ruleConfiguration.setRuleType(RuleType.FILE_FORMAT);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setDefaultRuleParameters(RuleParameter.ALL_FIELDS);
    }
}

