/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.basic;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEncodingRule
extends GenericRule {
    public static final String ENCODING = "UTF-8";
    protected static Logger logger = LoggerFactory.getLogger(FileEncodingRule.class);

    public FileEncodingRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("Check that the input file matches one of the supported encoding formats (e.g. UTF-8).");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        FileConnection connection = this.getFileConnection();
        File file = connection.getFile();
        if (logger.isDebugEnabled()) {
            logger.debug("Checking file        : " + String.valueOf(file));
        }
        String[] allCharsets = new String[]{ENCODING, "UTF-16", "UTF-32"};
        Charset charset = this.findCharset(file, allCharsets);
        if (logger.isInfoEnabled()) {
            logger.info("Detected charset     : " + String.valueOf(charset));
        }
        if (charset != null) {
            if (!ENCODING.equalsIgnoreCase(charset.toString())) {
                this.addSingleError();
            }
        } else {
            logger.warn("Unrecognized charset!");
            this.addSingleError();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        this.ruleConfiguration.setRuleType(RuleType.FILE_FORMAT);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setDefaultRuleParameters(RuleParameter.ALL_FIELDS);
    }

    protected Charset findCharset(File file, String[] charsets) {
        String charsetName;
        Charset charset = null;
        String[] stringArray = charsets;
        int n = stringArray.length;
        for (int i = 0; i < n && (charset = this.findCharset(file, Charset.forName(charsetName = stringArray[i]))) == null; ++i) {
        }
        return charset;
    }

    protected Charset findCharset(File file, Charset charset) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            if (logger.isDebugEnabled()) {
                logger.debug("Check " + String.valueOf(charset) + " for file : " + String.valueOf(file));
            }
            CharsetDecoder decoder = charset.newDecoder();
            decoder.reset();
            boolean identified = false;
            byte[] buffer = new byte[512];
            while (inputStream.read(buffer) != -1 && !identified) {
                identified = this.decode(buffer, decoder);
            }
            inputStream.close();
            if (identified) {
                return charset;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean decode(byte[] bytes, CharsetDecoder decoder) {
        CharBuffer buffer = null;
        try {
            buffer = decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e1) {
            return false;
        }
        catch (Exception e2) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("decode() - CharBuffer: " + String.valueOf(buffer));
        }
        return true;
    }

    private void readFile(File file, Charset charset) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            int the_char = 0;
            while ((the_char = reader.read()) != -1) {
                System.out.print((char)the_char);
            }
            reader.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

