/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule;

import eu.europa.ec.jrc.qcs.dao.model.GenericEntity;
import java.util.ArrayList;
import java.util.List;

public class RuleParameter
extends GenericEntity {
    private int position;
    private int fieldID;
    private boolean key;
    public static final List<RuleParameter> ALL_FIELDS = new ArrayList<RuleParameter>();
    public static final RuleParameter UNDEF = new RuleParameter();

    public RuleParameter() {
    }

    public RuleParameter(int fieldID) {
        this.fieldID = fieldID;
    }

    public RuleParameter(int position, int fieldID, boolean key) {
        this.position = position;
        this.fieldID = fieldID;
        this.key = key;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(int fieldID) {
        this.fieldID = fieldID;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleParameter other = (RuleParameter)obj;
        if (this.fieldID != other.fieldID) {
            return false;
        }
        if (this.key != other.key) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("");
        builder.append(this.getIntegerLabel(this.position));
        builder.append(" -> ");
        builder.append(this.getIntegerLabel(this.fieldID));
        if (this.key) {
            builder.append(" (key)");
        }
        return builder.toString();
    }

    public static String getFormattedFieldIDs(List<RuleParameter> list) {
        String sep = "";
        StringBuilder builder = new StringBuilder("");
        for (RuleParameter ruleParameter : list) {
            builder.append(sep);
            builder.append(ruleParameter.getFieldID());
            sep = ",";
        }
        return builder.toString();
    }

    public static String getFormattedRuleParameters(List<RuleParameter> list) {
        if (list == null) {
            return "";
        }
        String sep = "";
        StringBuilder builder = new StringBuilder("");
        for (RuleParameter ruleParameter : list) {
            builder.append(sep);
            if (ruleParameter != UNDEF) {
                builder.append(ruleParameter);
                sep = ", ";
                continue;
            }
            builder.append("Undef");
        }
        return builder.toString();
    }
}

