/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleScope;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.dao.model.schema.DataType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleConfiguration {
    protected boolean valid;
    protected boolean checked;
    protected boolean positive;
    protected CaseSensitivity caseSensitivity;
    protected ValidationMessage validationMessage;
    protected RuleType ruleType;
    protected int priority;
    protected boolean blocking;
    protected RuleTarget ruleTarget;
    protected List<RuleParameter> ruleParameters;
    protected boolean defaultTarget = true;
    protected int protocolID;
    protected SchemaView defaultSchemaView;
    protected SchemaView targetSchemaView;
    protected List<Integer> preparatoryRuleIDs;
    protected List<Integer> functionRuleIDs;
    protected List<RuleParameter> defaultRuleParameters;
    protected List<LocalFile> configurationFiles;
    protected String configurationPath;
    protected static Logger logger = LoggerFactory.getLogger(RuleConfiguration.class);

    public boolean validate() {
        this.valid = false;
        this.checked = true;
        if (this.getRuleTarget() == RuleTarget.UNDEF || this.getRuleTarget() == RuleTarget.WRONG) {
            String message = "Wrong or missing rule's target configuration: " + String.valueOf((Object)this.getRuleTarget());
            throw new InvalidRuleConfiguration(message);
        }
        if (this.getRuleTarget() == RuleTarget.ALL_FIELDS && this.getRuleParameters() != RuleParameter.ALL_FIELDS) {
            String message = "Rule's target set to ALL_FIELDS but wrong rule's parameters: " + String.valueOf(this.getRuleParameters());
            throw new InvalidRuleConfiguration(message);
        }
        if (this.getRuleTarget() == RuleTarget.SOME_FIELDS && this.getRuleParameters() == null) {
            String message = "Rule's target set to SOME_FIELDS but null rule's parameters";
            throw new InvalidRuleConfiguration(message);
        }
        if (this.getRuleTarget() == RuleTarget.SOME_FIELDS && this.getRuleParameters().size() < 1) {
            String message = "Rule's target set to SOME_FIELDS but empty rule's parameters";
            throw new InvalidRuleConfiguration(message);
        }
        if (this.getRuleTarget() == RuleTarget.SOME_FIELDS && this.getRuleType() == RuleType.CROSS_FIELD) {
            int expectedNumberOfParameters = 0;
            int foundNumberOfParameters = this.getRuleParameters().size();
            if (this.defaultRuleParameters != null) {
                expectedNumberOfParameters = this.defaultRuleParameters.size();
            }
            if (foundNumberOfParameters != expectedNumberOfParameters) {
                String message = "Rule's target set to SOME_FIELDS but wrong number of parameters (" + foundNumberOfParameters + "). Expected number is: " + expectedNumberOfParameters;
                throw new InvalidRuleConfiguration(message);
            }
        }
        if (this.getRuleTarget() == RuleTarget.SOME_FIELDS && this.getRuleType() == RuleType.CROSS_FIELD) {
            for (RuleParameter ruleParameter : this.getRuleParameters()) {
                boolean compatible;
                int position = ruleParameter.getPosition();
                Field targetField = this.getFieldByTargetParameter(ruleParameter);
                DataType targetDataType = targetField.getDataType();
                boolean verbose = logger.isDebugEnabled();
                if (verbose) {
                    logger.info("validate() - Target RuleParameter: " + String.valueOf(ruleParameter) + " -> " + String.valueOf(targetField));
                }
                RuleParameter defaultRuleParamter = this.getRuleParameterByPosition(this.defaultRuleParameters, position);
                Field defaultField = this.getFieldByDefaultParameter(defaultRuleParamter);
                DataType defaultDataType = defaultField.getDataType();
                if (verbose) {
                    logger.info("validate() - Default RuleParameter: " + String.valueOf(defaultRuleParamter) + " -> " + String.valueOf(defaultField));
                }
                if (compatible = DataType.isCompatible(targetDataType, defaultDataType)) continue;
                String targetLabel = String.valueOf((Object)targetDataType) + " " + targetField.toShortString();
                String defaultLabel = String.valueOf((Object)defaultDataType) + " " + defaultField.toShortString();
                String message = "Wrong target's datatype: " + targetLabel + ". Default datatype: " + defaultLabel;
                throw new InvalidRuleConfiguration(message);
            }
        }
        this.valid = true;
        return this.valid;
    }

    protected void reset() {
        this.valid = false;
        this.checked = false;
    }

    public void setRuleParameters(List<RuleParameter> ruleParameters) {
        this.reset();
        this.ruleParameters = ruleParameters;
        if (logger.isDebugEnabled()) {
            logger.debug("setRuleParameters(): " + String.valueOf(this.ruleParameters));
        }
    }

    public void setDefaultRuleParameters(List<RuleParameter> defaultRuleParameters) {
        this.reset();
        this.defaultRuleParameters = defaultRuleParameters;
    }

    public List<String> getRuleParametersNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (RuleParameter parameter : this.getRuleParameters()) {
            int fieldID = parameter.getFieldID();
            String targetField = this.getTargetSchemaView().getFieldByID(fieldID).getName();
            names.add(targetField);
        }
        return names;
    }

    public List<RuleParameter> getRuleParameters() {
        if (logger.isTraceEnabled()) {
            logger.trace("getRuleParameters() --> " + String.valueOf(this.ruleParameters) + " (" + (this.ruleParameters == RuleParameter.ALL_FIELDS) + ")");
        }
        if (this.ruleParameters == null) {
            List<RuleParameter> defaultParameters = this.getDefaultRuleParameters();
            if (defaultParameters != null) {
                String message;
                if (defaultParameters == RuleParameter.ALL_FIELDS) {
                    message = "ALL_FIELDS";
                    this.setRuleParameters(RuleParameter.ALL_FIELDS);
                } else {
                    message = defaultParameters.toString();
                    this.setRuleParameters(new ArrayList<RuleParameter>(defaultParameters));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Null rule's parameters -> set default values: " + message);
                }
            } else {
                String message = "Null rule's default parameters -> invalid rule!";
                logger.error(message);
                throw new InvalidRuleException(message);
            }
        }
        return this.ruleParameters;
    }

    public void setPositive(boolean positive) {
        this.reset();
        this.positive = positive;
    }

    public void setCaseSensitivity(CaseSensitivity caseSensitivity) {
        this.reset();
        this.caseSensitivity = caseSensitivity;
    }

    public void setValidationMessage(ValidationMessage validationMessage) {
        this.reset();
        this.validationMessage = validationMessage;
    }

    public ValidationMessage getValidationMessage() {
        return this.validationMessage;
    }

    public void setRuleType(RuleType ruleType) throws InvalidRuleException {
        this.reset();
        if (this.ruleType == null || this.ruleType == RuleType.UNDEF) {
            this.ruleType = ruleType;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("setRuleType() - changing " + String.valueOf((Object)this.ruleType) + " to " + String.valueOf((Object)ruleType));
        }
        if (this.ruleType != ruleType) {
            String message = "RuleType: " + String.valueOf((Object)ruleType) + " not coherent with the natural one (" + String.valueOf((Object)this.ruleType) + ")";
            logger.error(message);
            throw new InvalidRuleException(message);
        }
    }

    public void setPriority(int priority) {
        this.reset();
        this.priority = priority;
    }

    public void setBlocking(boolean blocking) {
        this.reset();
        this.blocking = blocking;
    }

    public void setRuleTarget(RuleTarget ruleTarget) {
        this.reset();
        this.ruleTarget = ruleTarget;
    }

    public void setDefaultSchemaView(SchemaView defaultSchemaView) {
        this.reset();
        this.defaultSchemaView = defaultSchemaView;
    }

    public void setTargetSchemaView(SchemaView targetSchemaView) {
        this.reset();
        this.targetSchemaView = targetSchemaView;
        if (logger.isDebugEnabled()) {
            logger.debug("setTargetSchemaView() - targetSchemaView = " + String.valueOf(targetSchemaView));
        }
    }

    public void setPreparatoryRuleIDs(List<Integer> preparatoryRuleIDs) {
        this.reset();
        this.preparatoryRuleIDs = preparatoryRuleIDs;
    }

    public void setFunctionRuleIDs(List<Integer> functionRuleIDs) {
        this.reset();
        this.functionRuleIDs = functionRuleIDs;
    }

    public void setConfigurationFiles(List<LocalFile> configurationFiles) {
        this.reset();
        this.configurationFiles = configurationFiles;
    }

    public void setConfigurationPath(String configurationPath) {
        this.reset();
        this.configurationPath = configurationPath;
    }

    public CaseSensitivity getCaseSensitivity() {
        if (this.caseSensitivity != null) {
            return this.caseSensitivity;
        }
        return CaseSensitivity.INSENSITIVE;
    }

    public RuleScope getRuleScope() {
        return this.ruleType.scope;
    }

    public boolean isOrdered() {
        return this.ruleType.ordered;
    }

    public ValidationLevel getValidationLevel() {
        return this.ruleType.validationLevel;
    }

    public int getLevel() {
        return this.getValidationLevel().level;
    }

    public SchemaView getTargetSchemaView() {
        if (this.targetSchemaView == null) {
            this.targetSchemaView = this.getDefaultSchemaView();
        }
        return this.targetSchemaView;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    protected void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public void setProtocolID(int protocolID) {
        this.protocolID = protocolID;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public RuleTarget getRuleTarget() {
        return this.ruleTarget;
    }

    public SchemaView getDefaultSchemaView() {
        return this.defaultSchemaView;
    }

    public List<Integer> getPreparatoryRuleIDs() {
        return this.preparatoryRuleIDs;
    }

    public List<Integer> getFunctionRuleIDs() {
        return this.functionRuleIDs;
    }

    public List<RuleParameter> getDefaultRuleParameters() {
        return this.defaultRuleParameters;
    }

    public List<LocalFile> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public boolean isDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(boolean defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public boolean addressFieldId(int fieldID) {
        if (this.getRuleTarget() == RuleTarget.ALL_FIELDS && this.getRuleScope().checkFields()) {
            return true;
        }
        List<Field> allFields = this.getAllFields();
        for (Field field : allFields) {
            if (field.getId() != fieldID) continue;
            return true;
        }
        return false;
    }

    public List<Field> getAllFields() {
        ArrayList<Field> allFields = new ArrayList<Field>();
        List<RuleParameter> ruleParameters = this.getRuleParameters();
        for (int position = 1; position <= ruleParameters.size(); ++position) {
            Field field = this.getFieldByPosition(position);
            allFields.add(field);
        }
        return allFields;
    }

    public Field getFieldByPosition(int position) {
        RuleParameter ruleParameter = this.getRuleParameterByPosition(this.getRuleParameters(), position);
        int fieldID = ruleParameter.getFieldID();
        Field field = this.getTargetSchemaView().getFieldByID(fieldID);
        return field;
    }

    public Field getFieldById(int fieldID) {
        return this.getTargetSchemaView().getFieldByID(fieldID);
    }

    public Field getFieldByDefaultParameter(RuleParameter ruleParameter) {
        if (this.defaultSchemaView == null) {
            String message = "Cannot fetch Field from a null default SchemaView";
            logger.error(message);
            return Field.UNDEF;
        }
        int fieldID = ruleParameter.getFieldID();
        Field field = this.defaultSchemaView.getFieldByID(fieldID);
        if (logger.isDebugEnabled()) {
            logger.debug("getFieldByDefaultParameter() -  defaultSchemaView = " + String.valueOf(this.defaultSchemaView) + " - fieldID = " + fieldID + " -> " + String.valueOf(field));
        }
        return field;
    }

    public Field getFieldByTargetParameter(RuleParameter ruleParameter) {
        if (this.getTargetSchemaView() == null) {
            String message = "Cannot fetch Field from a null target SchemaView";
            logger.error(message);
            return Field.UNDEF;
        }
        int fieldID = ruleParameter.getFieldID();
        Field field = this.getTargetSchemaView().getFieldByID(fieldID);
        if (logger.isDebugEnabled()) {
            logger.debug("getFieldByTargetParameter() -  targetSchemaView = " + String.valueOf(this.getTargetSchemaView()) + " - fieldID = " + fieldID + " -> " + String.valueOf(field));
        }
        return field;
    }

    public RuleParameter getRuleParameterByPosition(List<RuleParameter> parameters, int position) {
        for (RuleParameter parameter : parameters) {
            if (parameter.getPosition() != position) continue;
            return parameter;
        }
        return RuleParameter.UNDEF;
    }

    public boolean compareRuleParameters() {
        List<RuleParameter> currentRuleParameters = this.getRuleParameters();
        List<RuleParameter> defaultRuleParameters = this.getDefaultRuleParameters();
        return this.compare(currentRuleParameters, defaultRuleParameters);
    }

    protected boolean compare(Collection<?> first, Collection<?> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.getClass() != second.getClass()) {
            return false;
        }
        if (first.size() != second.size()) {
            logger.warn("Compare - collections have different sizes: " + first.size() + " vs " + second.size());
            return false;
        }
        ArrayList copy = new ArrayList(first);
        for (Object object : second) {
            if (copy.remove(object)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Compare - object not found in 1st collection: " + String.valueOf(object));
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("valid=");
        builder.append(this.valid);
        builder.append(", target=");
        builder.append((Object)this.getRuleTarget());
        builder.append(", defaultSchema=");
        builder.append(this.defaultSchemaView.getName());
        builder.append("]");
        return builder.toString();
    }
}

