/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.file.handler.PropertiesHandler;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceData;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceDatum;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleToField;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Key;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericCrossRecordRule;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.WhereCondition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericRule
extends AbstractRule {
    protected RuleDefinition ruleDefinition;
    protected ProtocolToRule protocolToRule;
    protected List<RuleToField> ruleToField;
    protected PropertiesHandler<Properties> propertiesHandler;
    protected FileHandlerCSV<DataRecordCSV> fileHandlerCSV;
    protected static FieldDAO fieldDAO;
    protected static SchemaViewDAO schemaViewDAO;
    protected static RuleDefinitionDAO ruleDefinitionDAO;
    public static final String ID_SEPARATOR = "_";
    protected static final SimpleDateFormat dateFormatter;
    protected static Logger logger;

    public GenericRule() {
        this.setValid(false);
        this.setName("undefined_genericRule");
        this.setDescription("Empty reference for a \"null\" GenericRule instance");
        this.setLongDescription("Empty long description for a \"null\" GenericRule instance");
    }

    public GenericRule(RuleDefinition rule) {
        this();
        this.setRuleDefinition(rule);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            String message = "GenericRule with invalid configuration (generic validation failed)";
            logger.error(message);
            return false;
        }
        return true;
    }

    protected Properties getPropertiesFile(String filePath, String fileName) {
        FileConnection fileConnection = new FileConnection(fileName, filePath);
        this.propertiesHandler = new PropertiesHandler(fileConnection);
        return this.propertiesHandler.getProperties(true);
    }

    protected List<DataRecordCSV> readCSVFile(String filePath, String fileName) {
        FileConnection fileConnection = new FileConnection(fileName, filePath);
        this.fileHandlerCSV = new FileHandlerCSV<DataRecordCSV>(fileConnection, DataRecordCSV.class);
        this.fileHandlerCSV.setHeader(true);
        return this.fileHandlerCSV.readFile();
    }

    public void setRuleDefinition(RuleDefinition ruleDefinition) throws InvalidRuleException {
        this.ruleDefinition = ruleDefinition;
        if (logger.isDebugEnabled()) {
            logger.debug("setRuleDefinition(): " + String.valueOf(this.ruleDefinition) + " (" + (ruleDefinition == RuleDefinition.UNDEF) + ")");
        }
        this.id = ruleDefinition.getId();
        this.name = ruleDefinition.getName();
        this.description = ruleDefinition.getDescription();
        if (ruleDefinition != RuleDefinition.UNDEF) {
            RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
            ruleConfiguration.setPositive(ruleDefinition.isPositive());
            ruleConfiguration.setCaseSensitivity(ruleDefinition.getCaseSensitivity());
            ruleConfiguration.setValidationMessage(ruleDefinition.getValidationMessage());
            ruleConfiguration.setRuleType(ruleDefinition.getRuleType());
        } else {
            logger.warn("GenericRule '" + this.getClass().getSimpleName() + "' not bound to a valid RuleDefinition");
        }
    }

    public void setProtocolToRule(ProtocolToRule protocolToRule) {
        this.protocolToRule = protocolToRule;
        if (logger.isDebugEnabled()) {
            logger.debug("setProtocolToRule(): " + String.valueOf(protocolToRule) + " (" + (protocolToRule == ProtocolToRule.UNDEF) + ")");
        }
        if (protocolToRule != ProtocolToRule.UNDEF) {
            int protocolID = protocolToRule.getProtocolID();
            Protocol protocol = this.protocolToRule.getProtocol();
            int schema_ID = protocol.getSchemaID();
            SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(schema_ID);
            if (logger.isDebugEnabled()) {
                logger.debug("setProtocolToRule() - schemaView = " + String.valueOf(schemaView));
            }
            RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
            ruleConfiguration.setProtocolID(protocolID);
            ruleConfiguration.setTargetSchemaView(schemaView);
            ruleConfiguration.setPriority(protocolToRule.getPriority());
            ruleConfiguration.setBlocking(protocolToRule.isBlocking());
            List<RuleToField> ruleToFields = this.ruleDefinition.getRuleToField(protocolID);
            if (logger.isDebugEnabled()) {
                logger.debug("setProtocolToRule() - " + this.getModelName() + " - setting RuleToField: " + String.valueOf(ruleToFields));
            }
            this.setRuleToField(ruleToFields);
        } else {
            logger.warn("GenericRule '" + this.getClass().getSimpleName() + "' not bound to a valid ProtocolToRule");
        }
    }

    public void setRuleToField(List<RuleToField> ruleToFields) {
        this.ruleToField = ruleToFields;
        String className = this.getClass().getSimpleName();
        if (logger.isDebugEnabled()) {
            logger.debug("setRuleToField() - " + className + " - RuleToField = " + String.valueOf(this.ruleToField) + " (" + (ruleToFields == RuleToField.EMPTY_LIST) + ")");
        }
        if (ruleToFields != RuleToField.EMPTY_LIST) {
            RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
            List<RuleParameter> ruleParameters = new ArrayList<RuleParameter>();
            ruleConfiguration.setRuleParameters(ruleParameters);
            if (logger.isDebugEnabled()) {
                logger.debug("setRuleToField() - " + className + " - Setting RuleParameters: " + String.valueOf(ruleParameters) + " (" + (ruleParameters == RuleParameter.ALL_FIELDS) + ")");
            }
            for (RuleToField ruleToField : ruleToFields) {
                RuleTarget currentTarget = ruleToField.getRuleTarget();
                if (logger.isDebugEnabled()) {
                    logger.debug("setRuleToField() - " + className + " - Checking RuleToField: " + String.valueOf(ruleToField));
                }
                if (ruleConfiguration.getRuleTarget() == null) {
                    ruleConfiguration.setRuleTarget(currentTarget);
                } else if (ruleConfiguration.getRuleTarget() != currentTarget) {
                    ruleConfiguration.setRuleTarget(RuleTarget.WRONG);
                    String message = "Not homogeneous rule's target in the persistence layer: " + String.valueOf((Object)currentTarget) + " VS " + String.valueOf((Object)ruleConfiguration.getRuleTarget());
                    logger.warn(message + ". RuleID: " + this.ruleDefinition.getId());
                }
                if (currentTarget.isActualTarget()) {
                    int position = ruleToField.getPosition();
                    int fieldID = ruleToField.getFieldID();
                    boolean key = ruleToField.getKey();
                    RuleParameter ruleParameter = new RuleParameter(position, fieldID, key);
                    ruleParameters.add(ruleParameter);
                    if (logger.isDebugEnabled()) {
                        logger.debug("setRuleToField() - " + className + " - Added RuleParameter: " + String.valueOf(ruleParameter));
                    }
                    if (key) {
                        this.manageKeyField(ruleParameter);
                    }
                    ruleConfiguration.setDefaultTarget(false);
                    continue;
                }
                ruleConfiguration.setDefaultTarget(false);
            }
            if (ruleParameters.size() == 0) {
                ruleParameters = RuleParameter.ALL_FIELDS;
                ruleConfiguration.setRuleParameters(ruleParameters);
                if (logger.isDebugEnabled()) {
                    logger.debug("\t setRuleToField() - " + className + " - Forced target to ALL_FIELDS");
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("setRuleToField() - " + className + " - Set RuleParameters: " + String.valueOf(ruleParameters) + " (" + (ruleParameters == RuleParameter.ALL_FIELDS) + ")");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("setRuleToField() - " + className + " - RuleToField definition missing -> using default");
            }
            if (ruleToFields == RuleToField.UNDEF) {
                String message = "List of RuleToField DTOs should never set to RuleToField.UNDEF";
                logger.warn(message);
            }
        }
    }

    protected String getFieldValue(Field field) {
        if (field == null) {
            return null;
        }
        return this.getFieldValue(field.getId());
    }

    protected String getFieldValue(int fieldID) {
        DataRecord record = this.getDataRecord();
        return this.getFieldValue(record, fieldID);
    }

    protected String getFieldValue(DataRecord record, Field field) {
        if (field == null) {
            return null;
        }
        return this.getFieldValue(record, field.getId());
    }

    protected String getFieldValue(DataRecord record, int fieldID) {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        int fieldPosition = schemaView.getFieldPosition(fieldID);
        String fieldValue = record.getValue(fieldPosition - 1);
        return fieldValue;
    }

    protected void setFieldValue(DataRecord record, Field field, String value) {
        if (field != null) {
            this.setFieldValue(record, field.getId(), value);
        }
    }

    protected void setFieldValue(DataRecord record, int fieldID, String value) {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        int fieldPosition = schemaView.getFieldPosition(fieldID);
        record.setValue(fieldPosition - 1, value);
        if (logger.isDebugEnabled()) {
            logger.debug("setFieldValue() - Set fieldID " + fieldID + " to: " + value);
        }
    }

    protected String getFieldValues(int[] fieldIDs) {
        DataRecord record = this.getDataRecord();
        return this.getFieldValues(record, fieldIDs);
    }

    protected String getFieldValues(DataRecord record, int[] fieldIDs) {
        String separator = "";
        StringBuilder result = new StringBuilder();
        for (int fieldID : fieldIDs) {
            result.append(separator);
            result.append(this.getFieldValue(record, fieldID));
            separator = ID_SEPARATOR;
        }
        return result.toString();
    }

    public String getPrimaryKeyBySchemaPerspective(DataRecord record) {
        String mainKey = this.getMainKeyBySchemaPerspective(record);
        List<String> otherKeys = this.getKeyValuesBySchemaPerspective(record, Key.COMPOSITE);
        StringBuilder builder = new StringBuilder(mainKey);
        builder.append(ID_SEPARATOR);
        String sep = "";
        for (String otherKey : otherKeys) {
            builder.append(sep);
            builder.append(otherKey);
            sep = ID_SEPARATOR;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getRecordIDBySchemaPerspective() - recordID = " + String.valueOf(builder));
        }
        return builder.toString();
    }

    public String getMainKeyBySchemaPerspective(DataRecord record) {
        List<String> allValues = this.getKeyValuesBySchemaPerspective(record, Key.MAIN);
        if (allValues != null && allValues.size() == 1) {
            return allValues.get(0);
        }
        return null;
    }

    public String getFirstCompositeKeyBySchemaPerspective(DataRecord record) {
        List<String> allValues = this.getKeyValuesBySchemaPerspective(record, Key.COMPOSITE);
        if (allValues != null && allValues.size() > 0) {
            return allValues.get(0);
        }
        return null;
    }

    public List<String> getKeyValuesBySchemaPerspective(DataRecord record, Key targetKey) {
        ArrayList<String> keyValues = new ArrayList<String>();
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        List<Field> keyFields = schemaView.getKeyFields(targetKey);
        for (Field field : keyFields) {
            String keyValue = this.getFieldValue(record, field);
            keyValues.add(keyValue);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getMainIDBySchemaPerspective() - keyValues = " + String.valueOf(keyValues));
        }
        return keyValues;
    }

    public String getRecordIDByRulePerspective(DataRecord record) {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        List<RuleParameter> parameters = this.ruleConfiguration.getRuleParameters();
        for (RuleParameter ruleParameter : parameters) {
            if (!ruleParameter.isKey()) continue;
            int fieldID = ruleParameter.getFieldID();
            String value = this.getFieldValue(record, fieldID);
            builder.append(sep);
            builder.append(value);
            sep = ID_SEPARATOR;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getRecordIDByRulePerspective() - recordID = " + String.valueOf(builder));
        }
        return builder.toString();
    }

    protected boolean isEmpty(String string) {
        return string == null || string.length() <= 0 || string.trim().length() <= 0;
    }

    protected boolean containOneEmptyElement(String[] array) {
        for (String value : array) {
            if (!this.isEmpty(value)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCaseSensitive(Field field) {
        if (this.getRuleConfiguration().getCaseSensitivity() == CaseSensitivity.SENSITIVE) {
            return true;
        }
        if (this.getRuleConfiguration().getCaseSensitivity() == CaseSensitivity.FIELD_LEVEL) {
            if (field != null) {
                return field.isCaseSensitive();
            }
            logger.error("Cannot detect case sensitivity for a null Field: forcing rule to be case INSENSITIVE");
            return false;
        }
        return false;
    }

    protected Date getDateFromFields(String month, String year) {
        String day = "01";
        return this.getDateFromFields(day, month, year);
    }

    protected Date getDateFromFields(String day, String month, String year) {
        String dateAsString = day + "/" + month + "/" + year;
        Date date = null;
        try {
            date = dateFormatter.parse(dateAsString);
            if (logger.isTraceEnabled()) {
                logger.trace("getDateFromFields() - Parsed date: " + String.valueOf(date));
            }
        }
        catch (ParseException e) {
            logger.error("getDateFromFields() - Wrong input date: " + dateAsString);
        }
        return date;
    }

    protected long getDifferenceInDays(Date start, Date end) {
        long differenceinMs = end.getTime() - start.getTime();
        long difference = TimeUnit.DAYS.convert(differenceinMs, TimeUnit.MILLISECONDS);
        return difference;
    }

    public boolean isIntegerValue(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public int parseIntegerValue(char value) {
        return this.parseIntegerValue(String.valueOf(value));
    }

    @Override
    public int parseIntegerValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("parseInteger() - Error parsing string: " + value);
            }
            return -2147483001;
        }
    }

    @Override
    public void addReferenceData(RuleOutput ruleOutput, DataRecord record) {
        int lineNumber = ruleOutput.getLineNumber();
        boolean debug = false;
        ArrayList<ReferenceDatum> allDatum = new ArrayList<ReferenceDatum>();
        List<ReferenceField> referenceFields = this.validationEngine.getReferenceFields();
        if (referenceFields == null) {
            String message = "addReferenceData() - Save Reference Data in enabled, but list of ReferenceField is null";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (debug) {
            String recordData = "row " + lineNumber + " : " + ruleOutput.toShortString();
            logger.info("");
            logger.info("addReferenceData() - Handling " + (String)recordData);
        }
        for (ReferenceField referenceField : referenceFields) {
            Field field = referenceField.getField();
            int keyPosition = referenceField.getKeyPosition();
            Object fieldValue = this.getFieldValue(record, field);
            if (debug) {
                String keyField = Integer.toString(keyPosition);
                String fieldData = field.getName() + " = " + (String)fieldValue + " (key= " + keyField + ")";
                logger.info("addReferenceData() - DataRecord : " + record.toShortString());
                logger.info("addReferenceData() - Field      : " + fieldData);
            }
            if (this.isEmpty((String)fieldValue) && keyPosition > 0 & lineNumber > 0) {
                fieldValue = "(row " + Integer.toString(lineNumber) + ")";
                if (logger.isInfoEnabled()) {
                    String feedback = field.getName() + " -> forcing: " + (String)fieldValue;
                    logger.info("addReferenceData() - Missing key_field: " + feedback);
                }
            }
            ReferenceDatum referenceDatum = new ReferenceDatum(referenceField, (String)fieldValue);
            allDatum.add(referenceDatum);
        }
        ReferenceData referenceData = new ReferenceData(allDatum);
        ruleOutput.setReferenceData(referenceData);
        if (debug) {
            logger.info("addReferenceData() - Set ReferenceData:\n" + String.valueOf(referenceData));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addReferenceData() - RuleOutput: " + String.valueOf(ruleOutput));
        }
    }

    protected FileHandlerCSV<DataRecordCSV> openCSVFile(String filePath, String fileName, boolean append) {
        FileConnection fileConnection = new FileConnection(fileName, filePath);
        fileConnection.setWriteAccess(true);
        fileConnection.setAppend(false);
        this.fileHandlerCSV = new FileHandlerCSV<DataRecordCSV>(fileConnection, DataRecordCSV.class);
        this.fileHandlerCSV.setHeader(true);
        this.fileHandlerCSV.setAutoCommit(false);
        this.fileHandlerCSV.openWriter();
        return this.fileHandlerCSV;
    }

    protected Field getFieldByID(int fieldID) {
        return (Field)fieldDAO.getByID(fieldID);
    }

    protected void setDefaultSchemaView(int schemaID) {
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(schemaID);
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        ruleConfiguration.setDefaultSchemaView(schemaView);
    }

    protected void manageKeyField(RuleParameter ruleParameter) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        if (logger.isDebugEnabled()) {
            logger.debug("manageKeyField() - " + this.className + " input RuleParameter: " + String.valueOf(ruleParameter));
        }
        if (RuleType.DUPLICATES == ruleConfiguration.getRuleType()) {
            GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)this;
            int[] fieldIDs = new int[]{ruleParameter.getFieldID()};
            WhereCondition whereCondition = new WhereCondition(fieldIDs);
            crossRecordRule.setWhereCondition(whereCondition);
            if (logger.isInfoEnabled()) {
                logger.info("manageKeyField() - " + this.className + " set where condition: " + String.valueOf(crossRecordRule.getWhereCondition()));
            }
        }
    }

    public RuleDefinition getRuleDefinition() {
        return this.ruleDefinition;
    }

    public ProtocolToRule getProtocolToRule() {
        return this.protocolToRule;
    }

    public List<RuleToField> getRuleToField() {
        return this.ruleToField;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    public PropertiesHandler<Properties> getPropertiesHandler() {
        return this.propertiesHandler;
    }

    public void setPropertiesHandler(PropertiesHandler<Properties> propertiesHandler) {
        this.propertiesHandler = propertiesHandler;
    }

    public FileHandlerCSV<DataRecordCSV> getFileHandlerCSV() {
        return this.fileHandlerCSV;
    }

    public void setFileHandlerCSV(FileHandlerCSV<DataRecordCSV> fileHandlerCSV) {
        this.fileHandlerCSV = fileHandlerCSV;
    }

    @Override
    protected String getPrettyRuleOutput(RuleOutput ruleOutput) {
        StringBuilder builder = new StringBuilder();
        builder.append(ruleOutput.getErrorCode());
        builder.append(" [RULE_ID:");
        builder.append(ruleOutput.getRuleID());
        builder.append("]");
        builder.append(" - ");
        builder.append(ruleOutput.getDescription());
        RuleDefinition ruleDefinition = (RuleDefinition)ruleDefinitionDAO.getByID(ruleOutput.getRuleID());
        builder.append(" -> ");
        builder.append(ruleDefinition.getImplementation());
        builder.append(" (");
        builder.append(ruleDefinition.getLocation());
        builder.append(")");
        return builder.toString();
    }

    @Override
    protected String getPrettyRuleOutputDetail(RuleOutputDetail ruleOutputDetail) {
        StringBuilder builder = new StringBuilder();
        builder.append(ruleOutputDetail.getFieldName());
        builder.append(" -> ");
        builder.append(ruleOutputDetail.getFieldValue());
        builder.append("   [FIELD_ID:");
        builder.append(ruleOutputDetail.getFieldID());
        builder.append("]");
        return builder.toString();
    }

    static {
        dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
        logger = LoggerFactory.getLogger(GenericRule.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        fieldDAO = (FieldDAO)((Object)daoFactory.getDAO(DAO.FIELD));
        schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        ruleDefinitionDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
    }
}

