/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.input.DataConnection;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.RuleInput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleScope;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.RuleRuntimeException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRule
extends GenericModel {
    protected RuleInput ruleInput;
    protected List<RuleOutput> ruleOutput;
    protected RuleConfiguration ruleConfiguration;
    protected List<RuleOutput> previousOutputs;
    protected ValidationEngine validationEngine;
    protected String longDescription;
    protected static Logger logger = LoggerFactory.getLogger(AbstractRule.class);

    public boolean validate() {
        SchemaView schemaView;
        this.valid = false;
        try {
            this.valid = this.getRuleConfiguration().validate();
        }
        catch (InvalidRuleConfiguration e) {
            String message = "\"" + this.getModelName() + "\" wrong configuration: " + e.getMessage();
            throw new InvalidRuleException(message);
        }
        RuleScope ruleScope = this.getRuleConfiguration().getRuleScope();
        if (ruleScope != RuleScope.FILE_METADATA && ruleScope != RuleScope.FILE_FORMAT && (schemaView = this.getRuleConfiguration().getDefaultSchemaView()) == null) {
            String message = "Rule targets header or record --> needs a not null SchemaView instance";
            throw new InvalidRuleException(message);
        }
        return this.valid;
    }

    protected void tryToValidate() {
        this.validate();
        if (!this.valid) {
            String className = this.getClass().getSimpleName();
            String message = "Invalid rule configuration: " + className + " " + String.valueOf(this.getRuleConfiguration());
            logger.warn(message);
            throw new InvalidRuleException(message);
        }
    }

    protected void initializeOutput() {
        if (this.ruleOutput == null) {
            this.ruleOutput = new ArrayList<RuleOutput>();
        }
    }

    protected abstract void setDefaultConfiguration();

    public List<RuleOutput> check(RuleInput input) {
        this.setRuleInput(input);
        return this.check();
    }

    public List<RuleOutput> check() {
        if (!this.valid) {
            this.tryToValidate();
        }
        if (this.getRuleInput() == null) {
            String message = "Can not apply a rule to a null input";
            logger.warn(message);
            throw new IllegalStateException(message);
        }
        this.ruleOutput = null;
        try {
            this.ruleOutput = this.applyCheck();
        }
        catch (Exception e) {
            logger.error(this.getClassName() + " - applyCheck() - Rule exception: " + e.getMessage());
            throw new RuleRuntimeException(e);
        }
        if (this.validationEngine == null) {
            logger.warn("check() - Ignoring reference data (null validation engine)");
            return this.ruleOutput;
        }
        if (this.validationEngine.isSaveReferenceData() && this.getRuleInput() instanceof DataRecord) {
            boolean hasOutput;
            boolean bl = hasOutput = this.ruleOutput != null && this.ruleOutput != RuleOutput.EMPTY_LIST;
            if (hasOutput) {
                DataRecord record = (DataRecord)this.getRuleInput();
                for (RuleOutput ruleOutput : this.ruleOutput) {
                    this.addReferenceData(ruleOutput, record);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("check() - Applied DataRecord rule: " + this.toShortString());
            }
        }
        return this.ruleOutput;
    }

    protected abstract List<RuleOutput> applyCheck();

    public abstract void addReferenceData(RuleOutput var1, DataRecord var2);

    protected RuleOutput getNewRuleOutput() {
        ValidationMessage message = this.getRuleConfiguration().getValidationMessage();
        return new RuleOutput(message);
    }

    protected void addSingleError() {
        this.initializeOutput();
        RuleOutput singleOutput = this.getNewRuleOutput();
        int ruleID = this.getId();
        singleOutput.setRuleID(ruleID);
        this.ruleOutput.add(singleOutput);
    }

    protected RuleOutput addErrorDetail(String name, String value) {
        SchemaView schemaView = this.getRuleConfiguration().getDefaultSchemaView();
        Field field = schemaView.getFieldByName(name);
        return this.addErrorDetail(field, value);
    }

    protected RuleOutput addErrorDetail(String label) {
        return this.addErrorDetail(Field.UNDEF, label);
    }

    protected RuleOutput addErrorDetail(FieldValue fieldValue) {
        Field field = fieldValue.getField();
        String value = fieldValue.getValue();
        return this.addErrorDetail(field, value);
    }

    protected RuleOutput addErrorDetail(Field field, String value) {
        this.initializeOutput();
        RuleOutputDetail outputDetail = field != Field.UNDEF ? new RuleOutputDetail(field, value) : new RuleOutputDetail(value);
        ArrayList<RuleOutputDetail> outputDetailsList = new ArrayList<RuleOutputDetail>();
        outputDetailsList.add(outputDetail);
        RuleOutput singleOutput = this.getNewRuleOutput();
        singleOutput.setRuleOutputDetails(outputDetailsList);
        int ruleID = this.getId();
        singleOutput.setRuleID(ruleID);
        this.ruleOutput.add(singleOutput);
        if (logger.isDebugEnabled()) {
            logger.debug("addErrorDetail() - RuleOutput = " + String.valueOf(singleOutput) + " / RuleOutputDetail = " + String.valueOf(singleOutput.getAllRuleOutputDetail()));
        }
        return singleOutput;
    }

    protected RuleOutput addErrorDetail(List<FieldValue> fieldValues) {
        if (fieldValues == null || fieldValues.size() < 1) {
            String message = "addErrorDetail() invoked with empty fieldValues: no error details";
            logger.warn(message);
            return RuleOutput.UNDEF;
        }
        FieldValue firstFieldValue = fieldValues.get(0);
        RuleOutput ruleOutput = this.addErrorDetail(firstFieldValue);
        List<RuleOutputDetail> outputDetailsList = ruleOutput.getAllRuleOutputDetail();
        for (int i = 1; i < fieldValues.size(); ++i) {
            FieldValue fieldValue = fieldValues.get(i);
            Field field = fieldValue.getField();
            String value = fieldValue.getValue();
            outputDetailsList.add(new RuleOutputDetail(field, value));
        }
        return ruleOutput;
    }

    protected boolean isValidAndDefinedField(Field field, String value) {
        if (value == null) {
            return false;
        }
        if (value.length() <= 0) {
            return false;
        }
        if (value.trim().length() <= 0) {
            return false;
        }
        return this.isValidAndNotUnknownField(field, value);
    }

    protected boolean isValidAndNotUnknownField(Field field, String value) {
        if (field == null) {
            return false;
        }
        if (field.isUnknownValue(value)) {
            return false;
        }
        return this.isValidField(field);
    }

    protected boolean isValidField(Field field) {
        if (field == null) {
            return false;
        }
        int fieldID = field.getId();
        return this.isValidField(fieldID);
    }

    protected boolean isValidField(int fieldID) {
        List<Integer> failedPreparatoryRuleIDs = this.getFailedPreparatoryRulesByField(fieldID);
        if (logger.isDebugEnabled()) {
            logger.debug("checkIfFieldIsValid() - fieldID = " + fieldID + " -> " + String.valueOf(failedPreparatoryRuleIDs));
        }
        if (failedPreparatoryRuleIDs == null) {
            return true;
        }
        return failedPreparatoryRuleIDs.size() == 0;
    }

    protected boolean allFieldsAreValid() {
        RuleTarget target = this.getRuleConfiguration().getRuleTarget();
        if (target == RuleTarget.ALL_FIELDS) {
            List<Integer> preparatoryRuleIDs = this.getRuleConfiguration().getPreparatoryRuleIDs();
            for (Integer preparatoryRuleID : preparatoryRuleIDs) {
                for (RuleOutput previousOutput : this.previousOutputs) {
                    int previousOutputID = previousOutput.getRuleID();
                    if (preparatoryRuleID != previousOutputID) continue;
                    return false;
                }
            }
        }
        List<RuleParameter> ruleParameters = this.getRuleConfiguration().getRuleParameters();
        for (RuleParameter ruleParameter : ruleParameters) {
            int parameterFieldID = ruleParameter.getFieldID();
            boolean isValidField = this.isValidField(parameterFieldID);
            if (isValidField) continue;
            return false;
        }
        return true;
    }

    protected boolean isFieldSetToUnknownValue(Field field, String value) {
        if (field == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("isFieldSetToUnknownValue() - Null Field object: returning false");
            }
            return false;
        }
        return field.isUnknownValue(value);
    }

    protected List<Integer> getFailedPreparatoryRulesByField(int fieldID) {
        List<Integer> failedRuleIDs = this.getFailedRulesByField(fieldID);
        if (failedRuleIDs == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        List<Integer> preparatoryRuleIDs = this.getRuleConfiguration().getPreparatoryRuleIDs();
        if (preparatoryRuleIDs == null) {
            return null;
        }
        for (int preparatoryRuleID : preparatoryRuleIDs) {
            if (!failedRuleIDs.contains(preparatoryRuleID)) continue;
            list.add(preparatoryRuleID);
        }
        return list;
    }

    protected List<Integer> getFailedRulesByField(int fieldID) {
        if (this.previousOutputs == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (RuleOutput previousOutput : this.previousOutputs) {
            List<RuleOutputDetail> outputDetails;
            MessageType messageType;
            if (logger.isDebugEnabled()) {
                logger.debug("getFailedRulesByField() - RuleOutput = " + String.valueOf(previousOutput));
            }
            if ((messageType = previousOutput.getMessageType()) == MessageType.WARNING || (outputDetails = previousOutput.getAllRuleOutputDetail()) == null) continue;
            for (RuleOutputDetail outputDetail : outputDetails) {
                int outputFieldID = outputDetail.getFieldID();
                if (logger.isDebugEnabled()) {
                    logger.debug("getFailedRulesByField() - RuleOutputDetail = " + String.valueOf(outputDetail));
                }
                if (outputFieldID != fieldID) continue;
                int failedRuleID = previousOutput.getRuleID();
                list.add(failedRuleID);
            }
        }
        return list;
    }

    protected boolean previousOutputContainsRule(int ruleID) {
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("");
            logger.info("previousOutputContainsRule() - Checking rule ID      : " + ruleID);
            logger.info("previousOutputContainsRule() - Previous Rule Outputs : " + RuleOutput.printShortList(this.previousOutputs));
        }
        if (this.previousOutputs == null) {
            return false;
        }
        for (RuleOutput previousOutput : this.previousOutputs) {
            if (debug) {
                logger.info("previousOutputContainsRule() - Previous output       : " + String.valueOf(previousOutput));
            }
            if (previousOutput.getRuleID() != ruleID) continue;
            return true;
        }
        return false;
    }

    public void setRuleInput(RuleInput input) {
        if (input == null) {
            String message = "RuleInput can not be null: must be a concrete object";
            logger.warn(message);
            throw new IllegalStateException(message);
        }
        RuleScope ruleScope = this.getRuleConfiguration().getRuleScope();
        switch (ruleScope) {
            case FILE_METADATA: 
            case FILE_FORMAT: 
            case ALL_RECORDS: {
                if (input instanceof DataConnection) break;
                String message = "Rule input '" + String.valueOf(input.getClass()) + "' is not compatible with rule's scope: " + String.valueOf((Object)ruleScope);
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
            case HEADER: 
            case RECORD: {
                if (input instanceof DataRecord) break;
                String message = "Rule input '" + String.valueOf(input.getClass()) + "' is not compatible with rule's scope: " + String.valueOf((Object)ruleScope);
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
            default: {
                String message = "Unknown rule's scope : " + String.valueOf((Object)ruleScope) + ". Impossible to validate input's type";
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
        }
        this.ruleInput = input;
    }

    private void setRuleOutput(List<RuleOutput> ruleOutput) {
        this.ruleOutput = ruleOutput;
    }

    public void setRuleConfiguration(RuleConfiguration ruleConfiguration) {
        this.valid = false;
        if (ruleConfiguration != null) {
            this.ruleConfiguration = ruleConfiguration;
        } else if (logger.isWarnEnabled()) {
            logger.warn("Ignored new rule's configuration, because null");
        }
    }

    protected void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public void reset() {
        this.previousOutputs = null;
    }

    public FileConnection getFileConnection() {
        FileConnection connection = null;
        if (!(this.ruleInput instanceof FileConnection)) {
            String message = this.getName() + " rule requires a RuleInput of type 'FileConnection'";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        connection = (FileConnection)this.ruleInput;
        return connection;
    }

    public DataRecord getDataRecord() {
        if (this.ruleInput == null) {
            logger.error("getDataRecord() - Found null rule input");
            return null;
        }
        if (!(this.ruleInput instanceof DataRecord)) {
            String message = "Rule's input is not an instance of DataRecord: " + String.valueOf(this.ruleInput.getClass());
            logger.error(message);
            throw new IllegalStateException(message);
        }
        return (DataRecord)this.ruleInput;
    }

    public List<RuleOutput> getRuleOutput() {
        if (this.ruleOutput == null) {
            return RuleOutput.VALID;
        }
        return this.ruleOutput;
    }

    public RuleConfiguration getRuleConfiguration() {
        if (this.ruleConfiguration == null) {
            this.setDefaultConfiguration();
        }
        return this.ruleConfiguration;
    }

    public RuleInput getRuleInput() {
        return this.ruleInput;
    }

    public List<RuleOutput> getPreviousOutputs() {
        return this.previousOutputs;
    }

    public void setPreviousOutputs(List<RuleOutput> previousOutputs) {
        this.previousOutputs = previousOutputs;
    }

    public ValidationEngine getValidationEngine() {
        return this.validationEngine;
    }

    public void setValidationEngine(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getFormattedHeader() {
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, Locale.ENGLISH);
        if (this.format == GenericModel.FORMAT.UNDEF) {
            this.setDefaultFormatter();
        }
        formatter.format(this.getFormatString(), "CLASS", "RID", "CODE", "SID", "TYPE (LEVEL)", "SCOPE", "POS/NEG", "CASE", "TARGET", "BLOCKING");
        formatter.format("%s", "PARAM_TO_FIELDID");
        formatter.close();
        return builder.toString();
    }

    public String toFixedString(boolean className) {
        String errorCode;
        Object ruleName;
        RuleConfiguration cfg = this.getRuleConfiguration();
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, Locale.ENGLISH);
        int schemaID = 0;
        SchemaView schema = cfg.getTargetSchemaView();
        if (schema != null) {
            schemaID = schema.getId();
        }
        RuleType type = cfg.getRuleType();
        String typeAndLevel = String.valueOf((Object)type) + " (" + type.validationLevel.level + ")";
        Object object = ruleName = className ? this.getClass().getSimpleName() : this.getModelName();
        if (type == RuleType.FUNCTION) {
            ruleName = (String)ruleName + " (*)";
        }
        if ((errorCode = cfg.getValidationMessage().getCode()) == null) {
            errorCode = "";
        }
        formatter.format(this.getFormatString(), new Object[]{ruleName, this.getId(), errorCode, schemaID, typeAndLevel, cfg.getRuleScope().toString().toLowerCase(), cfg.isPositive() ? "pos" : "neg", cfg.getCaseSensitivity().symbol, cfg.getRuleTarget(), cfg.isBlocking() ? "blocking" : ""});
        List<RuleParameter> ruleParameters = cfg.getRuleParameters();
        if (cfg.getRuleTarget().isActualTarget() && ruleParameters != null) {
            String params = RuleParameter.getFormattedRuleParameters(ruleParameters);
            formatter.format("%s", params);
        }
        formatter.close();
        return builder.toString();
    }

    public String toPlainString() {
        RuleConfiguration cfg = this.getRuleConfiguration();
        StringBuilder builder = new StringBuilder("");
        builder.append(this.getClass().getSimpleName());
        builder.append(" [id=");
        builder.append(this.getId());
        builder.append("] - ");
        if (cfg != null) {
            RuleType type = cfg.getRuleType();
            String typeAndLevel = String.valueOf((Object)type) + " (" + type.validationLevel.level + ")";
            builder.append(typeAndLevel);
            builder.append(" (");
            builder.append(cfg.getRuleScope().toString().toLowerCase());
            builder.append(") [");
            builder.append(cfg.isPositive() ? "pos" : "neg");
            builder.append("-");
            builder.append(cfg.getCaseSensitivity().symbol);
            builder.append("] - ");
            builder.append((Object)cfg.getRuleTarget());
            builder.append(cfg.isBlocking() ? " (blocking)" : "");
            List<RuleParameter> ruleParameters = cfg.getRuleParameters();
            if (cfg.getRuleTarget().isActualTarget() && ruleParameters != null) {
                String sep = "";
                builder.append(": ");
                for (RuleParameter parameter : ruleParameters) {
                    builder.append(sep);
                    if (parameter != RuleParameter.UNDEF) {
                        builder.append(parameter);
                        sep = ", ";
                        continue;
                    }
                    builder.append("Undef");
                }
            }
        }
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append(this.getModelName());
        builder.append("\" [ID= ");
        builder.append(this.getId());
        builder.append("]");
        return builder.toString();
    }

    protected void setDefaultFormatter() {
        this.setFormat(GenericModel.FORMAT.FIXED);
        this.setFormatString("%-40s %-3s %-6s %-3s %-18s %-12s %-7s %-25s %-12s %-9s");
    }

    public String toString() {
        String result = null;
        if (this.format == GenericModel.FORMAT.UNDEF) {
            this.setDefaultFormatter();
        }
        if ((result = this.format == GenericModel.FORMAT.FIXED ? this.toFixedString(true) : this.toPlainString()) == null) {
            result = this.toPlainString();
        }
        return result;
    }

    public void logPreviousOutput(boolean pretty) {
        List<RuleOutput> allPreviousOutputs = this.getPreviousOutputs();
        List<Integer> preparatoryRules = this.ruleConfiguration.getPreparatoryRuleIDs();
        if (preparatoryRules != null && preparatoryRules.size() > 0 && allPreviousOutputs != null) {
            for (RuleOutput previousOutput : allPreviousOutputs) {
                List<RuleOutputDetail> outputDetailsList;
                logger.info("");
                if (pretty) {
                    logger.info("PreviousOutput : " + this.getPrettyRuleOutput(previousOutput));
                } else {
                    logger.info("PreviousOutput : " + String.valueOf(previousOutput));
                }
                if ((outputDetailsList = previousOutput.getAllRuleOutputDetail()) == null || outputDetailsList.size() <= 0) continue;
                for (RuleOutputDetail outputDetail : outputDetailsList) {
                    if (pretty) {
                        logger.info("\t\tDetail : " + this.getPrettyRuleOutputDetail(outputDetail));
                        continue;
                    }
                    logger.info("\t\tDetail : " + outputDetail.getCSVRepresentation());
                }
            }
        }
    }

    protected abstract String getPrettyRuleOutput(RuleOutput var1);

    protected abstract String getPrettyRuleOutputDetail(RuleOutputDetail var1);
}

