/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.preset;

public enum DefaultRuleID {
    FILE_SIZE("Checks that the file is not too big", 20),
    FILE_ENCODING("Verifies that the file is encoded in UTF-8", 21),
    FILE_FORMAT("Verifies that the file is well formatted (e.g. CSV format)", 22),
    BASIC_DUPLICATES("Checks that a value (or combinations of values) is unique, loading all records", 30),
    BUNCH_DUPLICATES("Checks that a value (or combinations of values) is unique, loading by bunch", 31),
    HEADER_POSITIONAL("Checks that each header is in the proper position, with the proper name", 40),
    HEADER_NAMED("Checks that all headers are present (regardless from the order))", 41),
    RECORD_FORMAT("Checks that the record contains the right separator, and the expected number of data", 50),
    FIELD_DATA_TYPE("Checks the datatype (integer, alphanumeric, etc)", 60),
    FIELD_MANDATORY("Checks that \"strictly mandatory\" (aka \"mandatory\") fields are not empty", 65),
    FIELD_MAX_SIZE("Checks the max size property of the field", 66),
    FIELD_UNKNOWN_VALUE("Checks whether a mandatory field holds an unknown value", 67),
    FIELD_IMPORTANT("Checks that \"almost mandatory\" (aka \"important\") fields are not empty", 68),
    FIELD_RANGE("Checks the the field value is within the allowed range or list", 80),
    IS_BIGGER_THAN("Check if the first number is bigger than the second number", 100),
    RECORD_ID_AND_SEX("Consistency between the first char of the recordID (M/F) and the sex variable (1/2)", 101),
    DATE_RULE_BIRTH("Consistency for Date of Birth (DoB)", 102),
    AGE_BY_DAY_MONTH_YEAR("Calculates age using day, month and year", 103),
    AGE_BY_MONTH_YEAR("Calculates age using only month and year", 104),
    AGE_BIRTH_INCIDENCE_1("Consistency between Age, Date of Birth and Date of Incidence - 2014 (E-AGED)", 200),
    AGE_BIRTH_INCIDENCE_2("Age is missing, and it's not possible to calculate it (E-AGEC)", 201),
    BEHAVIOUR_MORPHOLOGY("Behaviour - Morphology (W-MOBE)", 204),
    BEHAVIOUR_MORPHOLOGY_TOPOGRAPHY("Behaviour - Morphology - Topography (E-BETO)", 205),
    DATE_BIRTH_INCIDENCE_1("Consistency between Date Last Vital Status? To be confirmed  - 2 (E-CoDA)", 206),
    DATE_LAST_VITAL_STATUS_1("Consistency between date of Incidence, Follow-Up and Birth (E-CoDV)", 207),
    DATE_RULE_INCIDENCE("Consistency for date of Incidence (DoI)", 208),
    DATE_RULE_FU("Consistency for date of Follow-Up (FU aka DoFU)", 209),
    DATE_RULE_REGISTER("Consistency for date of case registration (DoR)", 210),
    DIAGNOSIS_MORPHOLOGY_1("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 211),
    DIAGNOSIS_MORPHOLOGY_2("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 212),
    DIAGNOSIS_MORPHOLOGY_3("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 213),
    DISEASE_EXTENT_1("Combination of Topography and number of examined and metastatic nodes", 214),
    DISEASE_EXTENT_2("Combination of Topography and tumour size", 215),
    DISEASE_EXTENT_3("Combination of Basis of Diagnosis and pT", 216),
    DISEASE_EXTENT_4("Combination of Basis of Diagnosis and pN", 217),
    DISEASE_EXTENT_5("Checks if Morphology is specific enough according to Basis of Diagnosis", 218),
    DISEASE_EXTENT_6("Validates combination of Topography and Extent of Disease", 219),
    DISEASE_EXTENT_7("Combination of number of metastatic nodes and condensed N", 220),
    DISEASE_EXTENT_8("Consistency between behaviour and TNM/EOD (page 41, protocol 2014)", 221),
    DISEASE_EXTENT_9("Validates the combination of extent of disease, cN, pN and condensed N", 222),
    EDITION_CAUSE_OF_DEATH("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 223),
    GRADE_BEHAVIOUR("Consistency between morphology/grade (for some topographies): see Table 5)", 224),
    GRADE_MORPHOLOGY("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 225),
    MORPHOLOGY_TOPOGRAPHY("Consistency between Morphology and Topography W-MOTO", 226),
    N_MET_EXAM_NODES("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 227),
    SEX_MORPHOLOGY("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 228),
    SEX_TOPOGRAPHY("Consistency between Sex and Topography (E-SETO)", 229),
    SURVIVAL_ANALYSIS("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 230),
    SURVIVAL_INCIDENCE_FOLLOW_UP("Survival is missing, and can not even be calculated (W-SURV aka custom E-MISS)", 231),
    TOPOGRAPHY_LATERALITY("PLACEHOLDER: short cross-field rule description (reference to ECARS/table/page ?)", 232),
    AGE_TUMOUR_H1("Unlikely and rare combinations of age and tumour type - 1 (W-AGMT)", 233),
    TNM_MORPHOLOGY("Morphology not addressed by the Topography table (W-TNMM)", 236),
    TNM_NODES("TNM + met_Nodes not valid (p.41), ENCR Incidence 2014 protocol", 237),
    TNM_STAGE("TNM rule 6 for ENCR 2014-2020 Incidence protocols, based on Annex II (W-TNMS)", 238),
    TNM_EDITION_PM("Consistency between TNM edition and pM value (W-EDIM)", 239),
    DISEASE_EXTENT_10("Consistency between behaviour and TNM/EOD (page 41, protocol 2014)", 240),
    PRIMARY_DUPLICATES_1("Primary duplicates with same recordID, legacy rule, ENCR Incidence 2014", 250),
    PRIMARY_DUPLICATES_STRICT_1("Primary duplicates with same recordID, ENCR Incidence 2014 (W-MPCR)", 251),
    PRIMARY_DUPLICATES_SOFT_1("Primary duplicates with same recordID, ENCR Incidence 2014 (W-MPMT)", 252),
    AGE_BIRTH_INCIDENCE_3("Consistency between Age, Date of Birth and Date of Incidence - 2020 (E-AGED)", 300),
    AGE_BIRTH_INCIDENCE_4("Age is missing, and it's not possible to calculate it (E-AGEC)", 301),
    DATE_BIRTH_INCIDENCE_2("Consistency between Date Last Vital Status? To be confirmed  - 2 (E-CoDA)", 302),
    DATE_LAST_VITAL_STATUS_2("Consistency between date of Incidence, Follow-Up and Birth (E-CoDV)", 304),
    TNM_EDITION("TNM Edition not valid (W-TNME)", 305),
    AGE_TUMOUR_H2("Unlikely and rare combinations of age and tumour type - 1 (W-AGMT)", 306),
    TOPO_MORPHO_GRADE_BEH("Topography + behaviour + grade not valid (tab.5)", 307),
    AUTOPSY_VITAL_STATUS("Autopsy + Vital status + Surv time + DoI/DoF (Tab. 12)", 310),
    BOD_VITAL_STATUS("BoD + Vital status + Surv time + DoI/DoF (Tab. 12)", 311),
    VITAL_STATUS_BOD_AUTOPSY("BoD + Vital status + Surv time + DoI/DoF (Tab. 12)", 312),
    SURGERY_BOD("Surgery + BoD not valid (p.33)", 313),
    SURGERY_PT("Surgery + pT not valid (p.33)", 314),
    SURVIVAL_TIME_UNKNOWN("Surv time+Date of Followup not valid (Tab. 13)", 315),
    SURVIVAL_DATE_ANALYSIS("W-SUDA: Survival time not consistent with Date of Incidence and Date of Followup (Tab. 14)", 316),
    PRIMARY_DUPLICATES_2("Standard primary duplicates with same recordID, ENCR Incidence 2020", 350),
    PRIMARY_DUPLICATES_STRICT_2("Standard primary duplicates with same recordID, ENCR Incidence 2020 (E-MPCR)", 351),
    PRIMARY_DUPLICATES_SOFT_2("Standard primary duplicates with same recordID, ENCR Incidence 2020 (W-MPMT)", 352),
    PRIMARY_DUPLICATES_3("Primary duplicates \"merging\" rule, ENCR Incidence 2020 (MPMT Algorithm)", 360),
    DIAGNOSIS_MORPHOLOGY_4("Table 4: Basis of diagnosis (BoD), pages 17-19, BoD in 0-4 (W-BDMO)", 308),
    DIAGNOSIS_MORPHOLOGY_5("Table 4: Basis of diagnosis (BoD), pages 17-19, BoD = 5 or 7 (W-BDMS)", 309);

    public final String description;
    public final int id;

    private DefaultRuleID(String description, int id) {
        this.description = description;
        this.id = id;
    }

    public String getID() {
        return Integer.toString(this.id);
    }

    public static DefaultRuleID getDefaultRuleID(int id) {
        for (DefaultRuleID entry : DefaultRuleID.values()) {
            if (id != entry.id) continue;
            return entry;
        }
        return null;
    }
}

