/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.preset;

public enum DefaultProtocolID {
    INCIDENCE_2014("Incidence (default)", "Default Incidence protocol 2014", 1),
    INCIDENCE_2014_EXT("Incidence (extented)", "Extended (57 fields) Incidence protocol 2014", 2),
    MORTALITY_2014("Mortality (default)", "Default Mortality protocol 2014", 3),
    MORTALITY_2014_EXT("Mortality (extented)", "Extended (6 fields) Mortality protocol 2014", 4),
    POPULATION_2014("Population (default)", "Default Population protocol 2014", 5),
    POPULATION_2014_EXT("Population (extented)", "Extended (5 fields) Population protocol 2014", 6),
    LIFE_TABLE_2014("Life Table (default)", "Default Life Table protocol 2014", 7),
    LIFE_TABLE_2014_EXT("Life Table (extented)", "Extended (5 fields) Life Table protocol 2014", 8),
    TEST_PROTOCOL("Test protocol (wrong)", "Protocol with wrong configuration (intented)", 9),
    DEMO_PROTOCOL("Demo protocol (valid)", "Demo protocol (with general purpose rules)", 10),
    INCIDENCE_2020("Incidence (default)", "Default Incidence protocol 2022", 11),
    INCIDENCE_2020_BIS("Incidence (placeholder)", "Placeholder (not used yet)", 12),
    MORTALITY_2020_UNIT("Mortality (age unit)", "First Mortality protocol 2022 (Age Unit)", 13),
    MORTALITY_2020_RANGE("Mortality (age range)", "Second Mortality protocol 2022 (Age Range)", 14),
    POPULATION_2020_UNIT("Population (age unit)", "First Population protocol 2022 (Age Unit)", 15),
    POPULATION_2020_RANGE("Population (age range)", "Second Population protocol 2022 (Age Range)", 16),
    LIFE_TABLE_2020("Life Table (default)", "Default Life Table protocol 2022", 17),
    LIFE_TABLE_2020_BIS("Life Table (placeholder)", "Placeholder (not used yet)", 18);

    public final String name;
    public final String description;
    public final int id;

    private DefaultProtocolID(String name, String description, int id) {
        this.name = name;
        this.description = description;
        this.id = id;
    }

    public String getID() {
        return String.valueOf(this.id);
    }

    public static DefaultProtocolID getByID(int protocolID) {
        for (DefaultProtocolID protocol : DefaultProtocolID.values()) {
            if (protocol.id != protocolID) continue;
            return protocol;
        }
        return null;
    }
}

