/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine;

import eu.europa.ec.jrc.qcs.engine.ValidationCycle;

public enum ValidationLevel {
    UNDEF("Unknown validation level (wrong configuration)", -1, ValidationCycle.UNDEF),
    FILE("Rules which affect the file as a whole (e.g. format, duplicates etc.)", 0, ValidationCycle.PRE_RECORD),
    HEADER("Rules which affect only the dataset's header", 1, ValidationCycle.PRE_RECORD),
    RECORD("Rules which affect a single record as a whole (e.g. separator, number of fields etc.)", 2, ValidationCycle.RECORD),
    FIELD("Rules which regard field's check (e.g. datatype, maxsize, etc.)", 3, ValidationCycle.RECORD),
    RANGE("Rules which regard field's allowed values", 4, ValidationCycle.RECORD),
    CROSS_FIELD("Rules which regard coherence between field in the same record", 5, ValidationCycle.RECORD),
    CROSS_RECORD("Rules which regard coherence between different records", 6, ValidationCycle.POST_RECORD);

    public final String description;
    public final int level;
    public final ValidationCycle cycle;

    private ValidationLevel(String description, int level, ValidationCycle cycle) {
        this.description = description;
        this.level = level;
        this.cycle = cycle;
    }

    public boolean isPreRecordCycle() {
        return this.cycle == ValidationCycle.PRE_RECORD;
    }

    public boolean isRecordCycle() {
        return this.cycle == ValidationCycle.RECORD;
    }

    public boolean isPostRecordCycle() {
        return this.cycle == ValidationCycle.POST_RECORD;
    }

    public static ValidationLevel getValidationLevel(int level) {
        String levelAsString = String.valueOf(level);
        return ValidationLevel.parseValidationLevel(levelAsString);
    }

    public static ValidationLevel parseValidationLevel(String value) {
        int level;
        try {
            level = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            level = -1;
        }
        if (level >= 0) {
            for (ValidationLevel validationLevel : ValidationLevel.values()) {
                if (level != validationLevel.level) continue;
                return validationLevel;
            }
        }
        return UNDEF;
    }
}

