/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.ProtocolViewDAO;
import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationMessageDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.input.DataConnection;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleScope;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.DataSetWriter;
import eu.europa.ec.jrc.qcs.engine.InvalidProtocolException;
import eu.europa.ec.jrc.qcs.engine.RawFilesWriter;
import eu.europa.ec.jrc.qcs.engine.RulesFactory;
import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultMessageID;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultProtocolID;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.RuleRuntimeException;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.ExternalSorter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericCrossRecordRule;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.WhereCondition;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2020.PrimaryDuplicatesSoftRule2;
import eu.europa.ec.jrc.qcs.gui.model.MessageLayout;
import eu.europa.ec.jrc.qcs.gui.model.workers.GeneralWorker;
import eu.europa.ec.jrc.qcs.report.CSVReport;
import eu.europa.ec.jrc.qcs.report.PDFReport;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationEngine {
    protected int validationRunID;
    protected int lineNumber;
    protected int messageNumber;
    protected int currentRuleIndex;
    protected List<AbstractRule> validRules;
    protected int firstPostRecordIndexRule;
    protected List<Integer> functionRuleIDs;
    protected List<WhereCondition> whereConditions;
    protected Map<AbstractRule, WhereCondition> whereConditionsByRule;
    protected List<RuleDefinition> skippedRules;
    protected ValidationMessage skippedMessage;
    protected List<RuleOutput> previousOutput;
    protected Set<Integer> invalidLineNumbers;
    protected boolean stopValidation;
    protected boolean stopAlreadyNotified;
    protected boolean noGUIAlreadyNotified;
    protected ProtocolView protocolView;
    private RulesFactory rulesFactory;
    protected GeneralWorker validationWorker;
    protected DataSetReader dataSetReader;
    protected DataSetWriter dataSetWriter;
    protected RawFilesWriter rawFilesWriter;
    protected boolean rawFiles = true;
    protected boolean dataRecordFiles = true;
    protected boolean report = true;
    protected boolean saveReferenceData = true;
    protected List<ReferenceField> referenceFields;
    protected boolean benchmark = false;
    protected boolean profileRules = false;
    protected int chunckSize;
    protected int maxRules = 0;
    public static final int ALL_RULES = 0;
    protected ProtocolViewDAO protocolViewDAO;
    protected RuleDefinitionDAO ruleDefinitionDAO;
    protected ValidationRunDAO validationRunDAO;
    protected ValidationMessageDAO validationMessageDAO;
    protected boolean logProtocol = false;
    protected boolean logRules = false;
    protected boolean logRecords = false;
    protected boolean logErrors = false;
    protected boolean logSummary = false;
    protected static Logger logger = LoggerFactory.getLogger(ValidationEngine.class);

    public ValidationEngine() {
        int protocolID;
        String defaultProtocolID = Configuration.getInstance().getProperty(Property.DEFAULT_PROTOCOL);
        try {
            protocolID = Integer.parseInt(defaultProtocolID);
        }
        catch (NumberFormatException e) {
            logger.error("reset() - Wrong default protocolID: " + defaultProtocolID);
            protocolID = DefaultProtocolID.INCIDENCE_2020.id;
        }
        if (logger.isInfoEnabled()) {
            logger.info("ValidationEngine() - Set default protocolID: " + protocolID);
        }
        this.init();
        this.setProtocolView(protocolID);
    }

    protected void init() {
        this.maxRules = 0;
        this.rulesFactory = new RulesFactory();
        this.dataSetReader = new DataSetReader();
        this.dataSetReader.setMaxRows(0);
        this.dataSetWriter = new DataSetWriter();
        this.dataSetWriter.setWriteOnDAO(true);
        this.dataSetWriter.setWriteOnFile(false);
        this.rawFilesWriter = new RawFilesWriter();
        this.rawFilesWriter.setWriteOnDAO(false);
        this.rawFilesWriter.setWriteOnFile(true);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        this.protocolViewDAO = (ProtocolViewDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL_VIEW));
        this.validationRunDAO = (ValidationRunDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_RUN));
        this.ruleDefinitionDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
        this.validationMessageDAO = (ValidationMessageDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_MESSAGE));
        this.skippedMessage = (ValidationMessage)this.validationMessageDAO.getByID(DefaultMessageID.C_SKIP.id);
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Fetched ValidationMessage : " + this.skippedMessage.getDescription());
        }
    }

    public void initDataAccessors() {
        this.softReset();
        int maxValidationRunID = this.validationRunDAO.getMaxID();
        this.validationRunID = maxValidationRunID + 1;
        int schemaID = this.protocolView.getSchemaID();
        this.dataSetReader.resetDataset();
        this.dataSetWriter.setValidationRunID(this.validationRunID);
        this.dataSetWriter.setSchemaID(schemaID);
        this.dataSetWriter.setHeader();
        this.rawFilesWriter.checkTempFolder();
        this.rawFilesWriter.setValidationRunID(this.validationRunID);
        this.rawFilesWriter.reset();
        if (logger.isDebugEnabled()) {
            logger.debug("hardReset() - Next validationRunID: " + this.validationRunID + " (schemaID = " + schemaID + ")");
        }
        this.rawFilesWriter.cleanTempFolder(maxValidationRunID);
    }

    public void softReset() {
        this.messageNumber = 0;
        this.currentRuleIndex = 0;
        this.invalidLineNumbers = new HashSet<Integer>();
        int referenceVariables = 0;
        this.saveReferenceData = Configuration.getInstance().getBooleanProperty(Property.REFERENCE_DATA);
        this.chunckSize = Configuration.getInstance().getIntegerProperty(Property.MONITOR_BUNCH_SIZE);
        if (this.chunckSize <= 0) {
            int defaultSize = 1000;
            logger.error("Wrong chunck size: " + this.chunckSize + " -> using default value: " + defaultSize);
            this.chunckSize = defaultSize;
        }
        this.stopValidation = false;
        this.stopAlreadyNotified = false;
        this.noGUIAlreadyNotified = false;
        if (this.saveReferenceData) {
            int protocolID = this.protocolView.getProtocolID();
            ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
            this.referenceFields = validationOptions.getReferenceFields(protocolID);
            referenceVariables = this.referenceFields.size();
            if (logger.isTraceEnabled()) {
                logger.trace("softReset() - Loaded referenceFields: " + String.valueOf(this.referenceFields));
            }
        }
        if (logger.isInfoEnabled()) {
            Object comment = this.saveReferenceData ? " (" + referenceVariables + " fields)" : "";
            logger.info("softReset() - Registry data feature: " + this.saveReferenceData + (String)comment);
        }
    }

    public void hardReset() {
        this.softReset();
        this.firstPostRecordIndexRule = 0;
        this.validRules = new ArrayList<AbstractRule>();
        this.functionRuleIDs = new ArrayList<Integer>();
        this.skippedRules = new ArrayList<RuleDefinition>();
        this.whereConditions = new ArrayList<WhereCondition>();
        this.whereConditionsByRule = new HashMap<AbstractRule, WhereCondition>();
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info("hardReset() - Created new collections (rules, where conditions etc.)");
        }
    }

    public List<AbstractRule> loadAllRules() {
        List<ProtocolToRule> protocolTorules = this.protocolView.getProtocolToRules();
        SchemaView schemaView = this.protocolView.getFullSchemaView();
        int schemaID = schemaView.getSchemaID();
        if (logger.isDebugEnabled()) {
            logger.debug("loadAllRules() - Using schema view: " + String.valueOf(schemaView));
        }
        int currentLevel = ValidationLevel.UNDEF.level;
        int counter = 0;
        boolean recordCycle = false;
        int numberOfModifiedRules = 0;
        for (ProtocolToRule protocolToRule : protocolTorules) {
            int level;
            RuleDefinition ruleDefinition = protocolToRule.getRule();
            RuleType ruleType = ruleDefinition.getRuleType();
            if (logger.isDebugEnabled()) {
                logger.debug("loadAllRules() - Current protocolTorule: " + protocolToRule.getId() + " [" + protocolToRule.getPriority() + "] -> " + ruleDefinition.getName());
            }
            if ((level = ruleType.validationLevel.level) >= currentLevel) {
                if (logger.isDebugEnabled()) {
                    logger.debug("loadAllRules() - Increasing validation level from " + currentLevel + " to " + level);
                }
                currentLevel = level;
            } else {
                String message;
                if (logger.isDebugEnabled()) {
                    logger.debug("loadAllRules() - Wrong validation level: " + level);
                }
                if (ruleType.validationLevel != ValidationLevel.UNDEF) {
                    message = "Rule '" + ruleDefinition.getName() + "' do not respect the LEVEL order ";
                    message = message + "(rule_level=" + level + ", expected=" + currentLevel + ")";
                    logger.error(message);
                    throw new InvalidProtocolException(message);
                }
                message = "Rule '" + ruleDefinition.getName() + "' has a wrong/missing configuration";
                logger.warn(message);
            }
            AbstractRule ruleImpl = this.rulesFactory.getRuleImplementation(ruleDefinition);
            if (this.maxRules != 0 && ++counter > this.maxRules) {
                logger.warn("");
                logger.warn("loadAllRules() - TEST_MODE - Loaded only first " + this.maxRules + " rules");
                break;
            }
            if (counter % 10 == 0) {
                this.notifyMessageToWorker("Loaded configuration for " + counter + " rules");
            }
            if (ruleImpl != null) {
                String message;
                ruleImpl.setValidationEngine(this);
                this.rulesFactory.setRuleConfiguration(ruleImpl, protocolToRule);
                try {
                    SchemaView targetSchemaView = ruleImpl.getRuleConfiguration().getTargetSchemaView();
                    int ruleSchemaID = targetSchemaView.getSchemaID();
                    if (schemaID != ruleSchemaID) {
                        ++numberOfModifiedRules;
                        ruleImpl.getRuleConfiguration().setTargetSchemaView(schemaView);
                        if (logger.isDebugEnabled()) {
                            message = ruleImpl.toShortString() + " -> Forced to: " + schemaID;
                            logger.debug("loadAllRules() - Wrong schemaID (" + ruleSchemaID + ") for rule " + message);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    ruleDefinition.addErrorMessage(e.getMessage());
                }
                boolean isValid = false;
                try {
                    isValid = ruleImpl.validate();
                }
                catch (InvalidRuleException e) {
                    logger.error(e.getMessage());
                    ruleDefinition.addErrorMessage(e.getMessage());
                }
                if (isValid) {
                    this.loadWhereCondition(ruleImpl);
                    boolean validFunctionRules = this.loadFunctionRules(ruleImpl);
                    if (validFunctionRules) {
                        this.validRules.add(ruleImpl);
                        ValidationLevel validationLevel = ruleImpl.getRuleConfiguration().getValidationLevel();
                        if (!recordCycle && validationLevel.isRecordCycle()) {
                            recordCycle = true;
                        }
                        if (recordCycle && this.firstPostRecordIndexRule == 0 && validationLevel.isPostRecordCycle()) {
                            this.firstPostRecordIndexRule = this.validRules.size() - 1;
                        }
                    } else {
                        this.addSkippedRule(ruleDefinition);
                        ruleDefinition.addErrorMessage("Function rules not loaded");
                        message = "SKIPPING (wrong function rules): " + ruleDefinition.getName();
                        logger.warn("loadAllRules() - ProtocolToRule: " + String.valueOf(protocolToRule) + " - (" + ruleType.getLevel() + ") -> " + message);
                    }
                } else {
                    this.addSkippedRule(ruleDefinition);
                    String message2 = "SKIPPING (no information): " + ruleDefinition.getName();
                    logger.warn("loadAllRules() - ProtocolToRule: " + String.valueOf(protocolToRule) + " - (" + ruleType.getLevel() + ") -> " + message2);
                }
            } else {
                this.addSkippedRule(ruleDefinition);
                String specificMessage = "Class not found";
                ruleDefinition.addErrorMessage(specificMessage);
                String message = "loadAllRules() - SKIPPING (" + specificMessage + "): " + ruleDefinition.getName();
                logger.warn(message + " - ProtocolToRule: " + String.valueOf(protocolToRule));
            }
            if (this.checkIfStopValidation()) {
                logger.warn("loadAllRules() - Stopping loading validation rules");
                break;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("loadAllRules() - Handled AbstractRule rule: " + String.valueOf(ruleImpl) + " (" + counter + ")");
        }
        if (numberOfModifiedRules > 0) {
            logger.warn("");
            logger.warn("loadAllRules() - Modified schemaID for               : " + numberOfModifiedRules + " rules");
        }
        if (!this.checkIfStopValidation()) {
            this.notifyMessageToWorker("\nValidation process: started");
        }
        return this.validRules;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadFunctionRules(AbstractRule rule) {
        RuleConfiguration configuration = rule.getRuleConfiguration();
        List<Integer> functionRuleIDs = configuration.getFunctionRuleIDs();
        ProtocolToRule protocolToRule = new ProtocolToRule(configuration);
        if (functionRuleIDs == null || functionRuleIDs.size() <= 0) {
            if (!logger.isDebugEnabled()) return true;
            logger.debug("loadFunctionRules() - No function rules for rule: " + String.valueOf(rule));
            return true;
        }
        for (int ruleID : functionRuleIDs) {
            if (!this.functionRuleIDs.contains(ruleID)) {
                RuleDefinition ruleDefinition;
                AbstractRule functionRule;
                String functionMessage;
                block12: {
                    functionMessage = null;
                    functionRule = null;
                    ruleDefinition = (RuleDefinition)this.ruleDefinitionDAO.getByID(ruleID);
                    try {
                        functionRule = this.rulesFactory.getRuleImplementation(ruleDefinition);
                        functionRule.setValidationEngine(this);
                    }
                    catch (InvalidRuleException e) {
                        functionMessage = e.getMessage();
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug("InvalidRuleException for function rule: " + functionMessage);
                    }
                }
                if (functionRule == null) {
                    this.addSkippedRule(ruleDefinition);
                    ruleDefinition.addErrorMessage(functionMessage);
                    String message = "Missing functional ruleID: " + ruleID + " -> " + String.valueOf(ruleDefinition);
                    logger.error(message);
                    return false;
                }
                protocolToRule.setRuleID(ruleID);
                this.rulesFactory.setRuleConfiguration(functionRule, protocolToRule);
                if (logger.isDebugEnabled()) {
                    logger.debug("loadFunctionRules() - Set protocolToRule = " + String.valueOf(protocolToRule));
                }
                boolean isValid = functionRule.validate();
                int functionRuleID = functionRule.getId();
                if (!isValid) {
                    this.addSkippedRule(ruleDefinition);
                    return false;
                }
                this.validRules.add(functionRule);
                this.functionRuleIDs.add(functionRuleID);
                if (logger.isDebugEnabled()) {
                    logger.debug("loadFunctionRules() - RuleID = " + ruleID + " requires function rule : " + String.valueOf(functionRule));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("loadFunctionRules() - Function rule with ID " + ruleID + " -> already loaded");
            }
            if (!this.checkIfStopValidation()) continue;
            logger.warn("Stopping loading functional rules");
            return false;
        }
        return true;
    }

    protected void loadWhereCondition(AbstractRule rule) {
        if (rule instanceof GenericCrossRecordRule) {
            GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)rule;
            if (crossRecordRule.hasWhereCondition()) {
                WhereCondition whereCondition = crossRecordRule.getWhereCondition();
                if (logger.isDebugEnabled()) {
                    logger.debug("loadWhereCondition() - " + rule.toShortString() + ". Default where condition: " + String.valueOf(whereCondition));
                }
                if (!this.whereConditions.contains(whereCondition)) {
                    this.whereConditions.add(whereCondition);
                    this.whereConditionsByRule.put(rule, whereCondition);
                } else {
                    for (WhereCondition cachedWhereCondition : this.whereConditions) {
                        if (!cachedWhereCondition.equals(whereCondition)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("loadWhereCondition() - RuleID: " + rule.getId() + ". Setting cached where condition: " + String.valueOf(cachedWhereCondition));
                        }
                        crossRecordRule.setWhereCondition(cachedWhereCondition);
                        break;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("loadWhereCondition() - RuleID: " + rule.getId() + ". Set where condition: " + String.valueOf(crossRecordRule.getWhereCondition()));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("loadWhereCondition() - No where condition for rule: " + String.valueOf(rule));
        }
    }

    public void run() {
        int missing;
        DataRecord record;
        boolean firstInit;
        if ((this.benchmark || this.profileRules) && !(firstInit = SystemTester.initBenchmark())) {
            SystemTester.benchmark("start.validation");
        }
        if (this.protocolView == null) {
            String message = "Wrong engine configuration: missing target protocol";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("run() - Resetting engine");
        }
        this.initDataAccessors();
        ValidationRun validationRun = new ValidationRun();
        validationRun.setDataSetName(this.dataSetReader.getFilePath());
        validationRun.setUserName(System.getProperty("user.name"));
        validationRun.setProtocolID(this.getProtocolID());
        if (this.benchmark) {
            SystemTester.benchmark("Loading all rules");
        }
        if (this.validRules.size() == 0) {
            this.loadAllRules();
            if (logger.isInfoEnabled()) {
                logger.info("");
                logger.info("Loaded new list of valid rules      : " + this.validRules.size() + " (protocolID=" + this.protocolView.getId() + ")");
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Reusing current list of valid rules : " + this.validRules.size() + " (protocolID=" + this.protocolView.getId() + ")");
        }
        if (this.logProtocol && logger.isInfoEnabled()) {
            logger.info("");
            logger.info("List of valid rules in protocol (" + this.validRules.size() + " rules): ");
            String formattedRules = "\n\n" + this.getFormattedRules(this.validRules, true);
            logger.info(formattedRules);
        }
        if (this.checkIfStopValidation()) {
            logger.info("Validation process stopped before starting");
            return;
        }
        validationRun.setProcessStart(new Date());
        if (logger.isDebugEnabled()) {
            logger.debug("run() - Pre-analysis of dataset (e.g. number of lines)");
        }
        int numberofRecords = this.dataSetReader.estimateDataSetSize(this.protocolView);
        if (this.validationWorker != null) {
            this.validationWorker.setMaxProgress(numberofRecords);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("run() - Completed pre-analysis of dataset -> number of lines = " + numberofRecords);
        }
        if (logger.isInfoEnabled()) {
            int maxRules = this.getMaxRules();
            int maxRows = this.dataSetReader.getMaxRows();
            String maxRulesAsString = maxRules == 0 ? "ALL" : String.valueOf(maxRules);
            String maxRowsAsString = maxRows == 0 ? "ALL" : String.valueOf(maxRows);
            logger.info("");
            logger.info("Using protocol : " + String.valueOf(this.protocolView));
            logger.info("Target dataset : " + validationRun.getDataSetName());
            logger.info("Dataset's rows : " + numberofRecords);
            logger.info("Maximum rows   : " + maxRowsAsString);
            logger.info("Maximum rules  : " + maxRulesAsString);
            logger.info("Process start  : " + String.valueOf(validationRun.getProcessStart()));
        }
        if (numberofRecords <= 0) {
            logger.info("");
            logger.info("Empty dataset  : quitting validation process...");
            return;
        }
        if (this.whereConditions.size() > 0) {
            if (this.benchmark) {
                SystemTester.benchmark("SORTING cycle: handling where conditions");
            }
            if (logger.isInfoEnabled()) {
                logger.info("");
                logger.info("Starting SORTING cycle (where conditions)");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("SORTING cycle not necessary (no where conditions)");
        }
        for (WhereCondition whereCondition : this.whereConditions) {
            this.sortDataSet(whereCondition);
        }
        if (this.whereConditions.size() > 0 && logger.isInfoEnabled()) {
            logger.info("Completed SORTING cycle");
        }
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Initialising WORKING files");
        }
        for (int postRecordIndexRule = this.firstPostRecordIndexRule; postRecordIndexRule < this.validRules.size(); ++postRecordIndexRule) {
            AbstractRule postRecordRule = this.validRules.get(postRecordIndexRule);
            if (!(postRecordRule instanceof GenericCrossRecordRule)) continue;
            GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)postRecordRule;
            crossRecordRule.initAcceptableFile();
        }
        if (this.benchmark) {
            SystemTester.benchmark("PRE_RECORD cycle: started");
        }
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Starting PRE_RECORD cycle (current rule index = " + this.currentRuleIndex + ")");
        }
        this.lineNumber = 0;
        this.currentRuleIndex = 0;
        while (this.currentRuleIndex < this.validRules.size()) {
            List<RuleOutput> output;
            AbstractRule rule = this.validRules.get(this.currentRuleIndex);
            RuleConfiguration ruleConfiguration = rule.getRuleConfiguration();
            ValidationLevel validationLevel = ruleConfiguration.getValidationLevel();
            if (!validationLevel.isPreRecordCycle()) {
                if (!logger.isInfoEnabled()) break;
                logger.info("Completed PRE_RECORD cycle");
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("PRE_RECORD cycle - Rule: " + rule.toShortString());
            }
            if ((output = this.selectRuleByScope(rule)) == RuleOutput.NOT_APPLICABLE) {
                if (!logger.isInfoEnabled()) break;
                logger.info("");
                logger.warn("PRE_RECORD cycle: forced completition (rule's scope maybe wrong)");
                break;
            }
            if (this.logErrors) {
                this.printRuleResults("PRE_RECORD", output);
            }
            if (this.rawFiles && !this.isCorrectRecord(output)) {
                this.rawFilesWriter.saveRuleOutputDetail(rule, this.lineNumber, output);
                validationRun.addFailedPreliminaryRuleIDs(rule);
            }
            if (ruleConfiguration.getRuleType() == RuleType.DUPLICATES) {
                String suffix = output.size() == 1 ? " duplicate" : " duplicates";
                String message = rule.getName() + ": found " + output.size() + suffix + "\n";
                this.notifyMessageToWorker(message);
            }
            if (this.dataRecordFiles && rule instanceof GenericCrossRecordRule) {
                GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)rule;
                if (!this.isCorrectRecord(output)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID output for rule " + rule.toShortString() + ": " + output.size() + " invalid records");
                    }
                    List<DataRecord> invalidRecords = crossRecordRule.getInvalidRecords();
                    int written = this.dataSetWriter.saveRecordWithIssues(invalidRecords);
                    this.setInvalidLineNumber(output);
                    if (logger.isDebugEnabled()) {
                        logger.debug("PRE_RECORD cycle: added " + written + " invalid records");
                    }
                }
            }
            if (this.checkIfStopValidation()) {
                logger.info("Validation process stopped during first validation cycle (PRE-RECORD)");
                return;
            }
            ++this.currentRuleIndex;
        }
        if (this.benchmark) {
            SystemTester.benchmark("RECORD cycle: started");
        }
        int firstRecordRule = this.currentRuleIndex;
        int stripCriterion = Configuration.getInstance().getIntegerProperty(Property.STRIP_CRITERION);
        if (logger.isInfoEnabled()) {
            logger.info("");
            int lastRecordRuleIndex = this.hasPostRecordCycle() ? this.firstPostRecordIndexRule - 1 : this.validRules.size();
            logger.info("Starting RECORD cycle : from ruleIndex " + firstRecordRule + " to ruleIndex " + lastRecordRuleIndex + " (included)");
            logger.info("Strip criterion       : " + stripCriterion);
        }
        this.dataSetReader.resetDataset();
        SchemaView schemaView = this.protocolView.getSchemaView();
        Object[] schemaHeaderArray = schemaView.getHeaders();
        while (this.dataSetReader.hasNext() && (record = this.dataSetReader.getNextDataRecord()) != null) {
            boolean isCorrectRecord = true;
            this.lineNumber = this.dataSetReader.getCounter();
            if (logger.isTraceEnabled()) {
                logger.trace("Setting columnNames: " + Arrays.toString(schemaHeaderArray));
            }
            record.setColumnNames((String[])schemaHeaderArray);
            if (this.logRecords) {
                logger.info("");
                logger.info(this.lineNumber + ") RECORD = " + String.valueOf(record));
                logger.info("Record's header = " + Arrays.toString(record.getColumnNames()));
                logger.info("-------------------------------------");
            }
            if (this.benchmark) {
                this.benchmarkRecord("RECORD_START: ", record);
            }
            if (this.lineNumber % this.chunckSize == 0) {
                this.notifyMessageToWorker("RECORD cycle - reading line: " + this.lineNumber);
            }
            this.previousOutput = null;
            int lastMainRecordIndex = this.firstPostRecordIndexRule > 0 ? this.firstPostRecordIndexRule : this.validRules.size();
            this.applyStripQuotesCriterion(stripCriterion, record);
            while (this.currentRuleIndex < lastMainRecordIndex) {
                RuleConfiguration ruleConfiguration;
                List<RuleOutput> output;
                AbstractRule rule;
                block123: {
                    rule = this.validRules.get(this.currentRuleIndex);
                    RuleScope ruleScope = rule.getRuleConfiguration().getRuleScope();
                    this.printCurrentRule("RECORD_SCOPE rule");
                    rule.reset();
                    if (RuleScope.RECORD != ruleScope) {
                        logger.warn("Rule out of scope (index = " + this.currentRuleIndex + ")");
                        break;
                    }
                    if (this.previousOutput != null) {
                        rule.setPreviousOutputs(this.previousOutput);
                    }
                    if (this.profileRules) {
                        this.benchmarkRule("PRE_RULE", rule);
                    }
                    output = null;
                    try {
                        output = rule.check(record);
                    }
                    catch (RuleRuntimeException e) {
                        String message = "SKIPPING_RECORD - Error applying rule " + rule.toShortString() + " to " + record.toShortString() + ": " + e.getMessage();
                        logger.warn(message);
                        RuleOutput skippedRuleOutput = new RuleOutput(this.skippedMessage);
                        output = new ArrayList<RuleOutput>();
                        output.add(skippedRuleOutput);
                        skippedRuleOutput.setRuleID(rule.getId());
                        if (!this.saveReferenceData) break block123;
                        skippedRuleOutput.resetReferenceData();
                        rule.addReferenceData(skippedRuleOutput, record);
                    }
                }
                if (this.profileRules) {
                    this.benchmarkRule("POST_RULE", rule);
                }
                this.addRunInformation(output);
                if (!this.isCorrectRecord(output)) {
                    isCorrectRecord = false;
                    if (this.previousOutput == null) {
                        this.previousOutput = new ArrayList<RuleOutput>();
                    }
                    this.previousOutput.addAll(output);
                    validationRun.incrementRecordsKO(rule);
                }
                if (this.logErrors) {
                    this.printRuleResults("\tCURRENT_RULE", output);
                }
                if (this.rawFiles && !this.isCorrectRecord(output)) {
                    this.rawFilesWriter.saveRuleOutputDetail(rule, this.lineNumber, output);
                }
                if (this.profileRules) {
                    this.benchmarkRule("SAVE_RULE", rule);
                }
                if (!this.isCorrectRecord(output) && (ruleConfiguration = rule.getRuleConfiguration()).isBlocking()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Invalid record for rule: " + rule.toShortString() + " -> skipping all next rules");
                    }
                    if (!this.dataRecordFiles) break;
                    this.dataSetWriter.saveUncheckeRecord(record, this.lineNumber);
                    break;
                }
                ++this.currentRuleIndex;
            }
            if (this.benchmark) {
                this.benchmarkRecord("RECORD_END: ", record);
            }
            if (this.dataRecordFiles) {
                if (this.isInvalidLineNumber(this.lineNumber)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Ignoring record because already discarded: " + record.toShortString());
                    }
                } else if (isCorrectRecord) {
                    this.dataSetWriter.saveCorrectRecord(record, this.lineNumber);
                } else {
                    this.dataSetWriter.saveRecordWithIssues(record, this.lineNumber);
                }
            }
            if (this.logSummary) {
                this.printRuleResults("\tSUMMARY_ALL_RULES", this.previousOutput);
            }
            if (this.hasPostRecordCycle()) {
                for (int postRecordIndexRule = this.firstPostRecordIndexRule; postRecordIndexRule < this.validRules.size(); ++postRecordIndexRule) {
                    AbstractRule postRecordRule = this.validRules.get(postRecordIndexRule);
                    postRecordRule.setPreviousOutputs(this.previousOutput);
                    if (postRecordRule instanceof GenericCrossRecordRule) {
                        record.push("Line", Integer.toString(this.lineNumber));
                        GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)postRecordRule;
                        crossRecordRule.saveAcceptableRecord(record, this.previousOutput);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Forwarded current record post record rule: " + postRecordRule.toShortString());
                        continue;
                    }
                    logger.warn("Post record rule: " + postRecordRule.toShortString() + " is not a GenericCrossRecordRule instance");
                }
            }
            this.currentRuleIndex = firstRecordRule;
            this.notifyProgressToWorker(this.lineNumber);
            if (!this.checkIfStopValidation()) continue;
            logger.info("Validation process stopped during second validation cycle (RECORD)");
            return;
        }
        if (this.hasPostRecordCycle()) {
            for (int postRecordIndexRule = this.firstPostRecordIndexRule; postRecordIndexRule < this.validRules.size(); ++postRecordIndexRule) {
                AbstractRule postRecordRule = this.validRules.get(postRecordIndexRule);
                if (postRecordRule instanceof GenericCrossRecordRule) {
                    GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)postRecordRule;
                    crossRecordRule.commitAcceptableRecords();
                    continue;
                }
                logger.warn("Post record rule: " + postRecordRule.toShortString() + " is not a GenericCrossRecordRule instance");
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Completed RECORD cycle");
        }
        if (this.hasPostRecordCycle()) {
            if (this.benchmark) {
                SystemTester.benchmark("POST_RECORD cycle: started");
            }
            if (logger.isInfoEnabled()) {
                logger.info("");
                logger.info("Starting POST_RECORD cycle (current rule index = " + this.firstPostRecordIndexRule + ")");
            }
            this.currentRuleIndex = this.firstPostRecordIndexRule;
            while (this.currentRuleIndex < this.validRules.size()) {
                AbstractRule rule = this.validRules.get(this.currentRuleIndex);
                List<RuleOutput> output = this.selectRuleByScope(rule);
                if (this.rawFiles && !this.isCorrectRecord(output)) {
                    this.rawFilesWriter.saveRuleOutputDetail(rule, output);
                }
                if (output == RuleOutput.NOT_APPLICABLE) {
                    if (!logger.isInfoEnabled()) break;
                    logger.info("Completed POST_RECORD cycle");
                    break;
                }
                if (this.logErrors) {
                    this.printRuleResults("POST_RECORD", output);
                }
                if (this.checkIfStopValidation()) {
                    logger.info("Validation process stopped during third validation cycle (POST-RECORD)");
                    return;
                }
                ++this.currentRuleIndex;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Completed POST_RECORD cycle");
            }
        } else {
            this.currentRuleIndex = this.validRules.size();
            if (logger.isInfoEnabled()) {
                logger.info("");
                logger.info("Skipping POST_RECORD cycle (current rule index = " + this.currentRuleIndex + ")");
            }
        }
        if (this.benchmark) {
            SystemTester.benchmark("Validation run: ended");
        }
        if (this.logRules) {
            logger.info("");
            logger.info("Validation run ended. Valid rules in protocol : " + this.validRules.size());
            logger.info("Validation run ended. Current rule index      : " + this.currentRuleIndex);
        }
        if ((missing = this.validRules.size() - this.currentRuleIndex) != 0) {
            String message = "Wrong RuleType configuration: " + missing + " rules skipped";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (this.skippedRules != null && this.skippedRules.size() > 0) {
            logger.warn("");
            logger.warn("List of skipped rules:");
            logger.warn("");
            int counter = 1;
            for (RuleDefinition skipped : this.skippedRules) {
                logger.warn(counter++ + ") " + skipped.toString());
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Validation run COMPLETED with all rules");
        }
        if (this.checkIfStopValidation()) {
            logger.info("Validation process stopped after the last validation cycle");
            return;
        }
        if (this.benchmark) {
            SystemTester.benchmark("Producing raw file: start");
        }
        boolean headerFound = true;
        int numberOfLines = this.dataSetReader.getCounter();
        int numberOfRecords = headerFound ? numberOfLines - 1 : numberOfLines;
        validationRun.setProcessEnd(new Date());
        validationRun.setRecordsIn(numberOfRecords);
        validationRun.setRecordsOut(this.dataSetWriter.getCorrectRecords());
        validationRun.setErrorsNumber(this.rawFilesWriter.getNumberOfErrors());
        validationRun.setWarningsNumber(this.rawFilesWriter.getNumberOfWarnings());
        if (logger.isDebugEnabled()) {
            logger.debug("Prepared ValidationRun DTO");
        }
        if (this.rawFiles) {
            this.validationRunDAO.save(validationRun);
            if (validationRun.getId() != this.getValidationRunID()) {
                String message = "run() - Latest engine's validationRunID (" + this.getValidationRunID() + ") differs from DTO's one (" + validationRun.getId() + ")";
                logger.error(message);
                throw new IllegalStateException(message);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Dateset file's path           : " + this.dataSetReader.getFilePath());
            logger.info("Number of records in dataset  : " + numberOfRecords);
            logger.info("Number of correct records     : " + this.dataSetWriter.getCorrectRecords());
            logger.info("Number of records with issues : " + this.dataSetWriter.getRecordsWithIssues());
            logger.info("Number of errors messages     : " + this.rawFilesWriter.getNumberOfErrors());
            logger.info("Number of warning messages    : " + this.rawFilesWriter.getNumberOfWarnings());
            logger.info("Total number of messagges     : " + this.messageNumber);
            logger.info("Number of lines in dataset    : " + numberOfLines);
            logger.info("Max number of message details : " + this.rawFilesWriter.getMaxNumberOfDetails());
            logger.info("Total validation time         : " + validationRun.getFormattedProcessTime());
            logger.info("");
        }
        if (this.benchmark) {
            SystemTester.benchmark("Closing raw files");
        }
        this.dataSetWriter.commit();
        if (this.rawFiles) {
            this.rawFilesWriter.commit();
        }
        if (this.checkIfStopValidation()) {
            logger.info("Validation process stopped after closing raw files");
            return;
        }
        this.dataSetReader.closeDataConnection();
        boolean produceCSVReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_CSV);
        boolean produceTXTReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_TXT);
        boolean producePDFReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_PDF);
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Producing CSV output report: " + produceCSVReport);
            logger.info("Producing TXT output report: " + produceTXTReport);
            logger.info("Producing PDF output report: " + producePDFReport);
            logger.info("");
        }
        if (this.benchmark) {
            SystemTester.benchmark("Producing OUTPUT reports");
        }
        this.notifyMessageToWorker("\nProducing output reports");
        int reports = 0;
        long linesInCSVReport = 0L;
        long linesInTXTReport = 0L;
        if (this.report) {
            int maxLines;
            boolean hugePDFReport;
            if (produceCSVReport) {
                String message;
                CSVReport csvReport = new CSVReport(this.validationRunID);
                csvReport.setMaxNumberOfDetails(this.rawFilesWriter.getMaxNumberOfDetails());
                try {
                    linesInCSVReport = csvReport.generate();
                    linesInTXTReport = csvReport.getNumberOfLinesInTXTReport();
                    reports += csvReport.getNumberOfReports();
                }
                catch (Exception e) {
                    message = "Failed creation of CSV/TXT reports: " + e.getMessage();
                    logger.error(message);
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    message = "Fatal error when creating CSV/TXT reports: " + t.getMessage();
                    logger.error(message);
                }
            } else if (produceTXTReport) {
                logger.warn("The CSV report is disabled: it's MUST be enabled in order to produce the TXT one!");
                logger.error("Ignoring production of the TXT report");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Produced CSV report with about " + linesInCSVReport + " lines");
            }
            if (logger.isInfoEnabled()) {
                logger.info("Produced TXT report with about " + linesInTXTReport + " lines");
            }
            boolean bl = hugePDFReport = linesInTXTReport > (long)(maxLines = 10000);
            if (producePDFReport) {
                PDFReport pdfReport = new PDFReport(this.validationRunID);
                if (!hugePDFReport) {
                    try {
                        if (pdfReport.generate() > 0L) {
                            ++reports;
                            pdfReport.deleteOldPDF();
                        }
                    }
                    catch (Exception e) {
                        String message = "Failed creation of PDF/TXT reports: " + e.getMessage();
                        logger.error(message);
                        e.printStackTrace();
                    }
                    catch (Throwable t) {
                        String message = "Fatal error when creating PDF/TXT reports: " + t.getMessage();
                        logger.error(message);
                    }
                } else {
                    String feedback = " (" + linesInTXTReport + ")";
                    logger.warn("The PDF report is enabled, but the TXT reports contains too many lines" + feedback);
                    logger.warn("Creation of the PDF report has been skipped since it contains more than " + linesInTXTReport + " lines");
                    this.notifyMessageToWorker("Skipping creation of PDF report (too many lines)");
                    if (pdfReport.renameReportFileToOld()) {
                        this.notifyMessageToWorker("Previous PDF report renamed to *_OLD.pdf");
                    }
                }
            }
        }
        String suffix = reports > 1 ? " reports" : " report";
        String message = "Completed reporting stage: succesfully produced " + reports + suffix;
        this.notifyMessageToWorker(message);
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
        if (this.benchmark || this.profileRules) {
            SystemTester.benchmark("Produced OUTPUT reports");
            SystemTester.endBenchmark();
            SystemTester.logMasterAverage();
            logger.info("End of validation benchmark");
        }
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("End of validationRun: " + String.valueOf(validationRun));
        }
        this.notifyMessageToWorker("Validation process: ended\n");
        StringBuilder shortProcessReport = new StringBuilder();
        shortProcessReport.append("Number of records in dataset : ");
        shortProcessReport.append(numberOfRecords);
        shortProcessReport.append("\n");
        shortProcessReport.append("Number of lines in dataset : ");
        shortProcessReport.append(numberOfLines);
        shortProcessReport.append("\n");
        shortProcessReport.append("Number of correct records : ");
        shortProcessReport.append(this.dataSetWriter.getCorrectRecords());
        shortProcessReport.append("\n");
        shortProcessReport.append("Number of records with issues : ");
        shortProcessReport.append(this.dataSetWriter.getRecordsWithIssues());
        shortProcessReport.append("\n");
        shortProcessReport.append("Number of errors messages : ");
        shortProcessReport.append(this.rawFilesWriter.getNumberOfErrors());
        shortProcessReport.append("\n");
        shortProcessReport.append("Number of warning messages : ");
        shortProcessReport.append(this.rawFilesWriter.getNumberOfWarnings());
        shortProcessReport.append("\n");
        shortProcessReport.append("Total number of messagges : ");
        shortProcessReport.append(this.messageNumber);
        shortProcessReport.append("\n");
        shortProcessReport.append("Validation time: ");
        shortProcessReport.append(validationRun.getFormattedProcessTime());
        shortProcessReport.append("\n");
        this.notifyMessageToWorker(shortProcessReport.toString());
    }

    protected List<RuleOutput> selectRuleByScope(AbstractRule rule) {
        RuleScope ruleScope = rule.getRuleConfiguration().getRuleScope();
        switch (ruleScope) {
            case FILE_METADATA: 
            case FILE_FORMAT: 
            case ALL_RECORDS: {
                this.printCurrentRule("FILE_SCOPE rule");
                return this.applyDataConnectionRule(rule);
            }
            case HEADER: {
                this.printCurrentRule("HEADER_SCOPE rule");
                return this.applyHeaderRule(rule);
            }
            case RECORD: {
                return RuleOutput.NOT_APPLICABLE;
            }
        }
        this.addSkippedRule(rule);
        String message = "Rule's scope has not been identified: skipping rule";
        logger.error(message);
        return RuleOutput.VALID;
    }

    public void notifyMessageToWorker(String message) {
        if (logger.isInfoEnabled()) {
            logger.info("notifyMessageToWorker() - " + message);
        }
        if (this.validationWorker != null) {
            this.validationWorker.sendMessage(message);
        } else if (!this.noGUIAlreadyNotified) {
            this.noGUIAlreadyNotified = true;
            logger.warn("notifyMessageToWorker() - NULL validation worker (if no GUI -> ok)");
        }
    }

    protected void notifyProgressToWorker(int progress) {
        if (this.validationWorker != null) {
            this.validationWorker.updateProgress(progress);
        }
    }

    protected boolean checkIfStopValidation() {
        boolean stop = this.isStopValidation();
        boolean notified = this.isStopAlreadyNotified();
        if (stop && !notified) {
            if (logger.isWarnEnabled()) {
                logger.warn("checkIfStopValidation() - Handling interruption of validation process");
            }
            this.validationWorker.setMessageLayout(MessageLayout.RED);
            this.notifyMessageToWorker("Validation process interrupted by the user");
            this.setStopAlreadyNotified(true);
        }
        return stop;
    }

    protected List<RuleOutput> applyDataConnectionRule(AbstractRule rule) {
        DataConnection connection = this.dataSetReader.getDataConnection();
        rule.setRuleInput(connection);
        rule.reset();
        if (logger.isDebugEnabled()) {
            logger.debug("applyDataConnectionRule - Rule: " + rule.toShortString());
        }
        if (rule instanceof GenericCrossRecordRule) {
            GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)rule;
            crossRecordRule.resetMatchedRecords();
        }
        List<RuleOutput> output = null;
        try {
            output = rule.check();
        }
        catch (RuleRuntimeException e) {
            logger.error("applyDataConnectionRule() - Failed rule " + rule.toShortString() + ": " + e.getMessage());
            e.printStackTrace();
            return RuleOutput.INVALID;
        }
        if (rule instanceof PrimaryDuplicatesSoftRule2) {
            for (RuleOutput ruleOutput : output) {
                boolean print = false;
                if (!print) continue;
                logger.info("applyDataConnectionRule() - PrimaryDuplicatesSoftRule2_ouput:");
                List<RuleOutputDetail> details = ruleOutput.getAllRuleOutputDetail();
                for (RuleOutputDetail ruleOutputDetail : details) {
                    logger.info(ruleOutputDetail.toString());
                }
            }
        }
        this.addRunInformation(output);
        connection.closeConnection();
        return output;
    }

    protected List<RuleOutput> applyHeaderRule(AbstractRule rule) {
        DataRecord header = this.dataSetReader.getHeader();
        rule.setRuleInput(header);
        List<RuleOutput> output = rule.check();
        this.addRunInformation(output);
        return output;
    }

    protected void applyStripQuotesCriterion(int stripCriterion, DataRecord record) {
        if (logger.isDebugEnabled()) {
            logger.debug("applyStripQuotesCriterion() - Checking record: " + String.valueOf(record));
        }
        if (stripCriterion == 0) {
            return;
        }
        if (stripCriterion != 1) {
            logger.error("applyStripQuotesCriterion() - Wrong strip criterion: " + stripCriterion);
            return;
        }
        String[] array = record.serialize();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].contains("\"")) continue;
            array[i] = array[i].replace("\"", "");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyStripQuotesCriterion() - Cleaned record: " + String.valueOf(record));
        }
    }

    protected void addRunInformation(List<RuleOutput> list) {
        for (RuleOutput ruleOutput : list) {
            ++this.messageNumber;
            ruleOutput.setMessageNumber(this.getMessageNumber());
            if (ruleOutput.getLineNumber() == 0) {
                ruleOutput.setLineNumber(this.lineNumber);
            }
            ruleOutput.setValidationRunID(this.getValidationRunID());
            if (!logger.isTraceEnabled()) continue;
            logger.trace("addRunInformation() - RuleOutput: " + String.valueOf(ruleOutput));
        }
    }

    protected boolean isCorrectRecord(List<RuleOutput> list) {
        if (list == null) {
            return false;
        }
        return list == RuleOutput.VALID;
    }

    protected void setInvalidLineNumber(List<RuleOutput> list) {
        if (list == null) {
            return;
        }
        for (RuleOutput ruleOutput : list) {
            int lineNumber = ruleOutput.getLineNumber();
            if (logger.isDebugEnabled()) {
                logger.debug("setInvalidLineNumber() - Line number: " + lineNumber);
            }
            this.setInvalidLineNumber(lineNumber);
        }
    }

    protected void setInvalidLineNumber(int number) {
        this.invalidLineNumbers.add(number);
    }

    protected boolean isInvalidLineNumber(int number) {
        return this.invalidLineNumbers.contains(number);
    }

    protected void checkPrerequsites() {
        boolean verbose = true;
        int maxLevel = this.protocolView.getMaxLevel();
        Map<ValidationLevel, List<RuleDefinition>> rulesByLevel = this.protocolView.getRulesByLevel();
        if (verbose) {
            logger.info("Checking prerequisites - Max level = " + maxLevel);
            logger.info("");
            for (Map.Entry<ValidationLevel, List<RuleDefinition>> entry : rulesByLevel.entrySet()) {
                String message = String.valueOf((Object)entry.getKey()) + " -> ";
                for (RuleDefinition rule : entry.getValue()) {
                    message = message + rule.getName() + ", ";
                }
                logger.info(message);
            }
            logger.info("");
        }
        for (int level = maxLevel; level > 0; --level) {
            ValidationLevel validationLevel = ValidationLevel.getValidationLevel(level);
            List<RuleDefinition> rules = rulesByLevel.get((Object)validationLevel);
            if (rules == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Null rules list for level: " + level);
                continue;
            }
            for (RuleDefinition rule : rules) {
                if (!verbose) continue;
                logger.info(level + " -> " + rule.getName());
            }
        }
        if (verbose) {
            logger.info("");
        }
    }

    public boolean sortDataSet(GenericCrossRecordRule crossRecordRule) {
        WhereCondition whereCondition = crossRecordRule.getWhereCondition();
        return this.sortDataSet(whereCondition);
    }

    public boolean sortDataSet(WhereCondition whereCondition) {
        if (logger.isTraceEnabled()) {
            logger.trace("sortDataSet(WhereCondition) - WhereCondition  : " + String.valueOf(whereCondition));
        }
        String originalFile = this.dataSetReader.getFilePath();
        if (logger.isDebugEnabled()) {
            logger.debug("sortDataSet(WhereCondition) - Sorting file    : " + originalFile);
        }
        String workingPath = "./temp/";
        String columnToOrder = whereCondition.getFirstColumn();
        ExternalSorter sorter = new ExternalSorter(workingPath);
        if (logger.isDebugEnabled()) {
            logger.debug("sortDataSet(WhereCondition) - Sorting field   : " + columnToOrder);
        }
        long startTime = System.currentTimeMillis();
        String orderedFileName = sorter.sortFile(originalFile, columnToOrder);
        long endTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info("sortDataSet(WhereCondition) - Produced file   : " + orderedFileName + " in " + (endTime - startTime) + " ms");
        }
        if (orderedFileName == null) {
            String message = "Failed producing the name of the sorted file: does the " + columnToOrder + " column exist in the input dataset?";
            logger.error("sortDataSet(WhereCondition) - " + message);
            orderedFileName = this.guessSortedFileName(originalFile, workingPath, columnToOrder);
            logger.warn("sortDataSet(WhereCondition) - Forced sorted file's name to: " + orderedFileName);
            this.notifyMessageToWorker(message);
        }
        whereCondition.setFullFileName(orderedFileName);
        if (logger.isTraceEnabled()) {
            logger.trace("sortDataSet(WhereCondition) - setFullFileName  : " + whereCondition.getFullFileName());
        }
        return orderedFileName != null;
    }

    protected String guessSortedFileName(String originalFile, String workingPath, String columnToOrder) {
        String sortedFileName = null;
        String basePath = workingPath + "sorted/";
        String filePrefix = "-by-" + columnToOrder;
        String fileSuffix = ".csv";
        if (originalFile.contains("/")) {
            String[] pathItem = originalFile.split("/");
            String dataSetFileName = pathItem[pathItem.length - 1];
            if (dataSetFileName.contains(".")) {
                Object[] tokens = dataSetFileName.split("\\.");
                sortedFileName = basePath + tokens[0] + filePrefix + fileSuffix;
                logger.info("getSortedFileName() - CASE 1   : " + Arrays.toString(tokens));
            } else {
                sortedFileName = basePath + originalFile + filePrefix + fileSuffix;
            }
        }
        return sortedFileName;
    }

    public void setProtocolView(int protocolID) {
        int parentID;
        ProtocolView protocolView = null;
        if (protocolID > 0) {
            protocolView = this.protocolViewDAO.getOrderedByPriority(protocolID);
        }
        if (protocolView == null) {
            protocolView = this.protocolViewDAO.getDefaultProtocolView();
            if (logger.isWarnEnabled()) {
                logger.warn("setProtocol(): Failed fetching protocol from DAO layer -> using default protocol:" + protocolView.getId());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("setProtocol(): ProtocolView fetched from DAO layer: " + String.valueOf(protocolView));
        }
        if ((parentID = protocolView.getProtocol().getParentID()) > 0) {
            if (logger.isInfoEnabled()) {
                logger.info("setProtocol(): Parent protocolID: " + parentID);
            }
            protocolView = this.protocolViewDAO.getFullProtocolViewByID(protocolID);
            if (logger.isInfoEnabled()) {
                logger.info("setProtocol(): Full ProtocolView: " + String.valueOf(protocolView));
            }
        }
        this.setProtocolView(protocolView);
    }

    public void setProtocolView(ProtocolView protocolView) {
        int newProtocolID;
        int oldProtocolID = this.protocolView != null ? this.protocolView.getId() : 0;
        this.protocolView = protocolView;
        int n = newProtocolID = this.protocolView != null ? this.protocolView.getId() : 0;
        if (oldProtocolID != newProtocolID) {
            if (logger.isInfoEnabled()) {
                logger.info("setProtocolView () - Changed protocolID: " + oldProtocolID + " -> " + newProtocolID + " : resetting engine");
            }
            this.hardReset();
        }
    }

    public int getProtocolID() {
        if (this.protocolView != null) {
            return this.protocolView.getId();
        }
        return -1;
    }

    public int getProtocolID(Protocol protocol) {
        int protocolID = 0;
        if (protocol == null) {
            if (this.protocolView != null) {
                protocolID = this.protocolView.getId();
                if (logger.isInfoEnabled()) {
                    logger.info("selectProtocolID() - Using default protocol: protocolID = " + protocolID);
                }
            } else {
                logger.error("selectProtocolID() - No default protocol: exiting!");
            }
        } else {
            protocolID = protocol.getId();
            if (logger.isInfoEnabled()) {
                logger.info("selectProtocolID() - Using user's protocol: protocolID = " + protocolID);
            }
        }
        return protocolID;
    }

    protected void addSkippedRule(RuleDefinition rule) {
        if (this.skippedRules == null) {
            this.skippedRules = new ArrayList<RuleDefinition>();
        }
        this.skippedRules.add(rule);
    }

    protected void addSkippedRule(AbstractRule rule) {
        if (!(rule instanceof GenericRule)) {
            String message = "Impossible to fetch DTO from rule: " + rule.getName();
            logger.error(message);
            throw new InvalidProtocolException(message);
        }
        GenericRule genericRule = (GenericRule)rule;
        RuleDefinition ruleDefinition = genericRule.getRuleDefinition();
        this.addSkippedRule(ruleDefinition);
    }

    public AbstractRule getValidRuleByID(int ruleID) {
        if (this.validRules == null) {
            return null;
        }
        if (this.validRules.size() > 0) {
            for (AbstractRule rule : this.validRules) {
                if (rule.getId() != ruleID) continue;
                return rule;
            }
        }
        return null;
    }

    public boolean hasValidRules() {
        if (this.validRules == null) {
            return false;
        }
        return this.validRules.size() != 0;
    }

    public boolean hasPostRecordCycle() {
        return this.firstPostRecordIndexRule > 0;
    }

    public void resetAllStopSignals() {
        this.setStopValidation(false);
        this.setStopAlreadyNotified(false);
    }

    public ProtocolView getProtocolView() {
        return this.protocolView;
    }

    public RulesFactory getRulesFactory() {
        return this.rulesFactory;
    }

    public List<AbstractRule> getAllRules() {
        return this.validRules;
    }

    public List<Integer> getFunctionRuleIDs() {
        return this.functionRuleIDs;
    }

    public List<RuleDefinition> getSkippedRules() {
        return this.skippedRules;
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public int getCurrentRuleIndex() {
        return this.currentRuleIndex;
    }

    public int getValidationRunID() {
        return this.validationRunID;
    }

    public void setValidationRunID(int validationRunID) {
        this.validationRunID = validationRunID;
    }

    public DataSetReader getDataSetReader() {
        return this.dataSetReader;
    }

    public void setDataSetReader(DataSetReader dataSetReader) {
        this.dataSetReader = dataSetReader;
    }

    public DataSetWriter getDataSetWriter() {
        return this.dataSetWriter;
    }

    public void setDataSetWriter(DataSetWriter dataSetWriter) {
        this.dataSetWriter = dataSetWriter;
    }

    public int getMaxRules() {
        return this.maxRules;
    }

    public void setMaxRules(int maxRules) {
        this.maxRules = maxRules;
    }

    public GeneralWorker getValidationWorker() {
        return this.validationWorker;
    }

    public void setValidationWorker(GeneralWorker validationWorker) {
        this.validationWorker = validationWorker;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public RawFilesWriter getRawFilesWriter() {
        return this.rawFilesWriter;
    }

    public boolean isRawFiles() {
        return this.rawFiles;
    }

    public void setRawFiles(boolean rawFiles) {
        this.rawFiles = rawFiles;
    }

    public boolean isReport() {
        return this.report;
    }

    public void setReport(boolean report) {
        this.report = report;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    public boolean isProfileRules() {
        return this.profileRules;
    }

    public void setProfileRules(boolean profileRules) {
        this.profileRules = profileRules;
    }

    public int getFirstPostRecordIndexRule() {
        return this.firstPostRecordIndexRule;
    }

    public void setFirstPostRecordIndexRule(int firstPostRecordIndexRule) {
        this.firstPostRecordIndexRule = firstPostRecordIndexRule;
    }

    public List<AbstractRule> getValidRules() {
        return this.validRules;
    }

    public List<WhereCondition> getWhereConditions() {
        return this.whereConditions;
    }

    public Map<AbstractRule, WhereCondition> getWhereConditionsByRule() {
        return this.whereConditionsByRule;
    }

    public boolean isSaveReferenceData() {
        return this.saveReferenceData;
    }

    public List<ReferenceField> getReferenceFields() {
        return this.referenceFields;
    }

    public boolean isStopValidation() {
        return this.stopValidation;
    }

    public void setStopValidation(boolean stopValidation) {
        this.stopValidation = stopValidation;
    }

    public boolean isStopAlreadyNotified() {
        return this.stopAlreadyNotified;
    }

    public void setStopAlreadyNotified(boolean stopAlreadyNotified) {
        this.stopAlreadyNotified = stopAlreadyNotified;
    }

    public boolean isNoGUIAlreadyNotified() {
        return this.noGUIAlreadyNotified;
    }

    public void setNoGUIAlreadyNotified(boolean noGUIAlreadyNotified) {
        this.noGUIAlreadyNotified = noGUIAlreadyNotified;
    }

    protected void benchmarkRecord(String prefix, DataRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append("LINE=");
        builder.append(this.lineNumber);
        builder.append(", ID=");
        builder.append(record.getValue(0));
        builder.append("-");
        builder.append(record.getValue(1));
        SystemTester.benchmark(prefix, builder.toString());
    }

    protected void benchmarkRule(String prefix, AbstractRule rule) {
        StringBuilder ruleIdentifier = new StringBuilder();
        StringBuilder recordIdentifier = new StringBuilder();
        ruleIdentifier.append(prefix);
        ruleIdentifier.append("_");
        ruleIdentifier.append(rule.getId());
        ruleIdentifier.append(": ");
        ruleIdentifier.append(rule.getName());
        recordIdentifier.append(" (line=");
        recordIdentifier.append(this.lineNumber);
        recordIdentifier.append(")");
        SystemTester.benchmark(ruleIdentifier.toString(), recordIdentifier.toString());
    }

    public String analyzeProtocol() {
        if (this.protocolView == null) {
            String message = "Wrong engine configuration: missing target protocol";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (logger.isInfoEnabled()) {
            logger.info("analyzeProtocol() - Resetting engine");
        }
        this.hardReset();
        this.loadAllRules();
        int counter = 1;
        Object header = null;
        StringBuilder protocolInfo = new StringBuilder("\n");
        header = "List of VALID rules in protocol (" + this.getRuleLabel(this.validRules.size()) + ")";
        String validHeader = this.formatSectionHeader((String)header);
        Object validRules = this.getFormattedRules(this.validRules, true);
        if (this.functionRuleIDs.size() > 0) {
            validRules = (String)validRules + "\n(*) Function rule\n";
        }
        this.appendProtocolSection(protocolInfo, validHeader, (String)validRules);
        header = "List of VALID FUNCTION rules in protocol (" + this.getRuleLabel(this.functionRuleIDs.size()) + ")";
        String functionHeader = this.formatSectionHeader((String)header);
        String functionRules = this.getFormattedRulesByID(this.functionRuleIDs);
        this.appendProtocolSection(protocolInfo, functionHeader, functionRules);
        counter = 1;
        header = "List of cross-records rules using a WHERE CONDITION (" + this.getRuleLabel(this.whereConditionsByRule.size()) + ")";
        String usingFunctionHeader = this.formatSectionHeader((String)header);
        StringBuilder usingFunctionRules = new StringBuilder();
        for (Map.Entry<AbstractRule, WhereCondition> entry : this.whereConditionsByRule.entrySet()) {
            if (counter == 1) {
                usingFunctionRules.append("NR.  ");
                usingFunctionRules.append(entry.getKey().getFormattedHeader());
                usingFunctionRules.append("\n\n");
            }
            usingFunctionRules.append(counter++);
            usingFunctionRules.append(" -> ");
            usingFunctionRules.append(entry.getKey());
            usingFunctionRules.append(" [");
            usingFunctionRules.append(entry.getValue());
            usingFunctionRules.append("]\n");
        }
        if (counter == 1) {
            usingFunctionRules.append("None\n");
        }
        this.appendProtocolSection(protocolInfo, usingFunctionHeader, usingFunctionRules.toString());
        counter = 1;
        header = "List of unique WHERE CONDITION in protocol (" + this.whereConditions.size() + ")";
        String whereConditionsHeader = this.formatSectionHeader((String)header);
        StringBuilder whereConditionsRules = new StringBuilder();
        for (WhereCondition whereCondition : this.whereConditions) {
            String message = "Where condition " + whereCondition.toString();
            whereConditionsRules.append(counter++);
            whereConditionsRules.append(") ");
            whereConditionsRules.append(message);
            whereConditionsRules.append("\n");
        }
        if (counter == 1) {
            whereConditionsRules.append("None\n");
        }
        this.appendProtocolSection(protocolInfo, whereConditionsHeader, whereConditionsRules.toString());
        counter = 1;
        header = "List of INVALID rules in protocol (" + this.getRuleLabel(this.skippedRules.size()) + ")";
        String invalidHeader = this.formatSectionHeader((String)header);
        StringBuilder invalidRules = new StringBuilder();
        for (RuleDefinition skipped : this.skippedRules) {
            String message = skipped.toString() + ": " + skipped.getFirstErrorMessage();
            invalidRules.append(counter++);
            invalidRules.append(") ");
            invalidRules.append(message);
            invalidRules.append("\n");
        }
        if (counter == 1) {
            invalidRules.append("None\n");
        }
        this.appendProtocolSection(protocolInfo, invalidHeader, invalidRules.toString());
        counter = 1;
        header = "List of rules using a DEFAULT TARGET";
        String notConfigureddHeader = this.formatSectionHeader((String)header);
        StringBuilder notConfiguredRules = new StringBuilder();
        for (AbstractRule rule : this.validRules) {
            RuleConfiguration ruleConfiguration = rule.getRuleConfiguration();
            if (!ruleConfiguration.isDefaultTarget()) continue;
            String prefix = counter < 10 ? " " + counter++ : "" + counter++;
            notConfiguredRules.append(prefix);
            notConfiguredRules.append(") ");
            notConfiguredRules.append(rule.toString());
            invalidRules.append("\n");
        }
        if (counter == 1) {
            notConfiguredRules.append("None\n");
        }
        this.appendProtocolSection(protocolInfo, notConfigureddHeader, notConfiguredRules.toString());
        counter = 1;
        header = "List of VALID rules using a CUSTOM TARGET";
        String configureddHeader = this.formatSectionHeader((String)header);
        StringBuilder configuredRules = new StringBuilder();
        for (AbstractRule rule : this.validRules) {
            RuleConfiguration ruleConfiguration = rule.getRuleConfiguration();
            if (RuleTarget.SOME_FIELDS != ruleConfiguration.getRuleTarget() || ruleConfiguration.compareRuleParameters()) continue;
            List<RuleParameter> defaultRuleParameters = ruleConfiguration.getDefaultRuleParameters();
            String prefix = counter < 10 ? " " + counter++ : "" + counter++;
            configuredRules.append(prefix);
            configuredRules.append(") ");
            configuredRules.append(rule.toFixedString(false));
            configuredRules.append("\n");
            StringBuilder builder = new StringBuilder();
            Formatter formatter = new Formatter(builder, Locale.ENGLISH);
            String className = "    " + rule.getClass().getSimpleName();
            String defaultParams = RuleParameter.getFormattedRuleParameters(defaultRuleParameters);
            formatter.format("%-125s %-21s %-150s", className, "DEFAULT_FIELDS", defaultParams);
            formatter.close();
            configuredRules.append(builder.toString());
            configuredRules.append("\n");
        }
        if (counter == 1) {
            configuredRules.append("None\n");
        }
        this.appendProtocolSection(protocolInfo, configureddHeader, configuredRules.toString());
        logger.info(protocolInfo.toString());
        return protocolInfo.toString();
    }

    public String getRulesByFieldID(int fieldID, int protocolID) {
        if (this.protocolView == null) {
            String message = "Wrong engine configuration: missing target protocol";
            logger.error("getRulesByFieldID() " + message);
            throw new IllegalStateException(message);
        }
        if (logger.isInfoEnabled()) {
            logger.info("getRulesByFieldID() - Resetting engine");
        }
        this.hardReset();
        this.loadAllRules();
        Field field = null;
        String sep = "";
        StringBuilder formattedResult = new StringBuilder("\n");
        for (AbstractRule rule : this.validRules) {
            RuleConfiguration configuration = rule.getRuleConfiguration();
            if (field == null) {
                field = configuration.getFieldById(fieldID);
            }
            if (!configuration.addressFieldId(fieldID)) continue;
            formattedResult.append(sep);
            formattedResult.append(rule);
            sep = "\n";
        }
        logger.info("List of rules addressing field: " + field.toShortString() + " for protocol " + protocolID);
        logger.info(formattedResult.toString());
        return formattedResult.toString();
    }

    protected StringBuilder appendProtocolSection(StringBuilder builder, String header, String section) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        builder.append(header);
        builder.append("\n");
        builder.append(section);
        return builder;
    }

    protected String formatSectionHeader(String name) {
        StringBuilder builder = new StringBuilder("\n");
        builder.append(name);
        builder.append("\n------------------------------------------\n");
        return builder.toString();
    }

    protected String getRuleLabel(int amount) {
        String suffix = amount == 1 ? " rule" : " rules";
        return amount + suffix;
    }

    protected String getFormattedRulesByID(List<Integer> ruleIDs) {
        if (ruleIDs == null || ruleIDs.size() == 0) {
            return "none";
        }
        ArrayList<AbstractRule> list = new ArrayList<AbstractRule>();
        for (int ruleID : ruleIDs) {
            AbstractRule rule = this.getValidRuleByID(ruleID);
            list.add(rule);
        }
        return this.getFormattedRules(list, false);
    }

    protected String getFormattedRules(List<AbstractRule> rules, boolean separate) {
        StringBuilder builder = new StringBuilder();
        builder.append("NICE ");
        builder.append(rules.get(0).getFormattedHeader());
        builder.append("\n\n");
        int cycle = ValidationCycle.PRE_RECORD.id;
        for (AbstractRule rule : rules) {
            RuleConfiguration cfg = rule.getRuleConfiguration();
            if (separate) {
                ValidationLevel validationLevel = cfg.getValidationLevel();
                if (validationLevel.cycle.id > cycle) {
                    builder.append("\n");
                    cycle = validationLevel.cycle.id;
                }
            }
            builder.append(cfg.getPriority());
            builder.append(" -> ");
            builder.append(rule.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    protected void printCurrentRule(String message) {
        if (this.logRules && logger.isInfoEnabled()) {
            int position = this.currentRuleIndex + 1;
            AbstractRule rule = this.validRules.get(this.currentRuleIndex);
            String suffix = rule.getClass().getSimpleName();
            logger.info("");
            logger.info("<<" + position + ">> " + message + ": " + suffix);
        }
    }

    public void printRuleResults(String label, List<RuleOutput> output) {
        boolean details = false;
        if (output != null && output.size() > 0) {
            logger.info("");
            logger.info(label + " -> list of RuleOutput");
            for (RuleOutput ruleOutput : output) {
                logger.info("");
                logger.info("\tRULE_OUTPUT         : " + ruleOutput.getCSVRepresentation());
                List<RuleOutputDetail> outputDetailsList = ruleOutput.getAllRuleOutputDetail();
                if (!details || outputDetailsList == null || outputDetailsList.size() <= 0) continue;
                logger.info("\tRULE_OUTPUT_DETAILS :");
                for (RuleOutputDetail outputDetail : outputDetailsList) {
                    logger.info("\t\t" + outputDetail.getCSVRepresentation());
                }
            }
        }
    }

    protected void pauseThread(int milliseconds) {
        if (logger.isInfoEnabled()) {
            logger.info("pauseThread() - Stopping for " + milliseconds + " milliseconds");
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            logger.info("pauseThread() - Paused thread: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.info("pauseThread() - Exception when pausing thread: " + e.getMessage());
            e.printStackTrace();
        }
        if (logger.isInfoEnabled()) {
            logger.info("pauseThread() - Restarting current thread");
        }
    }
}

