/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine;

import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesFactory {
    protected boolean verbose;
    protected static Logger logger = LoggerFactory.getLogger(RulesFactory.class);

    public AbstractRule getRuleImplementation(RuleDefinition ruleDefinition) {
        String rulePackage = ruleDefinition.getLocation();
        String ruleName = ruleDefinition.getImplementation();
        if (ruleName == null || rulePackage == null) {
            return null;
        }
        String ruleClassName = rulePackage + "." + ruleName;
        if (this.verbose) {
            this.logHorizontalLine();
            logger.info("CREATING DYNAMIC RULE ");
            logger.info("");
            logger.info("ClassName                              : " + ruleClassName);
        }
        AbstractRule rule = null;
        Object ruleObj = this.getRuleObject(ruleClassName, ruleDefinition);
        if (ruleObj instanceof AbstractRule) {
            rule = (AbstractRule)ruleObj;
            if (this.verbose) {
                logger.info("Concrete object                        : " + String.valueOf(rule));
            }
        }
        return rule;
    }

    public Object getRuleObject(String className, RuleDefinition ruleDefinition) {
        Class<?> type = null;
        try {
            type = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error("getRuleObject() - Class not found: " + e.getMessage());
            return null;
        }
        if (this.verbose) {
            logger.info("Class's type                           : " + String.valueOf(type));
        }
        Constructor<?> constructor = null;
        if (this.verbose) {
            logger.debug("Constructor's argument (the RuleDefinition) : " + String.valueOf(ruleDefinition));
        }
        try {
            Class[] signature = new Class[]{RuleDefinition.class};
            constructor = type.getConstructor(signature);
            if (this.verbose) {
                logger.info("Constructor                            : " + String.valueOf(constructor));
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error("NoSuchMethodException | SecurityException: " + e.getMessage());
            return null;
        }
        try {
            return constructor.newInstance(ruleDefinition);
        }
        catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Unknown error: " + e.getMessage());
            return null;
        }
        catch (InvocationTargetException e) {
            throw new InvalidRuleException(e.getCause());
        }
    }

    public void setRuleConfiguration(AbstractRule rule, ProtocolToRule protocolToRule) {
        if (rule == null || protocolToRule == null) {
            Object message = rule == null ? "Cannot set rule configuration to a null AbstractRule" : "Found null ProtocolToRule for rule: " + rule.toShortString();
            logger.warn((String)message);
            return;
        }
        if (!(rule instanceof GenericRule)) {
            String message = "AbstractRule sub-class not supported: " + String.valueOf(rule.getClass());
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
        GenericRule genericRule = (GenericRule)rule;
        genericRule.setProtocolToRule(protocolToRule);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void logHorizontalLine() {
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("---------------------------------------------------------------------------------------");
        }
    }
}

