/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDetailDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.DynamicFileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.BufferedFileHandler;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerTXT;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.report.handlers.ReferenceDataReader;
import eu.europa.ec.jrc.qcs.report.handlers.ReferenceDataReaderCached;
import eu.europa.ec.jrc.qcs.report.handlers.ReferenceDataReaderRaw;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFilesReader {
    protected ReferenceDataReader referenceDataReader;
    protected int validationRunID;
    protected boolean readFromFile;
    protected boolean readFromDAO;
    protected boolean benchmark;
    protected int counter;
    protected FileHandlerCSV<RuleOutput> ruleOutputHandler;
    protected FileHandlerCSV<RuleOutputDetail> ruleOutputDetailHandler;
    protected RuleOutputDetail lastRuleOutputDetail;
    protected RuleOutputDAO ruleOutputDAO;
    protected RuleOutputDetailDAO ruleOutputDetailDAO;
    protected static Logger logger = LoggerFactory.getLogger(RawFilesReader.class);

    public RawFilesReader(int validationRunID) {
        this.validationRunID = validationRunID;
        this.benchmark = false;
        boolean saveReferenceData = Configuration.getInstance().getBooleanProperty(Property.REFERENCE_DATA);
        if (logger.isInfoEnabled()) {
            String message = saveReferenceData ? "raw files (not cached)" : "output dataset (cached)";
            logger.info("Constructor() - Fetching reference data from: " + message);
        }
        this.referenceDataReader = saveReferenceData ? new ReferenceDataReaderRaw(validationRunID) : new ReferenceDataReaderCached(validationRunID);
    }

    public void init() {
        boolean firstInit;
        this.counter = 0;
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Initializing for validation run ID: " + this.validationRunID);
        }
        if (this.readFromDAO && this.readFromFile) {
            String message = "init() - Raw files can be read only from one singe source";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (this.readFromFile) {
            FileConnection ruleOutputConnection = FlatFileDAOFactory.getConnection(DAO.RULE_OUTPUT);
            DynamicFileConnection dynamicConnection = (DynamicFileConnection)ruleOutputConnection;
            this.ruleOutputHandler = new FileHandlerCSV<RuleOutput>(dynamicConnection, RuleOutput.class, true);
            this.ruleOutputHandler.setHeader(true);
            FileConnection ruleOutputDetailConnection = FlatFileDAOFactory.getConnection(DAO.RULE_OUTPUT_DETAIL);
            DynamicFileConnection dynamicConnectionDetail = (DynamicFileConnection)ruleOutputDetailConnection;
            this.ruleOutputDetailHandler = new FileHandlerCSV<RuleOutputDetail>(dynamicConnectionDetail, RuleOutputDetail.class, true);
            this.ruleOutputDetailHandler.setHeader(true);
            this.lastRuleOutputDetail = null;
            if (logger.isInfoEnabled()) {
                logger.info("init() - Accessing \"raw files\" through file handlers");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("init() - Opened file handler to RULE_OUTPUT        : " + String.valueOf(ruleOutputConnection));
                logger.debug("init() - Opened file handler to RULE_OUTPUT_DETAIL : " + String.valueOf(ruleOutputConnection));
            }
        } else {
            DAOFactory daoFactory = DAOFactory.getDAOFactory();
            this.ruleOutputDAO = (RuleOutputDAO)((Object)daoFactory.getDAO(DAO.RULE_OUTPUT));
            this.ruleOutputDetailDAO = (RuleOutputDetailDAO)((Object)daoFactory.getDAO(DAO.RULE_OUTPUT_DETAIL));
            this.ruleOutputDAO.resetAll();
            this.ruleOutputDetailDAO.resetAll();
            if (logger.isInfoEnabled()) {
                logger.info("init() - Accessing \"raw files\" through DAO LAYER");
                if (logger.isDebugEnabled()) {
                    logger.debug("init() - Created RuleOutputDAO       : " + String.valueOf(this.ruleOutputDAO));
                    logger.debug("init() - Created ruleOutputDetailDAO : " + String.valueOf(this.ruleOutputDetailDAO));
                }
            }
        }
        if (!this.referenceDataReader.validate()) {
            if (this.referenceDataReader.initReader()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("init() - Initialised new ReferenceDataReader: " + String.valueOf(this.referenceDataReader));
                }
            } else {
                logger.error("init() - Failed to initialise caption reader for validation run: " + this.validationRunID);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("init() - Valided existing ReferenceDataReader: " + String.valueOf(this.referenceDataReader));
        }
        if (this.benchmark && !(firstInit = SystemTester.initBenchmark())) {
            SystemTester.benchmark("start.raw.files");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Completed initialization");
        }
    }

    public RuleOutput getNextRuleOutput() throws EOFException {
        RuleOutput ruleOutput = null;
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("------------------------------------------------------------------------------------");
            logger.info("getNextRuleOutput() - Fetching RuleOutput for validaton run: " + this.validationRunID);
            logger.info("getNextRuleOutput() - Checking connection data for rule_output_line: " + this.counter);
            this.logConnectionData();
        }
        if (this.readFromFile) {
            if (debug) {
                logger.info("getNextRuleOutput() - READ_FROM_FILE - Checking connection data:");
                this.logConnectionData();
            }
            try {
                ruleOutput = (RuleOutput)this.ruleOutputHandler.readNextLine(this.validationRunID);
            }
            catch (InterruptedIOException e) {
                String message = "I/O error while reading RULE_OUTPUT file: " + e.getMessage();
                logger.error("getNextRuleOutput() - " + message);
                throw new EOFException(message);
            }
            catch (EOFException e) {
                throw e;
            }
            catch (Exception e) {
                String message = "Generic error while reading RULE_OUTPUT file: " + e.getMessage();
                logger.error("getNextRuleOutput() - " + message);
                throw new EOFException(message);
            }
        } else {
            if (debug) {
                logger.info("getNextRuleOutput() - READ_FROM_DAO - Checking connection data:");
                this.logConnectionData();
            }
            ruleOutput = this.ruleOutputDAO.getNextByValidationRunID(this.validationRunID);
            if (debug) {
                logger.info("getNextRuleOutput() - Fetched RuleOutput from DAO:" + String.valueOf(ruleOutput));
            }
        }
        if (ruleOutput == null) {
            String message = "Found null row while reading RULE_OUTPUT file: ";
            logger.error("getNextRuleOutput() - " + message);
            throw new EOFException(message);
        }
        if (debug) {
            logger.info("getNextRuleOutput() - Read RuleOutput:" + String.valueOf(ruleOutput));
        }
        return ruleOutput;
    }

    public List<RuleOutputDetail> getNextRuleOutputDetails(RuleOutput ruleOutput) {
        RuleOutputDetail ruleOutputDetail;
        int ruleOutputID;
        if (ruleOutput == null) {
            String message = "getNextRuleOutputDetails() - Found null input argument: RuleOutput";
            logger.error(message);
            return null;
        }
        ArrayList<RuleOutputDetail> ruleOutputDetails = new ArrayList<RuleOutputDetail>();
        int masterID = ruleOutput.getId();
        if (logger.isTraceEnabled()) {
            logger.trace("getNextRuleOutputDetails() - Master RuleOutputID: " + masterID);
        }
        if (this.lastRuleOutputDetail != null) {
            ruleOutputID = this.lastRuleOutputDetail.getRuleOutputID();
            if (ruleOutputID == masterID) {
                ruleOutputDetails.add(this.lastRuleOutputDetail);
                this.lastRuleOutputDetail = null;
            } else {
                if (ruleOutputID > masterID) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("getNextRuleOutputDetails() - Previous RuleOutput had not details: " + masterID);
                    }
                    return RuleOutputDetail.EMPTY_LIST;
                }
                logger.error("getNextRuleOutputDetails() - Wrong relationship: masterID = " + masterID + " vs ruleOutputID = " + ruleOutputID);
            }
        }
        while (true) {
            try {
                ruleOutputDetail = this.getNextRuleOutputDetail();
            }
            catch (EOFException e) {
                if (logger.isInfoEnabled()) {
                    logger.info("getNextRuleOutputDetails() - Reached EOF for RULE_OUTPUT_DETAIL datasource");
                }
                return ruleOutputDetails;
            }
            ruleOutputID = ruleOutputDetail.getRuleOutputID();
            if (ruleOutputID != masterID) break;
            ruleOutputDetails.add(ruleOutputDetail);
        }
        this.lastRuleOutputDetail = ruleOutputDetail;
        if (logger.isTraceEnabled()) {
            logger.trace("getNextRuleOutputDetails() - Returning list: " + String.valueOf(ruleOutputDetails));
        }
        return ruleOutputDetails;
    }

    protected RuleOutputDetail getNextRuleOutputDetail() throws EOFException {
        RuleOutputDetail ruleOutputDetail = null;
        if (logger.isTraceEnabled()) {
            logger.trace("getNextRuleOutputDetail() - Fetching RuleOutputDetail for validaton run: " + this.validationRunID);
        }
        if (this.readFromFile) {
            try {
                ruleOutputDetail = (RuleOutputDetail)this.ruleOutputDetailHandler.readNextLine(this.validationRunID);
            }
            catch (InterruptedIOException e) {
                String message = "I/O error while reading RULE_OUTPUT_DETAIL file: " + e.getMessage();
                logger.error("getNextRuleOutputDetail() - " + message);
                throw new EOFException(message);
            }
            catch (EOFException e) {
                throw e;
            }
            catch (Exception e) {
                String message = "Generic error while reading RULE_OUTPUT_DETAIL file: " + e.getMessage();
                logger.error("getNextRuleOutputDetail() - " + message);
                throw new EOFException(message);
            }
        } else {
            ruleOutputDetail = this.ruleOutputDetailDAO.getNextByValidationRunID(this.validationRunID);
            if (logger.isTraceEnabled()) {
                logger.trace("getNextRuleOutput() - Fetched RuleOutputDetail from DAO:" + String.valueOf(ruleOutputDetail));
            }
        }
        if (ruleOutputDetail == null) {
            String message = "Found null row while reading RULE_OUTPUT_DETAIL file: ";
            logger.error("getNextRuleOutputDetail() - " + message);
            throw new EOFException(message);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getNextRuleOutputDetail() - Read RuleOutputDetail:" + String.valueOf(ruleOutputDetail));
        }
        return ruleOutputDetail;
    }

    protected File getTemporaryFolder() {
        FileConnection validationRunConnection = FlatFileDAOFactory.getConnection(DAO.VALIDATION_RUN);
        String tempPath = validationRunConnection.getRelativePath();
        String userDir = System.getProperty("user.dir");
        String actualPath = userDir + "/" + tempPath;
        File tempFolder = new File(actualPath);
        if (logger.isTraceEnabled()) {
            logger.trace("getTemporaryFolder() - Temporary folder: " + actualPath);
        }
        return tempFolder;
    }

    public ReferenceDataReader getReferenceDataReader() {
        return this.referenceDataReader;
    }

    public void setReferenceDataReader(ReferenceDataReader referenceDataReader) {
        this.referenceDataReader = referenceDataReader;
    }

    public boolean isReadFromFile() {
        return this.readFromFile;
    }

    public void setReadFromFile(boolean readFromFile) {
        this.readFromFile = readFromFile;
    }

    public boolean isReadFromDAO() {
        return this.readFromDAO;
    }

    public void setReadFromDAO(boolean readFromDAO) {
        this.readFromDAO = readFromDAO;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    protected void benchmark(String prefix, AbstractRule rule, int lineNumber) {
        boolean logTime = true;
        if (logTime) {
            StringBuilder ruleIdentifier = new StringBuilder();
            StringBuilder recordIdentifier = new StringBuilder();
            ruleIdentifier.append(prefix);
            ruleIdentifier.append("_");
            ruleIdentifier.append(rule.getId());
            ruleIdentifier.append(": ");
            ruleIdentifier.append(rule.getName());
            recordIdentifier.append(" (line=");
            recordIdentifier.append(lineNumber);
            recordIdentifier.append(")");
            SystemTester.benchmark(ruleIdentifier.toString(), recordIdentifier.toString());
        }
    }

    protected RuleOutput readMasterRawFile(int lines) {
        this.counter = 0;
        RuleOutput ruleOutput = null;
        if (logger.isInfoEnabled()) {
            if (lines > 0) {
                String plural = lines > 1 ? "s" : "";
                logger.info("readMasterRawFile() - Reading " + lines + " record" + plural + " from RULE_OUTPUT file");
            } else {
                logger.info("readMasterRawFile() - Reading ALL records from RULE_OUTPUT file");
            }
        }
        while (true) {
            try {
                ruleOutput = this.getNextRuleOutput();
                if (lines > 0 && ++this.counter == lines) {
                    return ruleOutput;
                }
            }
            catch (EOFException e) {
                if (!logger.isInfoEnabled()) break;
                logger.info("readMasterRawFile() - Reached EOF for RULE_OUTPUT file");
                break;
            }
            catch (Exception e) {
                logger.error("readMasterRawFile() - Error while reading: " + e.getMessage());
                break;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("readMasterRawFile() - Fetched RuleOutput: " + String.valueOf(ruleOutput));
        }
        return ruleOutput;
    }

    protected void readDetailRawFile() {
        RuleOutputDetail ruleOutputDetail = null;
        if (logger.isInfoEnabled()) {
            logger.info("readDetailRawFile() - Reading all records from RULE_OUTPUT_DETAIL file");
        }
        while (true) {
            try {
                ruleOutputDetail = this.getNextRuleOutputDetail();
            }
            catch (EOFException e) {
                if (!logger.isInfoEnabled()) break;
                logger.info("readDetailRawFile() - Reached EOF for RULE_OUTPUT_DETAIL file");
                break;
            }
            catch (Exception e) {
                logger.error("readDetailRawFile() - Error while reading: " + e.getMessage());
                break;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("readDetailRawFile() - Returning RuleOutput:" + String.valueOf(ruleOutputDetail));
        }
    }

    protected void readReferenceData(int line) {
        String fieldName = "PAT";
        RuleOutput ruleOutput = this.readMasterRawFile(line);
        if (logger.isInfoEnabled()) {
            logger.info("readReferenceData() - Reading RuleOutput: " + String.valueOf(ruleOutput));
        }
        String fieldValue = this.referenceDataReader.getFieldValue(ruleOutput, fieldName);
        if (logger.isInfoEnabled()) {
            logger.info("readReferenceData() - \"" + fieldName + "\" value: " + fieldValue);
        }
    }

    protected void logConnectionData() {
        FileHandlerTXT txtParentHandler = (FileHandlerTXT)((Object)this.ruleOutputDAO);
        BufferedFileHandler bufferedParentHandler = (BufferedFileHandler)((Object)this.ruleOutputDAO);
        boolean autoCommit = false;
        if (txtParentHandler != null) {
            autoCommit = txtParentHandler.isAutoCommit();
        } else {
            logger.warn("logConnectionData() - FileHandlerTXT is null -> no info about Autocommit mode");
        }
        InputStream stream = null;
        FileConnection connection = null;
        if (bufferedParentHandler != null) {
            connection = bufferedParentHandler.getConnection();
            stream = connection.getInputStream();
        } else {
            logger.warn("logConnectionData() - BufferedFileHandler is null -> no info about InputStream");
        }
        logger.info("");
        logger.info("logConnectionData() - Using connection   : " + String.valueOf(connection));
        logger.info("logConnectionData() - Autocommit mode    : " + autoCommit);
        logger.info("logConnectionData() - Connection' stream : " + String.valueOf(stream));
        logger.info("");
    }
}

