/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine;

import eu.europa.ec.jrc.qcs.dao.DataRecordDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetWriter {
    private int validationRunID;
    private int correctRecords;
    private int validRecords;
    private int recordsWithIssues;
    private int uncheckedRecords;
    private DataRecord header;
    private int schemaID = 11;
    protected boolean writeOnDAO = true;
    protected boolean writeOnFile = false;
    protected FileHandlerCSV<DataRecord> correctRecordsHandler;
    protected FileHandlerCSV<DataRecord> validRecordsHandler;
    protected FileHandlerCSV<DataRecord> withIssuesRecordsHandler;
    protected FileHandlerCSV<DataRecord> uncheckedRecordsHandler;
    protected DataRecordDAO correctRecordsDAO;
    protected DataRecordDAO validRecordsDAO;
    protected DataRecordDAO withIssuesRecordsDAO;
    protected DataRecordDAO uncheckedRecordsDAO;
    protected static SchemaViewDAO schemaViewDAO;
    public static final String LINE_NUMBER = "Line_Number";
    protected static Logger logger;

    protected void init() {
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        this.correctRecordsDAO = (DataRecordDAO)((Object)daoFactory.getDAO(DAO.DATA_RECORD_CORRECT));
        this.validRecordsDAO = (DataRecordDAO)((Object)daoFactory.getDAO(DAO.DATA_RECORD_VALID));
        this.uncheckedRecordsDAO = (DataRecordDAO)((Object)daoFactory.getDAO(DAO.DATA_RECORD_UNCHECKED));
        this.withIssuesRecordsDAO = (DataRecordDAO)((Object)daoFactory.getDAO(DAO.DATA_RECORD_WITH_ISSUES));
        schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        if (this.writeOnFile) {
            this.correctRecordsHandler = this.initFileHandler(DAO.DATA_RECORD_CORRECT);
            this.validRecordsHandler = this.initFileHandler(DAO.DATA_RECORD_VALID);
            this.withIssuesRecordsHandler = this.initFileHandler(DAO.DATA_RECORD_WITH_ISSUES);
            this.uncheckedRecordsHandler = this.initFileHandler(DAO.DATA_RECORD_UNCHECKED);
            if (logger.isInfoEnabled()) {
                logger.info("init() - Saving records directly on file system (temp folder)");
            }
        }
        if (this.writeOnDAO) {
            if (this.validationRunID > 0) {
                this.correctRecordsDAO.init(this.validationRunID);
                this.validRecordsDAO.init(this.validationRunID);
                this.withIssuesRecordsDAO.init(this.validationRunID);
                this.uncheckedRecordsDAO.init(this.validationRunID);
                this.correctRecordsDAO.openConnection();
                this.validRecordsDAO.openConnection();
                this.withIssuesRecordsDAO.openConnection();
                this.uncheckedRecordsDAO.openConnection();
            } else {
                String message = "init() - DAO objects not initialized: validationRunID is missing";
                logger.warn(message);
            }
            if (logger.isInfoEnabled()) {
                logger.info("init() - Saving records through DAO layer");
            }
        }
        this.header = null;
        this.correctRecords = 0;
        this.validRecords = 0;
        this.recordsWithIssues = 0;
        this.uncheckedRecords = 0;
    }

    protected FileHandlerCSV<DataRecord> initFileHandler(DAO dao) {
        FileConnection fileConnection = FlatFileDAOFactory.getConnection(dao);
        fileConnection.setWriteAccess(true);
        FileHandlerCSV<DataRecord> handler = new FileHandlerCSV<DataRecord>(fileConnection, DataRecord.class, true);
        handler.setHeader(true);
        handler.setNewFile(true);
        handler.setAutoCommit(false);
        if (this.validationRunID > 0) {
            handler.openWriter(this.validationRunID);
        } else {
            String message = "initFileHandler() - File handlers not initialized: validationRunID is missing";
            logger.warn(message);
        }
        return handler;
    }

    public boolean saveCorrectRecord(DataRecord dataRecord, int lineNumber) {
        boolean written = this.saveRecord(this.correctRecordsDAO, this.correctRecordsHandler, dataRecord, lineNumber);
        if (written) {
            ++this.correctRecords;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("saveCorrectRecord() - Saved correct record number: " + this.correctRecords);
        }
        return written;
    }

    public boolean saveValidRecord(DataRecord dataRecord, int lineNumber) {
        boolean written = this.saveRecord(this.validRecordsDAO, this.validRecordsHandler, dataRecord, lineNumber);
        if (written) {
            ++this.validRecords;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("saveCorrectRecord() - Saved valid record number: " + this.validRecords);
        }
        return written;
    }

    public boolean saveRecordWithIssues(DataRecord dataRecord, int lineNumber) {
        boolean written = this.saveRecord(this.withIssuesRecordsDAO, this.withIssuesRecordsHandler, dataRecord, lineNumber);
        if (written) {
            ++this.recordsWithIssues;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("saveCorrectRecord() - Saved record with issue number : " + this.recordsWithIssues);
        }
        return written;
    }

    public int saveRecordWithIssues(List<DataRecord> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int written = 0;
        int writtenOnDAO = 0;
        int writtenOnFile = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("saveRecordWithIssues(List) - Saving list with " + list.size() + " records");
        }
        if (this.writeOnDAO) {
            writtenOnDAO += this.withIssuesRecordsDAO.save(list);
            if (logger.isTraceEnabled()) {
                logger.trace("saveRecordWithIssues(List) - Saved " + writtenOnDAO + " records through DAO layer");
            }
        }
        if (this.writeOnFile) {
            boolean firstAccess;
            boolean bl = firstAccess = this.withIssuesRecordsHandler.getCursor() == 0;
            if (firstAccess) {
                DataRecord firstRecord = list.get(0);
                String[] actualHeader = this.header.getColumnNames();
                firstRecord.setColumnNames(actualHeader);
            }
            writtenOnFile = this.withIssuesRecordsHandler.writeFile(this.validationRunID, list);
            if (logger.isTraceEnabled()) {
                logger.trace("saveRecordWithIssues(List) - Saved " + writtenOnFile + " records through file handler");
            }
        }
        if (this.writeOnDAO && !this.writeOnFile) {
            written = writtenOnDAO;
        }
        if (!this.writeOnDAO && this.writeOnFile) {
            written = writtenOnFile;
        }
        if (this.writeOnDAO && this.writeOnFile) {
            if (writtenOnDAO == writtenOnFile) {
                written = writtenOnDAO;
            } else {
                String message = "Wrong number of written records: DAO=" + writtenOnDAO + " != File=" + writtenOnFile;
                logger.error("saveRecordWithIssues(List) - " + message);
                written = writtenOnDAO > writtenOnFile ? writtenOnDAO : writtenOnFile;
            }
        }
        this.recordsWithIssues += written;
        return written;
    }

    public boolean saveUncheckeRecord(DataRecord dataRecord, int lineNumber) {
        boolean written = this.saveRecord(this.uncheckedRecordsDAO, this.uncheckedRecordsHandler, dataRecord, lineNumber);
        if (written) {
            ++this.uncheckedRecords;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("saveCorrectRecord() - Saved unchecked record number: " + this.uncheckedRecords);
        }
        return written;
    }

    public void commit() {
        if (this.writeOnDAO) {
            this.correctRecordsDAO.closeConnection();
            this.validRecordsDAO.closeConnection();
            this.withIssuesRecordsDAO.closeConnection();
            this.uncheckedRecordsDAO.closeConnection();
            if (logger.isDebugEnabled()) {
                logger.debug("commit() - Closed all connections to DAO layer");
            }
        }
        if (this.writeOnFile) {
            this.correctRecordsHandler.closeWriter();
            this.validRecordsHandler.closeWriter();
            this.withIssuesRecordsHandler.closeWriter();
            this.uncheckedRecordsHandler.closeWriter();
            if (logger.isDebugEnabled()) {
                logger.debug("commit() - Closed all connections to file handlers");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("commit() - Number of perfect records       : " + this.correctRecords);
            logger.debug("commit() - Number of records valid records : " + this.validRecords);
            logger.debug("commit() - Number of records with issues   : " + this.recordsWithIssues);
            logger.debug("commit() - Number of unchecjed records     : " + this.uncheckedRecords);
        }
    }

    protected boolean saveRecord(DataRecordDAO dao, FileHandlerCSV<DataRecord> handler, DataRecord dataRecord, int lineNumber) {
        boolean writtenOnDAO = false;
        boolean writtenOnFile = false;
        if (logger.isTraceEnabled()) {
            logger.trace("saveRecord() - Adding line number to record: " + String.valueOf(dataRecord));
        }
        DataRecord newRecord = this.addLineNumber(dataRecord, lineNumber);
        if (logger.isTraceEnabled()) {
            logger.trace("saveRecord() - Saving record: " + String.valueOf(dataRecord) + " (lineNumber = " + lineNumber + ")");
        }
        if (this.writeOnDAO) {
            writtenOnDAO = dao.save(newRecord);
        }
        if (this.writeOnFile) {
            writtenOnFile = handler.writeFile(this.validationRunID, newRecord);
        }
        return writtenOnDAO || writtenOnFile;
    }

    protected DataRecord addLineNumber(DataRecord dataRecord, int lineNumber) {
        DataRecord newRecord = dataRecord.clone();
        String lineNumberAsString = String.valueOf(lineNumber);
        newRecord.unshift(LINE_NUMBER, lineNumberAsString);
        return newRecord;
    }

    protected DataRecord addLineNumberHeader(DataRecord dataRecord) {
        DataRecord newRecord = dataRecord.clone();
        newRecord.unshift(LINE_NUMBER, LINE_NUMBER);
        if (logger.isTraceEnabled()) {
            logger.trace("addLineNumberHeader() - newRecord = " + String.valueOf(newRecord));
        }
        return newRecord;
    }

    public void setValidationRunID(int validationRunID) {
        this.validationRunID = validationRunID;
        this.init();
    }

    public void setHeader() {
        this.loadHeaderFromSchema(true);
        this.correctRecordsDAO.setHeader(this.header);
        this.validRecordsDAO.setHeader(this.header);
        this.withIssuesRecordsDAO.setHeader(this.header);
        this.uncheckedRecordsDAO.setHeader(this.header);
        if (logger.isDebugEnabled()) {
            logger.debug("setHeader() - Set header: " + String.valueOf(this.header));
        }
    }

    protected void loadHeaderFromSchema(boolean addLineNumber) {
        SchemaView schemaView = schemaViewDAO.getFullSchemaViewByID(this.schemaID);
        Object[] schemaHeader = schemaView.getHeaders();
        if (logger.isTraceEnabled()) {
            logger.trace("getHeaderFromSchema() - Schema's header: " + Arrays.toString(schemaHeader));
        }
        DataRecordCSV headerAsRecord = new DataRecordCSV((String[])schemaHeader);
        ((DataRecord)headerAsRecord).setColumnNames((String[])schemaHeader);
        if (!addLineNumber) {
            this.header = headerAsRecord;
        } else {
            this.header = this.addLineNumberHeader(headerAsRecord);
            if (logger.isTraceEnabled()) {
                logger.trace("getHeaderFromSchema() - Added line number");
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getHeaderFromSchema() - Set header: " + String.valueOf(this.header));
        }
    }

    public int getValidationRunID() {
        return this.validationRunID;
    }

    public DataRecord getHeader() {
        return this.header;
    }

    public int getCorrectRecords() {
        return this.correctRecords;
    }

    public int getValidRecords() {
        return this.validRecords;
    }

    public int getRecordsWithIssues() {
        return this.recordsWithIssues;
    }

    public int getUncheckedRecords() {
        return this.uncheckedRecords;
    }

    public int getSchemaID() {
        return this.schemaID;
    }

    public void setSchemaID(int schemaID) {
        this.schemaID = schemaID;
    }

    public boolean isWriteOnFile() {
        return this.writeOnFile;
    }

    public void setWriteOnFile(boolean writeOnFile) {
        this.writeOnFile = writeOnFile;
    }

    public boolean isWriteOnDAO() {
        return this.writeOnDAO;
    }

    public void setWriteOnDAO(boolean writeOnDAO) {
        this.writeOnDAO = writeOnDAO;
    }

    static {
        logger = LoggerFactory.getLogger(DataSetWriter.class);
    }
}

