/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.DataRecordDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.EndOfDataConnetionException;
import eu.europa.ec.jrc.qcs.dao.datasource.ExhaustedDataConnectionException;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.input.DataConnection;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetReader {
    private int counter;
    private int maxRows;
    private boolean beginOfDataSet;
    private boolean endOfDataSet;
    private String filePath;
    List<DataRecord> bunch;
    DataRecord previousRecord;
    String bunchKey;
    String nextBunchKey;
    public static final int ALL_ROWS = 0;
    protected DataRecordDAO dataRecordDAO;
    protected static Logger logger = LoggerFactory.getLogger(DataSetReader.class);

    public DataSetReader() {
        this.init();
        this.filePath = Configuration.getInstance().getProperty(Property.DEFAULT_INPUT_FILE);
    }

    protected void init() {
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        this.dataRecordDAO = (DataRecordDAO)((Object)daoFactory.getDAO(DAO.DATA_RECORD));
    }

    public void resetDataset() {
        this.counter = 1;
        this.beginOfDataSet = true;
        this.endOfDataSet = false;
        if (logger.isInfoEnabled()) {
            logger.info("resetDataset() - filePath = " + this.filePath);
        }
    }

    public DataConnection getDataConnection() {
        FileConnection connection = new FileConnection(this.filePath);
        if (connection.validate()) {
            this.dataRecordDAO.setDataConnection(connection);
            if (logger.isInfoEnabled()) {
                logger.info("getDataConnection() - Created new connection to file = " + this.filePath);
            }
        }
        return connection;
    }

    public DataRecord getHeader() {
        this.getDataConnection();
        DataRecord header = this.dataRecordDAO.getHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("getHeader() - header = " + String.valueOf(header));
        }
        return header;
    }

    public DataRecord getNextDataRecord() {
        if (logger.isDebugEnabled()) {
            logger.debug("getNextDataRecord() - Invoked for row: " + this.counter);
        }
        if (this.beginOfDataSet) {
            this.getDataConnection();
            if (logger.isDebugEnabled()) {
                DataRecord header = this.dataRecordDAO.getHeader();
                logger.debug("");
                logger.debug("getNextDataRecord(): Dataset's header: \n");
                logger.debug(header.toString());
            }
            this.beginOfDataSet = false;
            if (logger.isInfoEnabled()) {
                if (this.maxRows != 0) {
                    logger.info("getNextDataRecord(): Reading file line by line (up to " + this.maxRows + " maximum rows):");
                } else {
                    logger.info("getNextDataRecord(): Reading file line by line (no upper limit)");
                }
            }
        }
        DataRecord record = null;
        try {
            record = this.dataRecordDAO.getNext();
            ++this.counter;
            if (logger.isTraceEnabled()) {
                logger.trace("getNextDataRecord(): " + this.counter + ") Record = " + record.toShortString());
            }
        }
        catch (EndOfDataConnetionException e) {
            logger.info("getNextDataRecord(): " + e.getMessage());
            this.endOfDataSet = true;
            return null;
        }
        catch (ExhaustedDataConnectionException e) {
            logger.error("getNextDataRecord(): " + e.getMessage());
            this.endOfDataSet = true;
            return null;
        }
        catch (Exception e) {
            logger.error("getNextDataRecord() - Unexepeted error: " + e.getMessage());
            return null;
        }
        catch (Throwable t) {
            logger.error("getNextDataRecord() - Fatal error: " + t.getMessage());
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNextDataRecord() - " + this.counter + ") " + record.toShortString() + " (cursor=" + this.dataRecordDAO.getCursor() + ", begin=" + this.beginOfDataSet + ")");
        }
        return record;
    }

    public boolean hasNext() {
        boolean hasNext;
        if (this.endOfDataSet) {
            return false;
        }
        if (this.maxRows == 0) {
            return true;
        }
        boolean bl = hasNext = this.counter < this.maxRows;
        if (!hasNext) {
            logger.warn("Reached max rows limit: " + this.maxRows);
        }
        return hasNext;
    }

    public List<DataRecord> getNextBunch(int bunchKeyIndex) {
        DataRecord record;
        block21: {
            if (this.beginOfDataSet) {
                this.getDataConnection();
                this.beginOfDataSet = false;
                if (logger.isInfoEnabled()) {
                    logger.info("getNextBunch() - Target file: " + this.filePath);
                }
            }
            record = null;
            String currentBunchKey = null;
            this.bunch = new ArrayList<DataRecord>();
            if (logger.isDebugEnabled()) {
                logger.debug("getNextBunch(): " + this.counter + ") Starting while cycle with previous key: " + this.nextBunchKey);
            }
            while (true) {
                block20: {
                    try {
                        record = this.dataRecordDAO.getNext();
                        ++this.counter;
                        if (!logger.isTraceEnabled()) break block20;
                        logger.trace("getNextBunch(): " + this.counter + ") Fetched record = " + record.toShortString());
                    }
                    catch (EndOfDataConnetionException e) {
                        logger.info("getNextBunch() - " + e.getMessage());
                        this.endOfDataSet = true;
                        break block21;
                    }
                    catch (ExhaustedDataConnectionException e) {
                        logger.error("getNextBunch() - " + e.getMessage());
                        this.endOfDataSet = true;
                        break block21;
                    }
                }
                currentBunchKey = record.getValue(bunchKeyIndex);
                if (this.nextBunchKey == null) {
                    this.bunch.add(record);
                    this.nextBunchKey = new String(currentBunchKey);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("getNextBunch(): INIT nextBunchKey: " + this.nextBunchKey + " (first record in the dataset)");
                    continue;
                }
                if (this.previousRecord != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getNextBunch(): LAST previous record's key: " + this.previousRecord.getValue(bunchKeyIndex));
                    }
                    this.bunch = new ArrayList<DataRecord>();
                    this.bunch.add(this.previousRecord);
                    this.previousRecord = null;
                }
                if (!this.nextBunchKey.equals(currentBunchKey)) break;
                if (record != null) {
                    this.bunch.add(record);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("getNextBunch(): ADDED record to current bunch: " + record.toShortString());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getNextBunch(): END of bunch for key: " + this.nextBunchKey + " (bunch size: " + this.bunch.size() + ") - Current key: " + currentBunchKey);
            }
            this.bunchKey = new String(this.nextBunchKey);
            this.previousRecord = record;
            this.nextBunchKey = new String(currentBunchKey);
            if (logger.isDebugEnabled()) {
                logger.debug("getNextBunch(): NEXT bunch will regard key " + this.nextBunchKey + ", caching record: " + this.previousRecord.toShortString());
            }
        }
        if (this.endOfDataSet) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNextBunch() - Saving last bunch key: " + this.nextBunchKey);
            }
            if (this.nextBunchKey != null) {
                this.bunchKey = new String(this.nextBunchKey);
            }
            if (record == null && this.previousRecord != null) {
                this.bunch = new ArrayList<DataRecord>();
                this.bunch.add(this.previousRecord);
                if (logger.isDebugEnabled()) {
                    logger.debug("getNextBunch(): handled single line at the end of the dataset (no duplicate)");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("getNextBunch(): handled last bunch at the end of the dataset (with duplicates)");
            }
        }
        return this.bunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfLines() {
        int n;
        byte eol = 10;
        BufferedInputStream inputStream = null;
        if (logger.isDebugEnabled()) {
            logger.debug("getNumberOfLines() - InputStream's path: " + this.filePath);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.filePath);
            inputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException e) {
            logger.error("getNumberOfLines() - File not found exception: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("getNumberOfLines() - Failed opening input stream: " + e.getMessage());
        }
        catch (Throwable t) {
            logger.error("getNumberOfLines() - Critical error opening input stream: " + t.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNumberOfLines() - InputStream: " + String.valueOf(inputStream));
        }
        try {
            int count = 0;
            int readChars = 0;
            boolean isEmpty = true;
            byte[] byteArray = new byte[1024];
            if (logger.isDebugEnabled()) {
                logger.debug("getNumberOfLines() - Reading line by line: " + String.valueOf(inputStream));
            }
            try {
                while ((readChars = ((InputStream)inputStream).read(byteArray)) != -1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getNumberOfLines() - Last read chars: " + readChars);
                    }
                    isEmpty = false;
                    for (int i = 0; i < readChars; ++i) {
                        if (byteArray[i] != eol) continue;
                        ++count;
                    }
                }
                if (logger.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    for (byte b : byteArray) {
                        builder.append((char)b);
                    }
                    logger.debug("getNumberOfLines() - last read byteArray: " + builder.toString());
                }
                if (count > 0 && byteArray.length > 0) {
                    ++count;
                }
            }
            catch (IOException e) {
                logger.error("getNumberOfLines() - IOException: " + e.getMessage());
            }
            catch (Exception e) {
                logger.error("getNumberOfLines() - Generic exception: " + e.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getNumberOfLines() - count: " + count);
            }
            n = count == 0 && !isEmpty ? 1 : count;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("getNumberOfLines() - Final IOException: " + e.getMessage());
            }
            catch (Exception e) {
                String message = e.getMessage() != null ? e.getMessage() : "no additional information (see previous message)";
                logger.error("getNumberOfLines() - Final generic exception: " + message);
            }
            throw throwable;
        }
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            logger.error("getNumberOfLines() - Final IOException: " + e.getMessage());
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : "no additional information (see previous message)";
            logger.error("getNumberOfLines() - Final generic exception: " + message);
        }
        return n;
    }

    public int estimateDataSetSize(ProtocolView protocolView) {
        FileConnection connection = new FileConnection(this.filePath);
        File datasetFile = connection.getFile();
        long bytes = 0L;
        if (datasetFile.exists()) {
            bytes = datasetFile.length();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("estimateDataSetSize() - bytes: " + bytes);
        }
        SchemaView schemaView = protocolView.getFullSchemaView();
        int numberOfFields = schemaView.getNumberOfFields();
        int averageLineBytes = 2 * numberOfFields;
        int numberOfLines = (int)(bytes / (long)averageLineBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("estimateDataSetSize() - approximate number of lines: " + numberOfLines);
        }
        return numberOfLines;
    }

    public void closeDataConnection() {
        this.dataRecordDAO.closeConnection();
    }

    public String getBunchInformation() {
        StringBuilder builder = new StringBuilder();
        builder.append("bunch based on key: ");
        builder.append(this.getBunchKey());
        builder.append(" -> ");
        builder.append(this.getNextBunchKey());
        builder.append(" (size ");
        builder.append(this.bunch.size());
        builder.append(")");
        return builder.toString();
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        if (logger.isDebugEnabled()) {
            logger.debug("setFilePath() - " + this.getObjectIdentifier(this) + " -> filePath = " + this.filePath);
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean isBeginOfDataSet() {
        return this.beginOfDataSet;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getBunchKey() {
        return this.bunchKey;
    }

    public String getNextBunchKey() {
        return this.nextBunchKey;
    }

    public DataRecord getLastRecord() {
        return this.previousRecord;
    }

    protected String getObjectIdentifier(Object object) {
        if (object == null) {
            return "NULL_OBJECT";
        }
        String[] fullName = object.toString().split("@");
        String hash = fullName[fullName.length - 1];
        String objectIdentifier = object.getClass().getSimpleName() + "@" + hash;
        return objectIdentifier;
    }

    protected void logEndOfDataSet(DataRecord record) {
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("Previous record : " + String.valueOf(this.previousRecord));
            if (record != null) {
                logger.info("Record          : " + record.toShortString());
            } else {
                logger.info("Record          : null");
            }
            if (this.bunch != null) {
                logger.info("Bunch:");
                for (DataRecord element : this.bunch) {
                    logger.info("\t" + element.toShortString());
                }
            }
            logger.info("");
        }
    }
}

