/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.dto.SchemaGroup;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.report.ReportType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasGroup
extends GenericModel {
    protected List<Schema> schemas;
    protected ReportType reportType;
    public static final SchemasGroup UNDEF = new SchemasGroup();
    public static final List<SchemasGroup> EMPTY_LIST = new ArrayList<SchemasGroup>();
    protected static SchemaDAO schemaDAO;
    protected static Logger logger;

    public SchemasGroup() {
        super(0, 0);
        this.setValid(false);
        this.setName("SchemaGroup");
        this.setDescription("Empty reference for a \"null\" SchemaGroup instance");
        this.className = "group";
    }

    public SchemasGroup(int id) {
        super(id);
    }

    public SchemasGroup(String id, String name, String description, String reportTypeID) {
        this();
        this.valid = true;
        this.setName(name);
        this.setId(id);
        this.setDescription(description);
        this.setReportType(reportTypeID);
    }

    public SchemasGroup(String[] array) {
        this(array[0], array[1], array[2], array[3]);
    }

    public SchemasGroup(SchemaGroup dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.valid = true;
        this.setId(dto.getId());
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
        this.setReportType(String.valueOf(dto.getReportType().getId()));
        if (logger.isTraceEnabled()) {
            logger.trace("Schema(dto) - Created new instance: " + String.valueOf(this));
        }
    }

    public List<Schema> getAllSchema() {
        if (this.schemas == null) {
            int groupID = this.getId();
            this.schemas = schemaDAO.getByGroupID(groupID);
        }
        return this.schemas;
    }

    public void addSchema(Schema schema) {
        int groupID = schema.getGroupID();
        if (groupID != this.getId()) {
            logger.error("Tried to add a Schema to the wrong SchemasGroup instance: schema.groupID: " + groupID);
            return;
        }
        if (this.schemas == null) {
            this.schemas = new ArrayList<Schema>();
        }
        this.schemas.add(schema);
    }

    public Schema getSchema(int schemaID) {
        List<Schema> list = this.getAllSchema();
        for (Schema schema : list) {
            if (schema.getId() != schemaID) continue;
            return schema;
        }
        return Schema.UNDEF;
    }

    public void setReportType(String reportTypeID) {
        ReportType type = ReportType.getByID(reportTypeID);
        if (type != ReportType.WRONG && type != ReportType.UNDEF) {
            this.reportType = type;
        } else {
            this.reportType = ReportType.UNDEF;
            this.addWarningMessage("ReportType value (String) forced to 'UNDEF' for " + this.getModelLabel(reportTypeID));
        }
    }

    public void setSchemas(List<Schema> schemas) {
        this.schemas = schemas;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getIdAsString());
        builder.append(".");
        builder.append(this.getName());
        builder.append(" (");
        builder.append(this.getDescription());
        builder.append(") type=");
        builder.append((Object)this.reportType);
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SchemasGroup) {
            SchemasGroup anotherSchemaGroup = (SchemasGroup)object;
            return this.getId() == anotherSchemaGroup.getId();
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    static {
        logger = LoggerFactory.getLogger(SchemasGroup.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        schemaDAO = (SchemaDAO)((Object)daoFactory.getDAO(DAO.SCHEMA));
    }
}

