/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.CachedMap;
import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Key;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaView
extends SchemaToField
implements CachedMap {
    protected SchemaView parentSchemaView;
    protected List<SchemaToField> schemaToFields;
    protected List<Field> fields;
    protected List<Integer> positions;
    protected Map<Integer, Field> fieldsByID;
    protected Map<String, Field> fieldsByName;
    protected Map<Integer, Field> fieldsByPosition;
    protected Map<Integer, SchemaToField> schemaToFieldsByID;
    protected Map<Integer, SchemaToField> schemaToFieldsByPosition;
    protected List<SchemaToField> keySchemaToFields;
    protected Map<Integer, SchemaToField> keySchemaToFieldsByID;
    protected List<Field> functionFields;
    protected Map<Integer, Field> functionFieldsByID;
    public static final SchemaView UNDEF = new SchemaView();
    protected static SchemaViewDAO schemaViewDAO = null;
    protected static Logger logger = LoggerFactory.getLogger(SchemaView.class);

    public SchemaView() {
        this.setValid(false);
        this.setId(0);
        this.setName("undefined_schema_view");
        this.setDescription("Empty reference for a \"null\" SchemaView instance");
    }

    public SchemaView(Schema schema, List<SchemaToField> schemaToFields) {
        this();
        this.schema = schema;
        this.schemaToFields = schemaToFields;
        this.setId(schema.getId());
        if (logger.isTraceEnabled()) {
            logger.trace("SchemaView(Schema, List) - " + String.valueOf(schema) + " with " + schemaToFields.size() + " fields");
        }
        this.setSchemaID(Integer.toString(schema.getId()));
        this.setFieldID(0);
        this.setName(schema.getName());
        this.setDescription(schema.getDescription());
        this.loadData();
    }

    @Override
    public void initCache() {
        this.fields = new ArrayList<Field>();
        this.positions = new ArrayList<Integer>();
        this.fieldsByID = new HashMap<Integer, Field>();
        this.fieldsByName = new HashMap<String, Field>();
        this.fieldsByPosition = new HashMap<Integer, Field>();
        this.schemaToFieldsByID = new HashMap<Integer, SchemaToField>();
        this.schemaToFieldsByPosition = new HashMap<Integer, SchemaToField>();
        this.keySchemaToFields = new ArrayList<SchemaToField>();
        this.keySchemaToFieldsByID = new HashMap<Integer, SchemaToField>();
        this.functionFields = new ArrayList<Field>();
        this.functionFieldsByID = new HashMap<Integer, Field>();
    }

    protected void loadData() {
        this.initCache();
        int counter = 1;
        boolean verbose = false;
        for (SchemaToField schemaToField : this.schemaToFields) {
            Field field = schemaToField.getField();
            int fieldID = field.getId();
            String fieldName = field.getName();
            int fieldPosition = schemaToField.getPosition();
            if (!schemaToField.isFunction()) {
                this.fields.add(field);
                this.positions.add(fieldPosition);
                this.fieldsByID.put(fieldID, field);
                this.fieldsByName.put(fieldName.toUpperCase(), field);
                this.fieldsByPosition.put(fieldPosition, field);
                this.schemaToFieldsByID.put(fieldID, schemaToField);
                this.schemaToFieldsByPosition.put(fieldPosition, schemaToField);
                if (verbose) {
                    logger.info("init() - Cached SchemaToFieldID " + counter++ + "): " + String.valueOf(schemaToField) + " -> " + field.toShortString());
                }
            } else {
                this.functionFields.add(field);
                this.functionFieldsByID.put(fieldID, field);
                if (logger.isDebugEnabled()) {
                    logger.debug("init() - Cached \"function\" SchemaToFieldID = " + this.getId() + ", fieldsID = " + fieldID + " -> " + String.valueOf(field));
                }
            }
            if (!schemaToField.isKey()) continue;
            this.keySchemaToFields.add(schemaToField);
            this.keySchemaToFieldsByID.put(fieldID, schemaToField);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("init() - Cached \"key\" SchemaToFieldID = " + this.getId() + ", fieldsID = " + fieldID + " -> " + String.valueOf(schemaToField.getKey()));
        }
        if (verbose) {
            logger.info("");
            logger.info("init() - Number of cached Field                       : " + this.fields.size());
            logger.info("init() - Number of cached Positions                   : " + this.positions.size());
            logger.info("init() - Number of cached Field (by ID)               : " + this.fieldsByID.size());
            logger.info("init() - Number of cached Field (by name)             : " + this.fieldsByName.size());
            logger.info("init() - Number of cached Field (by position)         : " + this.fieldsByPosition.size());
            logger.info("init() - Number of cached SchemaToField (by ID)       : " + this.schemaToFieldsByID.size());
            logger.info("init() - Number of cached SchemaToField (by position) : " + this.schemaToFieldsByPosition.size());
            logger.info("");
        }
    }

    public SchemaView getParentSchemaView() {
        if (this.parentSchemaView == null) {
            int parentSchemaID = this.schema.getParentID();
            this.parentSchemaView = (SchemaView)schemaViewDAO.getByID(parentSchemaID);
        }
        return this.parentSchemaView;
    }

    public int getNumberOfFields() {
        if (this.fields == null) {
            return 0;
        }
        boolean verbose = false;
        if (verbose) {
            int counter = 1;
            for (Field field : this.fields) {
                logger.info("getNumberOfFields() - Counting field: " + counter++ + " -> " + field.toShortString());
            }
            logger.info("getNumberOfFields() - Schema size   : " + this.fields.size());
        }
        return this.fields.size();
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.loadData();
        }
        return this.fields;
    }

    public List<Integer> getPositions() {
        if (this.positions == null) {
            this.loadData();
        }
        return this.positions;
    }

    public DataRecord getHeader() {
        String[] schemaHeader = this.getHeaders();
        return new DataRecordCSV(schemaHeader);
    }

    public String[] getHeaders() {
        if (this.fieldsByPosition == null) {
            this.loadData();
        }
        String[] header = new String[this.fieldsByPosition.size()];
        for (int i = 0; i < header.length; ++i) {
            Field field = this.fieldsByPosition.get(i + 1);
            header[i] = new String(field.getName());
        }
        return header;
    }

    public Field getFieldByID(int fieldID) {
        Field field;
        if (this.fieldsByID == null) {
            this.loadData();
        }
        if ((field = this.fieldsByID.get(fieldID)) == null) {
            field = this.getFunctionFieldByID(fieldID);
        }
        if (field != null) {
            return field;
        }
        return Field.UNDEF;
    }

    public Field getFieldByName(String name) {
        Field field;
        if (this.fieldsByName == null) {
            this.loadData();
        }
        if ((field = this.fieldsByName.get(name.toUpperCase())) != null) {
            return field;
        }
        return Field.UNDEF;
    }

    public Field getFieldByPosition(int position) {
        Field field;
        if (this.fieldsByPosition == null) {
            this.loadData();
        }
        if ((field = this.fieldsByPosition.get(position)) != null) {
            return field;
        }
        return Field.UNDEF;
    }

    public int getFieldPosition(Field field) {
        if (field == null) {
            return -1;
        }
        int fieldID = field.getId();
        return this.getFieldPosition(fieldID);
    }

    public int getFieldPosition(int fieldID) {
        SchemaToField schemaToField = this.getSchemaToFieldByID(fieldID);
        if (schemaToField == SchemaToField.UNDEF) {
            return -1;
        }
        return schemaToField.getPosition();
    }

    public SchemaToField getSchemaToFieldByID(int fieldID) {
        SchemaToField schemaToField;
        if (this.schemaToFieldsByID == null) {
            this.loadData();
        }
        if ((schemaToField = this.schemaToFieldsByID.get(fieldID)) != null) {
            return schemaToField;
        }
        return SchemaToField.UNDEF;
    }

    public SchemaToField getSchemaToFieldByPosition(int position) {
        SchemaToField schemaToField;
        if (this.schemaToFieldsByPosition == null) {
            this.loadData();
        }
        if ((schemaToField = this.schemaToFieldsByPosition.get(position)) != null) {
            return schemaToField;
        }
        return SchemaToField.UNDEF;
    }

    public List<Field> getKeyFields(Key targetKey) {
        ArrayList<Field> keyFields = new ArrayList<Field>();
        List<SchemaToField> schemaToFields = this.getKeySchemaToFields();
        for (SchemaToField schemaToField : schemaToFields) {
            boolean matched;
            List<Key> keySymbols = schemaToField.getKey();
            switch (targetKey) {
                case PRIMARY: {
                    matched = Key.isPrimaryKey(keySymbols);
                    break;
                }
                case MAIN: {
                    matched = Key.isMainKey(keySymbols);
                    break;
                }
                case COMPOSITE: {
                    matched = Key.isCompositeKey(keySymbols);
                    break;
                }
                default: {
                    matched = false;
                }
            }
            if (!matched) continue;
            Field field = schemaToField.getField();
            keyFields.add(field);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getKeyFields() - captionKeyFields = " + String.valueOf(keyFields));
        }
        return keyFields;
    }

    public List<SchemaToField> getKeySchemaToFields() {
        if (this.keySchemaToFields == null) {
            this.loadData();
        }
        return this.keySchemaToFields;
    }

    public SchemaToField getKeySchemaToFieldByID(int fieldID) {
        SchemaToField schemaToField;
        if (this.keySchemaToFieldsByID == null) {
            this.loadData();
        }
        if ((schemaToField = this.keySchemaToFieldsByID.get(fieldID)) != null) {
            return schemaToField;
        }
        return SchemaToField.UNDEF;
    }

    public List<Field> getFunctionFields() {
        if (this.functionFields == null) {
            this.loadData();
        }
        return this.functionFields;
    }

    public Field getFunctionFieldByID(int fieldID) {
        Field field;
        if (this.functionFieldsByID == null) {
            this.loadData();
        }
        if ((field = this.functionFieldsByID.get(fieldID)) != null) {
            return field;
        }
        return Field.UNDEF;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public List<SchemaToField> getSchemaToFields() {
        return this.schemaToFields;
    }

    public void setSchemaToFields(List<SchemaToField> schemaToFields) {
        this.schemaToFields = schemaToFields;
    }

    public Map<String, Field> getFieldsByName() {
        return this.fieldsByName;
    }

    public void setFieldsByName(Map<String, Field> fieldsByName) {
        this.fieldsByName = fieldsByName;
    }

    public Map<Integer, Field> getFieldsByPosition() {
        return this.fieldsByPosition;
    }

    public void setFieldsByPosition(Map<Integer, Field> fieldsByPosition) {
        this.fieldsByPosition = fieldsByPosition;
    }

    public Map<Integer, Field> getFieldsByID() {
        return this.fieldsByID;
    }

    public void setFieldsByID(Map<Integer, Field> fieldsByID) {
        this.fieldsByID = fieldsByID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", schemaID=");
        builder.append(this.getIntegerLabel(this.getSchemaID()));
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            builder.append(", ");
            builder.append(this.getDescription());
        }
        builder.append("] (valid=");
        builder.append(this.valid);
        builder.append("]");
        return builder.toString();
    }

    static {
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
    }
}

