/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Key;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaToField
extends GenericModel {
    protected Schema schema;
    protected int position;
    protected Field field;
    private List<Key> key;
    private boolean function;
    public static int globalCounter = 1;
    public static final String FK_SCHEMA_ID = "schemaId";
    public static final SchemaToField UNDEF = new SchemaToField();
    public static final List<SchemaToField> EMPTY_LIST = new ArrayList<SchemaToField>();
    protected static SchemaDAO schemaDAO;
    protected static FieldDAO fieldDAO;
    protected static Logger logger;

    public SchemaToField() {
        this.setValid(false);
        this.setId(0);
        this.setName("undefined_schema_to_link");
        this.setDescription("Empty reference for a \"null\" schemaToLink instance");
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        schemaDAO = (SchemaDAO)((Object)daoFactory.getDAO(DAO.SCHEMA));
        fieldDAO = (FieldDAO)((Object)daoFactory.getDAO(DAO.FIELD));
    }

    public SchemaToField(String[] array) {
        this();
        this.valid = true;
        this.setName(array[5]);
        this.setId(globalCounter++);
        this.setSchemaID(array[0]);
        this.setPosition(array[1]);
        this.setFieldID(array[2]);
        this.setKey(array[3]);
        this.setFunction(array[4]);
        if (array[5] == null || array[5].length() == 0) {
            this.setName(this.getSchemaID() + "-to-" + this.getForeignIdAsString());
        }
        this.setDescription(array[5]);
    }

    public SchemaToField(eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("SchemaToField - Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.setId(dto.getId());
        this.setDescription(dto.getDescription());
        this.setSchemaID(dto.getSchema().getId());
        this.setPosition(dto.getPosition());
        this.setFieldID(dto.getField().getId());
        this.setKey(dto.getKey());
        this.setFunction(dto.getFunction());
        this.valid = true;
        this.setName("schema_to_link_from_dto");
    }

    public Field getField() {
        int fieldID = this.getFieldID();
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("getField() - Getting field from ID: " + fieldID);
        }
        if (this.isWrongID(fieldID)) {
            return Field.UNDEF;
        }
        if (this.field == null) {
            this.field = (Field)fieldDAO.getByID(fieldID);
        } else if (debug) {
            logger.info("getField() - Returning cached field");
        }
        if (debug) {
            logger.info("getField() - Fetched field from ID: " + String.valueOf(this.field));
        }
        return this.field;
    }

    public Schema getSchema() {
        int schemaID = this.getSchemaID();
        if (this.isWrongID(schemaID)) {
            return Schema.UNDEF;
        }
        if (this.schema == null) {
            this.schema = (Schema)schemaDAO.getByID(schemaID);
        }
        return this.schema;
    }

    public void setSchemaID(int value) {
        this.setSchemaID(Integer.toString(value));
    }

    public void setSchemaID(String value) {
        this.setForeignId(FK_SCHEMA_ID, value);
    }

    public int getSchemaID() {
        return this.getForeignId(FK_SCHEMA_ID);
    }

    public void setFieldID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId();
        } else {
            this.setForeignId(value);
        }
    }

    public void setFieldID(int fieldID) {
        this.setForeignId(fieldID);
    }

    public int getFieldID() {
        return this.getForeignId();
    }

    public void setPosition(String position) {
        this.position = this.parseInteger("position", position);
    }

    public void setPosition(int position) {
        this.position = this.parseInteger("position", position);
    }

    public void setKey(String key) {
        this.key = Key.parseKeyValue(key);
        if (this.key == Key.UNDEF) {
            this.key = Key.NO_KEY;
            this.addWarningMessage("Key value forced to 'NO_KEY' for " + this.getModelLabel(key));
        }
    }

    public boolean isKey() {
        if (this.key == null) {
            return false;
        }
        if (this.key == Key.NO_KEY) {
            return false;
        }
        return this.key != Key.UNDEF;
    }

    public void setFunction(String function) {
        this.function = this.parseBoolean("function", function, true);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public int getPosition() {
        return this.position;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public List<Key> getKey() {
        return this.key;
    }

    public void setKey(List<Key> key) {
        this.key = key;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isFatallyInvalid(int schemaID) {
        if (this.getPosition() < 0) {
            return true;
        }
        return this.getSchemaID() != schemaID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaToField other = (SchemaToField)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.function != other.function) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", schemaID=");
        builder.append(this.getIntegerLabel(this.getSchemaID()));
        builder.append(", position=");
        builder.append(this.getIntegerLabel(this.position));
        builder.append(", fieldID=");
        builder.append(this.getForeignIdAsString());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            builder.append(" (");
            builder.append(this.getDescription());
            builder.append(")");
        }
        String sep = "";
        builder.append(", key=");
        if (this.key != null) {
            for (Key singleKey : this.key) {
                builder.append(sep);
                builder.append((Object)singleKey);
                sep = "-";
            }
        }
        builder.append(", function=");
        builder.append(this.isFunction());
        builder.append("] (valid=");
        builder.append(this.valid);
        builder.append(")]");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(" (");
        builder.append(this.getName());
        builder.append("), position=");
        builder.append(this.getIntegerLabel(this.position));
        builder.append(", fieldID=");
        builder.append(this.getForeignIdAsString());
        builder.append(", key=");
        builder.append(this.getKey());
        builder.append("}");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(SchemaToField.class);
    }
}

