/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaGroupDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.report.ReportType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema
extends GenericModel {
    protected SchemasGroup schemaGroup;
    protected Schema parent;
    protected ReportType report;
    protected List<SchemaToField> schemaTofields;
    protected List<Protocol> protocols;
    public static final String FK_PARENT_ID = "parentId";
    public static final String FK_REPORT_ID = "reportId";
    public static final Schema UNDEF = new Schema();
    public static final List<Schema> EMPTY_LIST = new ArrayList<Schema>();
    protected static SchemaGroupDAO groupDAO;
    protected static SchemaDAO schemaDAO;
    protected static SchemaToFieldDAO schemaToFieldDAO;
    protected static ProtocolDAO protocolDAO;
    protected static Logger logger;

    public Schema() {
        super(0, 0);
        this.setValid(false);
        this.setName("undefined_schema");
        this.setDescription("Empty reference for a \"null\" Schema instance");
        this.setForeignKeyToNillable(FK_PARENT_ID);
        this.setForeignKeyToNillable(FK_REPORT_ID);
    }

    public Schema(String id, String groupID, String name, String description, String parentID, String reportID) {
        this();
        this.valid = true;
        this.setName(name.trim());
        this.setId(id);
        this.setForeignId(groupID);
        this.setDescription(description);
        this.setParentID(parentID);
        this.setReportID(reportID);
    }

    public Schema(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4], array[5]);
    }

    public Schema(eu.europa.ec.jrc.qcs.dao.dto.Schema dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.valid = true;
        this.setId(dto.getId());
        this.setName(dto.getName());
        this.setForeignId(dto.getGroup().getId());
        this.setDescription(dto.getDescription());
        if (dto.getParent() != null) {
            this.setParentID(Integer.toString(dto.getParent().getId()));
        }
        this.setReportID(Integer.toString(dto.getReportType().getId()));
        if (logger.isTraceEnabled()) {
            logger.trace("Schema(dto) - Created new instance: " + String.valueOf(this));
        }
    }

    public SchemasGroup getSchemaGroup() {
        if (this.schemaGroup == null) {
            int groupID = this.getGroupID();
            this.schemaGroup = (SchemasGroup)groupDAO.getByID(groupID);
        }
        return this.schemaGroup;
    }

    public Schema getParent() {
        if (this.parent == null) {
            int parentID = this.getParentID();
            this.parent = (Schema)schemaDAO.getByID(parentID);
        }
        return this.parent;
    }

    public ReportType getReportType() {
        if (logger.isTraceEnabled()) {
            logger.trace("getReportType() - this.report: " + String.valueOf((Object)this.report));
        }
        if (this.report == null || this.report == ReportType.UNDEF) {
            int reportID = this.getReportID();
            this.report = ReportType.getByID(reportID);
        }
        return this.report;
    }

    public List<SchemaToField> getAllSchemaToField() {
        if (this.schemaTofields == null) {
            int schemaID = this.getId();
            this.schemaTofields = schemaToFieldDAO.getBySchemaID(schemaID);
        }
        return this.schemaTofields;
    }

    public List<Protocol> getAllProtocol() {
        if (this.protocols == null) {
            int schemaID = this.getId();
            this.protocols = protocolDAO.getBySchemaID(schemaID);
        }
        return this.protocols;
    }

    public void addSchemaToField(SchemaToField schemaToField) {
        int schemaID = schemaToField.getSchemaID();
        if (schemaID != this.getId()) {
            logger.error("Tried to add a SchemaToField to the wrong Schema instance: schemaToField.schemaID: " + schemaID);
            return;
        }
        if (this.schemaTofields == null) {
            this.schemaTofields = new ArrayList<SchemaToField>();
        }
        this.schemaTofields.add(schemaToField);
    }

    public SchemaToField getSchemaToField(int fieldID) {
        List<SchemaToField> list = this.getAllSchemaToField();
        for (SchemaToField schemaToField : list) {
            if (schemaToField.getFieldID() != fieldID) continue;
            return schemaToField;
        }
        return SchemaToField.UNDEF;
    }

    public Protocol getProtocol(int protocolID) {
        List<Protocol> list = this.getAllProtocol();
        for (Protocol protocol : list) {
            if (protocol.getId() != protocolID) continue;
            return protocol;
        }
        return Protocol.UNDEF;
    }

    public void setGroupID(String groupID) {
        this.setForeignId(groupID);
    }

    public void setGroupID(int groupID) {
        this.setForeignId(groupID);
    }

    public int getGroupID() {
        return this.getForeignId();
    }

    public void setParentID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId(FK_PARENT_ID);
        } else {
            this.setForeignId(FK_PARENT_ID, value);
        }
    }

    public int getParentID() {
        return this.getForeignId(FK_PARENT_ID);
    }

    public void setReportID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId(FK_REPORT_ID);
        } else {
            this.setForeignId(FK_REPORT_ID, value);
        }
    }

    public int getReportID() {
        return this.getForeignId(FK_REPORT_ID);
    }

    public void setSchemaGroup(SchemasGroup schemaGroup) {
        this.schemaGroup = schemaGroup;
    }

    public void setSchemaTofields(List<SchemaToField> schemaTofields) {
        this.schemaTofields = schemaTofields;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getForeignId(FK_PARENT_ID);
        result = 31 * result + (this.schemaGroup == null ? 0 : this.schemaGroup.hashCode());
        result = 31 * result + (this.schemaTofields == null ? 0 : this.schemaTofields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schema other = (Schema)obj;
        if (this.getForeignId(FK_PARENT_ID) != other.getForeignId(FK_PARENT_ID)) {
            return false;
        }
        return !(this.foreignId == null ? other.foreignId != null : !this.foreignId.equals(other.foreignId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("name=");
        builder.append(this.name);
        builder.append(", id=");
        builder.append(this.getIdAsString());
        builder.append(", groupID=");
        builder.append(this.getIntegerLabel(this.getGroupID()));
        builder.append(", parentID=");
        builder.append(this.getIntegerLabel(this.getParentID()));
        builder.append(", reportID=");
        builder.append(this.getIntegerLabel(this.getReportID()));
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(Schema.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        groupDAO = (SchemaGroupDAO)((Object)daoFactory.getDAO(DAO.SCHEMAS_GROUP));
        schemaDAO = (SchemaDAO)((Object)daoFactory.getDAO(DAO.SCHEMA));
        schemaToFieldDAO = (SchemaToFieldDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_TO_FIELD));
        protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
    }
}

