/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.RangeDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeData
extends GenericModel {
    private String value;
    private List<Range> ranges;
    public static final RangeData UNDEF = new RangeData();
    public static final List<RangeData> EMPTY_LIST = new ArrayList<RangeData>();
    protected static RangeDAO rangeDAO;
    protected static Logger logger;

    public RangeData() {
        this.setValid(false);
        this.setId(0);
        this.setName("No name");
        this.setDescription("Empty reference for a \"null\" RangeData instance");
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        rangeDAO = (RangeDAO)((Object)daoFactory.getDAO(DAO.RANGE));
    }

    public RangeData(int id) {
        this();
        this.setId(id);
        this.valid = true;
    }

    public RangeData(String id, String value) {
        this();
        this.valid = true;
        this.setId(id);
        this.setValue(value);
    }

    public RangeData(String[] array) {
        this(array[0], array[1]);
    }

    public RangeData(eu.europa.ec.jrc.qcs.dao.dto.RangeData dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("RangeData(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("RangeData(dto) - Creating model for rangeId: " + dto.getRange().getId());
        }
        this.setId(dto.getRange().getId());
        this.setValue(dto.getValue());
        this.valid = true;
    }

    public List<Range> getAllRange() {
        if (this.ranges == null) {
            int rangeID = this.getId();
            this.ranges = rangeDAO.getByRangeId(rangeID);
            if (rangeID == 4) {
                for (Range range : this.ranges) {
                    logger.info(">>> Fetched range: " + range.getModelLabel());
                }
            }
        }
        return this.ranges;
    }

    public void addRangeToRangeData(Range range) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        this.ranges.add(range);
    }

    public Range getRange(int rangeID) {
        List<Range> list = this.getAllRange();
        for (Range range : list) {
            if (range.getId() != rangeID) continue;
            return range;
        }
        return Range.UNDEF;
    }

    public void setValue(String value) {
        if (value == null || value.length() == 0) {
            this.addErrorMessage("Null or empty range value for " + this.getModelName() + " " + this.id + " - Original value: " + value);
            if (logger.isTraceEnabled()) {
                logger.trace("setValue() - Wrong value [" + this.id + "]: " + value);
            }
        } else {
            this.value = value;
        }
    }

    public void setRange(List<Range> ranges) {
        this.ranges = ranges;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeData other = (RangeData)obj;
        List<Range> ranges = this.getAllRange();
        List<Range> otherRanges = other.getAllRange();
        if (ranges == null ? otherRanges != null : !GenericModel.areSameList(ranges, otherRanges)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.id);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", valid=");
        builder.append(this.valid);
        builder.append("]");
        return builder.toString();
    }

    public String toCSVString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        builder.append(";");
        builder.append(this.value);
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(RangeData.class);
    }
}

