/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.RangeDataDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Keyword;
import eu.europa.ec.jrc.qcs.dao.model.schema.RangeData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Range
extends GenericModel {
    private String fromValue;
    private String toValue;
    public boolean isInterval;
    protected List<Field> fields;
    private List<String> rangeValues;
    private List<RangeData> rangeData;
    public static final Range UNDEF = new Range();
    public static final List<String> INTERVAL_RANGE_VALUES = new ArrayList<String>();
    public static final List<RangeData> INTERVAL_RANGE_DATA = new ArrayList<RangeData>();
    protected static FieldDAO fieldDAO;
    protected static RangeDataDAO rangeDataDAO;
    protected static Logger logger;

    public Range() {
        this.setValid(false);
        this.setId(0);
        this.setName("undefined_range");
        this.setDescription("Empty reference for a \"null\" Range instance");
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        fieldDAO = (FieldDAO)((Object)daoFactory.getDAO(DAO.FIELD));
        rangeDataDAO = (RangeDataDAO)((Object)daoFactory.getDAO(DAO.RANGE_DATA));
    }

    public Range(String[] array) {
        this();
        this.valid = true;
        this.setName(array[1], array[0]);
        this.setId(array[0]);
        this.setDescription(array[2]);
        this.setFromValue(array[3], array[5]);
        this.setToValue(array[4], array[5]);
        this.setInterval(array[5], array[3], array[4], array[0]);
    }

    public Range(eu.europa.ec.jrc.qcs.dao.dto.Range range) {
        this();
        if (range == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.setId(range.getId());
        this.setName(range.getName());
        this.setDescription(range.getDescription());
        this.setFromValue(range.getFromRange(), range.isInterval());
        this.setToValue(range.getToRange(), range.isInterval());
        this.setInterval(range.isInterval());
        this.valid = true;
    }

    public List<Field> getAllField() {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
            List allFields = fieldDAO.getAll();
            for (Field field : allFields) {
                int fieldRangeID = field.getRangeID();
                if (fieldRangeID != this.getId()) continue;
                this.fields.add(field);
            }
        }
        return this.fields;
    }

    public List<String> getRangeValues() {
        if (this.rangeValues != null) {
            return this.rangeValues;
        }
        int rangeID = this.getId();
        if (logger.isDebugEnabled()) {
            logger.debug("getRangeValues - Lazy fetching of range values for range: " + this.getModelLabel());
        }
        if (this.isInterval) {
            this.rangeValues = INTERVAL_RANGE_VALUES;
            if (logger.isDebugEnabled()) {
                logger.debug("getRangeValues: range is an actual nterval -> rangeValues set to INTERVAL_RANGE_VALUES");
            }
        } else {
            this.rangeValues = rangeDataDAO.geValuesById(rangeID);
            if (logger.isDebugEnabled()) {
                logger.debug("getRangeValues: range is not an interval -> loaded values for rangeID = " + rangeID);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getRangeValues: loaded range values: " + String.valueOf(this.rangeValues) + " [empty=" + this.rangeValues.equals(RangeData.EMPTY_LIST) + "]");
        }
        return this.rangeValues;
    }

    public List<RangeData> getRangeData() {
        if (this.rangeData != null) {
            return this.rangeData;
        }
        int rangeID = this.getId();
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("getRangeData - Lazy fetching of range data for range: " + this.toString());
        }
        if (this.isInterval) {
            this.rangeData = INTERVAL_RANGE_DATA;
            if (debug) {
                logger.info("getRangeData: range is an actual interval -> set rangeData to INTERVAL_RANGE_DATA");
            }
        } else {
            this.rangeData = rangeDataDAO.getRangeDataById(rangeID);
            if (debug) {
                logger.info("getRangeData: range is not an interval -> fetched range values from the RANGE_DATA table: " + rangeID);
            }
        }
        if (debug) {
            if (this.rangeValues != null) {
                logger.info("getRangeData: loaded range data: " + String.valueOf(this.rangeValues) + " [empty=" + this.rangeValues.equals(RangeData.EMPTY_LIST) + "]");
            } else {
                logger.info("getRangeData: null range data");
            }
        }
        return this.rangeData;
    }

    public void addField(Field field) {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        this.fields.add(field);
    }

    public void setName(String name, String id) {
        super.setName(name);
        if (name == null || name.length() == 0) {
            String rangeID = this.getId() > 0 ? this.getIdAsString() : id;
            this.addErrorMessage("Missing name attribute for range: " + rangeID + " - Original value: " + name);
        }
    }

    public void setFromValue(String fromValue, boolean isInterval) {
        this.setFromValue(fromValue, this.valueOf(isInterval));
    }

    public void setFromValue(String fromValue, String isInterval) {
        boolean intervalFlag;
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            String message = this.getModelLabel() + " -> fromValue = " + fromValue + " (interval ? " + isInterval + ")";
            logger.info("setFromValue() for " + message);
        }
        if (Keyword.contains(fromValue)) {
            this.fromValue = Keyword.getValue(fromValue);
            if (logger.isDebugEnabled()) {
                logger.debug("setFromValue() - Keyword: " + fromValue + " -> " + this.fromValue);
            }
        } else {
            this.fromValue = fromValue;
        }
        if (debug) {
            logger.info("setFromValue() - rangeID: " + this.id + " -> " + fromValue + " - " + fromValue);
        }
        if ((fromValue == null || fromValue.length() == 0) && (intervalFlag = this.parseBoolean("isInterval", isInterval, false, false))) {
            this.addWarningMessage("Missing fromValue attribute for range: " + this.id + " - Original value: " + fromValue);
            if (debug) {
                logger.info("setFromValue() - Missing fromValue attribute for interval: " + this.id + " - Original value: " + fromValue);
            }
        }
    }

    public void setToValue(String toValue, boolean isInterval) {
        this.setToValue(toValue, this.valueOf(isInterval));
    }

    public void setToValue(String toValue, String isInterval) {
        boolean intervalFlag;
        if (Keyword.contains(toValue)) {
            this.toValue = Keyword.getValue(toValue);
            if (logger.isDebugEnabled()) {
                logger.debug("setToValue() - Keyword: " + toValue + " -> " + this.toValue);
            }
        } else {
            this.toValue = toValue;
        }
        if (logger.isDebugEnabled()) {
            logger.info("setToValue() - rangeID: " + this.id + " -> " + toValue + " - " + toValue);
        }
        if ((toValue == null || toValue.length() == 0) && (intervalFlag = this.parseBoolean("isInterval", isInterval, false, false))) {
            this.addErrorMessage("Missing toValue attribute for range: " + this.id + " - Original value: " + this.fromValue);
            logger.trace("setToValue() - Missing toValue attribute for range: " + this.id + " - Original value: " + this.fromValue);
        }
    }

    public void setInterval(String isInterval, String from, String to, String rangeId) {
        boolean verbose = logger.isTraceEnabled();
        if (verbose) {
            logger.info("setInterval() - Range " + rangeId + " raw values: " + isInterval + "-" + from + "-" + to + "-" + rangeId);
        }
        this.isInterval = this.parseBoolean("isInterval", isInterval, true);
        if (this.isInterval) {
            if (verbose) {
                logger.info("setInterval() - Range declared as interval -> checking if has alternatives");
            }
            if (!this.canBeInterval(from, to)) {
                this.valid = false;
                this.addErrorMessage("Can not be an interval, see " + this.getModelLabel(from + "-" + to));
                this.addWarningMessage("Range is not an interval: " + this.getModelLabel(null) + ", but could be set to list: " + rangeId);
            }
        } else {
            if (verbose) {
                logger.info("setInterval() - Range declared as list -> checking if has alternatives: " + from + "-" + to);
            }
            if (this.parseIntegerValue(rangeId) <= 0) {
                this.valid = false;
                this.addErrorMessage("Can not be a list, see " + this.getModelLabel(rangeId));
                if (this.canBeInterval(from, to)) {
                    this.addWarningMessage("Range is not a list: " + this.getModelLabel(null) + ", but could be set to the interval: " + from + "-" + to);
                }
            }
        }
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getFromValue() {
        return this.fromValue;
    }

    public String getToValue() {
        return this.toValue;
    }

    public void setRangeValues(List<String> rangeData) {
        this.rangeValues = rangeData;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public void setInterval(boolean isInterval) {
        this.isInterval = isInterval;
    }

    public void setRangeData(List<RangeData> rangeData) {
        this.rangeData = rangeData;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean canBeInterval(String from, String to) {
        double toDouble;
        int toInteger;
        double fromDouble;
        int fromInteger;
        String logicToValue;
        String logicFromValue;
        boolean verbose;
        block25: {
            block27: {
                block24: {
                    block26: {
                        boolean toValueOK;
                        verbose = false;
                        boolean fromValueOK = from != null && from.length() > 0;
                        boolean bl = toValueOK = to != null && to.length() > 0;
                        if (!fromValueOK || !toValueOK) {
                            if (verbose) {
                                logger.info("canBeInterval() - Null bounds: " + from + "-" + to);
                            }
                            return false;
                        }
                        if (!this.isNumeric(from) && !Keyword.contains(from)) {
                            if (verbose) {
                                logger.info("canBeInterval() - Wrong 'from' datatype: " + from);
                            }
                            return false;
                        }
                        if (!this.isNumeric(to) && !Keyword.contains(to)) {
                            if (verbose) {
                                logger.info("canBeInterval() - Wrong 'to' datatype: " + to);
                            }
                            return false;
                        }
                        logicFromValue = !Keyword.contains(from) ? from : Keyword.getValue(from);
                        logicToValue = !Keyword.contains(to) ? to : Keyword.getValue(to);
                        fromInteger = 0;
                        fromDouble = 0.0;
                        if (!this.isNumeric(logicFromValue)) break block26;
                        if (this.isInteger(logicFromValue)) {
                            fromInteger = this.parseIntegerValue(logicFromValue);
                            break block24;
                        } else if (this.isDouble(logicFromValue)) {
                            fromDouble = this.parseDoubleValue(logicFromValue);
                            break block24;
                        } else {
                            if (verbose) {
                                logger.info("canBeInterval() - 'from' is not integer, nor double: " + logicFromValue);
                            }
                            return false;
                        }
                    }
                    if (Keyword.contains(logicFromValue)) {
                        Keyword key = Keyword.find(logicFromValue);
                        if (!key.text) {
                            if (verbose) {
                                logger.info("canBeInterval() - 'from' is not a valid text keyword : " + logicFromValue);
                            }
                            return false;
                        }
                    }
                }
                toInteger = 0;
                toDouble = 0.0;
                if (!this.isNumeric(logicToValue)) break block27;
                if (this.isInteger(logicToValue)) {
                    toInteger = this.parseIntegerValue(logicToValue);
                    break block25;
                } else if (this.isDouble(logicToValue)) {
                    toDouble = this.parseDoubleValue(logicToValue);
                    break block25;
                } else {
                    if (verbose) {
                        logger.info("canBeInterval() - 'to' is not integer, nor double: " + logicToValue);
                    }
                    return false;
                }
            }
            if (Keyword.contains(logicToValue)) {
                Keyword key = Keyword.find(logicToValue);
                if (!key.text) {
                    if (verbose) {
                        logger.info("canBeInterval() - 'to' is not a valid text keyword : " + logicToValue);
                    }
                    return false;
                }
            }
        }
        if (this.isNumeric(logicFromValue) && this.isNumeric(logicToValue) && fromInteger >= toInteger && (double)fromInteger >= toDouble && fromDouble >= (double)toInteger && fromDouble >= toDouble) {
            String label = fromInteger + " (" + fromDouble + ") >= " + toInteger + " (" + toDouble + ")";
            this.addWarningMessage("Wrong from-to relation for " + this.getModelLabel(label));
            if (verbose) {
                logger.info(label);
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.fields == null ? other.fields != null : !GenericModel.areSameList(this.fields, other.fields)) {
            return false;
        }
        if (this.fromValue == null ? other.fromValue != null : !this.fromValue.equals(other.fromValue)) {
            return false;
        }
        if (this.isInterval != other.isInterval) {
            return false;
        }
        if (this.rangeData == null ? other.rangeData != null : !this.rangeData.equals(other.rangeData)) {
            return false;
        }
        if (this.rangeValues == null ? other.rangeValues != null : !this.rangeValues.equals(other.rangeValues)) {
            return false;
        }
        return !(this.toValue == null ? other.toValue != null : !this.toValue.equals(other.toValue));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", desc=");
        builder.append(this.description);
        builder.append(", from=");
        builder.append(this.fromValue);
        builder.append(", to=");
        builder.append(this.toValue);
        builder.append(", interval=");
        builder.append(this.isInterval);
        builder.append(", rangeId=");
        builder.append(this.getForeignIdAsString());
        builder.append(", fieldIDs=");
        List<Field> fields = this.fields;
        String sep = "";
        if (fields != null) {
            for (Field field : fields) {
                builder.append(sep);
                builder.append(field.getId());
                sep = "-";
            }
        } else {
            builder.append("lazy");
        }
        builder.append("] ");
        builder.append(this.valid ? "(valid)" : "(NOT valid)");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", name=");
        builder.append(this.name);
        builder.append("] ");
        builder.append(this.valid ? "(valid)" : "(NOT valid)");
        return builder.toString();
    }

    public String getRangeSample() {
        List<String> list = this.getRangeValues();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.isInterval) {
            builder.append(this.fromValue);
            builder.append("-");
            builder.append(this.toValue);
        } else {
            int margin = 3;
            String sep = "";
            if (list.size() > 2 * margin) {
                for (int i = 0; i < list.size(); ++i) {
                    if (i < margin) {
                        builder.append(sep);
                        builder.append(list.get(i));
                        sep = ",";
                        continue;
                    }
                    if (i == margin) {
                        builder.append(" .. ");
                        sep = "";
                        continue;
                    }
                    if (i < list.size() - margin) continue;
                    builder.append(sep);
                    builder.append(list.get(i));
                    sep = ",";
                }
            } else {
                return list.toString();
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public String getRangeDescription() {
        int rangeID = this.getId();
        List<String> list = this.getRangeValues();
        StringBuilder builder = new StringBuilder("Range ");
        builder.append(rangeID);
        if (INTERVAL_RANGE_VALUES.equals(list)) {
            builder.append(" is a an interval, defined as   : ");
            builder.append(this.fromValue);
            builder.append("-");
            builder.append(this.toValue);
        } else {
            String eol = "";
            builder.append(" is list-based, defined as : ");
            for (String value : list) {
                builder.append(eol);
                builder.append(value);
                eol = ", ";
            }
        }
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(Range.class);
    }
}

