/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import java.util.Calendar;

public enum Keyword {
    WRONG("UNDEF", true),
    ANY("ANY", true),
    YEAR("YEAR", false);

    public final String keyword;
    public final boolean text;

    private Keyword(String keyword, boolean text) {
        this.keyword = keyword;
        this.text = text;
    }

    public String getValue() {
        if (this == ANY) {
            return Keyword.ANY.keyword;
        }
        if (this == YEAR) {
            Calendar now = Calendar.getInstance();
            int year = now.get(1);
            return "" + year;
        }
        return null;
    }

    public static boolean contains(String value) {
        for (Keyword key : Keyword.values()) {
            if (!key.keyword.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static Keyword find(String value) {
        for (Keyword key : Keyword.values()) {
            if (!key.keyword.equals(value)) continue;
            return key;
        }
        return WRONG;
    }

    public static String getValue(String value) {
        Keyword key = Keyword.find(value);
        return key.getValue();
    }
}

