/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Key {
    NO("This field is NOT a key field", "N"),
    UNIQUE("This field should hold unique values", "U"),
    PRIMARY("This field is the only primary key", "P"),
    MAIN("This field is the main element of a composite key", "M"),
    COMPOSITE("This field is an element of a composite key", "C");

    public final String description;
    public final String symbol;
    public static final List<Key> NO_KEY;
    public static final List<Key> UNDEF;
    protected static Logger logger;

    private Key(String description, String symbol) {
        this.description = description;
        this.symbol = symbol;
    }

    public static List<Key> parseKeyValue(String value) {
        ArrayList<Key> list = new ArrayList<Key>();
        if (value == null) {
            return NO_KEY;
        }
        if (Key.NO.symbol.equals(value)) {
            return NO_KEY;
        }
        for (Key key : Key.values()) {
            if (!value.contains(key.symbol)) continue;
            list.add(key);
        }
        if (list.size() > 0) {
            return list;
        }
        return UNDEF;
    }

    public boolean isPrimaryKey() {
        if (this == PRIMARY) {
            return true;
        }
        if (this == MAIN) {
            return true;
        }
        return this == COMPOSITE;
    }

    public static boolean isPrimaryKey(List<Key> list) {
        for (Key key : list) {
            if (!key.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainKey(List<Key> list) {
        for (Key key : list) {
            if (key != MAIN) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompositeKey(List<Key> list) {
        for (Key key : list) {
            if (key != COMPOSITE) continue;
            return true;
        }
        return false;
    }

    static {
        NO_KEY = new ArrayList<Key>(Arrays.asList(NO));
        UNDEF = new ArrayList<Key>();
        logger = LoggerFactory.getLogger(Key.class);
    }
}

