/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

import eu.europa.ec.jrc.qcs.dao.RangeDAO;
import eu.europa.ec.jrc.qcs.dao.RuleToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleToField;
import eu.europa.ec.jrc.qcs.dao.model.schema.DataType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Key;
import eu.europa.ec.jrc.qcs.dao.model.schema.Mandatory;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Field
extends GenericModel {
    private int functionID;
    private List<Key> key;
    private DataType dataType;
    private int maxSize;
    private boolean caseSensitive;
    private Mandatory mandatory;
    private String unknownLabel;
    private String defaultValue;
    protected Range range;
    public static final String FK_RULE_DEFINITION_ID = "ruleDefinitionId";
    protected List<SchemaToField> schemaToFields;
    protected List<RuleToField> ruleToFields;
    public static final Field UNDEF = new Field();
    public static final List<Field> EMPTY_LIST = new ArrayList<Field>();
    protected static boolean verbose = false;
    protected static RangeDAO rangeDAO;
    protected static SchemaToFieldDAO schemaToFieldDAO;
    protected static RuleToFieldDAO ruleToFieldDAO;
    protected static Logger logger;

    public Field() {
        super(0, 0);
        this.setValid(false);
        this.setName("undefined_field");
        this.setDescription("Empty reference for a \"null\" Field instance");
        this.setForeignKeyToNillable("default");
        this.setForeignKeyToNillable(FK_RULE_DEFINITION_ID);
    }

    public Field(String[] array) {
        this();
        this.valid = true;
        this.setName(array[3], array[0]);
        this.setId(array[0]);
        this.setKey(array[2]);
        this.setFunctionID(array[1]);
        this.setDescription(array[4]);
        this.setDataType(array[5]);
        this.setMaxSize(array[6]);
        this.setCaseSensitive(array[7]);
        this.setMandatory(array[8]);
        this.setUnknownLabel(array[9]);
        this.setDefaultValue(array[10]);
        this.setRangeID(array[11]);
        if (logger.isTraceEnabled() && this.name != null && this.name.length() >= 5 && this.name.substring(0, 5).equals("field")) {
            logger.trace("New Field " + this.id + " with array: " + array.length + " -> " + array[11]);
        }
    }

    public Field(eu.europa.ec.jrc.qcs.dao.dto.Field dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Field - Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Field(dto) - Creating model for fieldID: " + dto.getId());
        }
        this.setId(dto.getId());
        this.setFunctionID(dto.getFunctionId());
        this.setKey(dto.getKey());
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
        this.setDataType(dto.getDataType());
        this.setMaxSize(dto.getFieldSize());
        this.setCaseSensitive(String.valueOf(dto.isFieldCase()));
        this.setMandatory(dto.getMandatory());
        this.setUnknownLabel(dto.getUnknownValue());
        this.setDefaultValue(dto.getDefaultValue());
        this.setRangeID(String.valueOf(dto.getRange().getId()));
        eu.europa.ec.jrc.qcs.dao.dto.Range rangeDTO = dto.getRange();
        Range rangeModel = new Range(rangeDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("Field(dto) - Creating range_from_dto : " + String.valueOf(rangeDTO));
            logger.trace("Field(dto) - Created range_model     : " + String.valueOf(rangeModel));
        }
        this.setRange(rangeModel);
    }

    public Range getRange() {
        int rangeID = this.getRangeID();
        if (this.isWrongID(rangeID)) {
            return Range.UNDEF;
        }
        if (this.range == null) {
            this.range = (Range)rangeDAO.getByID(rangeID);
        }
        return this.range;
    }

    public List<SchemaToField> getAllSchemaToField() {
        if (this.schemaToFields == null) {
            int fieldID = this.getId();
            this.schemaToFields = schemaToFieldDAO.getByFieldID(fieldID);
        }
        return this.schemaToFields;
    }

    public List<RuleToField> getAllRuleToField() {
        if (this.ruleToFields == null) {
            int fieldID = this.getId();
            this.ruleToFields = ruleToFieldDAO.getByFieldID(fieldID);
        }
        return this.ruleToFields;
    }

    public void addSchemaToField(SchemaToField schemaToField) {
        if (this.schemaToFields == null) {
            this.schemaToFields = new ArrayList<SchemaToField>();
        }
        this.schemaToFields.add(schemaToField);
    }

    public SchemaToField getSchemaToField(int schemaID) {
        List<SchemaToField> list = this.getAllSchemaToField();
        if (list == null) {
            return SchemaToField.UNDEF;
        }
        for (SchemaToField schemaToField : list) {
            if (schemaToField.getSchemaID() != schemaID) continue;
            return schemaToField;
        }
        return SchemaToField.UNDEF;
    }

    public List<RuleToField> getRuleToField(int protocolID) {
        List<RuleToField> list = this.getAllRuleToField();
        if (list == null) {
            return RuleToField.EMPTY_LIST;
        }
        ArrayList<RuleToField> result = new ArrayList<RuleToField>();
        for (RuleToField ruleToField : list) {
            if (ruleToField.getProtocolID() != protocolID) continue;
            result.add(ruleToField);
        }
        return result;
    }

    public void setFunctionID(String value) {
        this.setForeignId(FK_RULE_DEFINITION_ID, value);
    }

    public int getFunctionID() {
        return this.getForeignId(FK_RULE_DEFINITION_ID);
    }

    public void setRangeID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId();
        } else {
            this.setForeignId(value);
        }
    }

    public void setRangeID(int rangeID) {
        this.setForeignId(rangeID);
    }

    public int getRangeID() {
        return this.getForeignId();
    }

    public void setMaxSize(String maxSize) {
        this.maxSize = this.parseInteger("maxSize", maxSize);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = this.parseInteger("maxSize", maxSize);
    }

    public void setCaseSensitive(String caseSensitive) {
        boolean verbose = logger.isTraceEnabled();
        if (verbose) {
            String message = this.getModelLabel() + " -> Case = " + caseSensitive;
            message = message + " (datatype: " + String.valueOf((Object)this.dataType) + "[" + this.maxSize + "])";
            logger.info("setCaseSensitive() for " + message);
        }
        this.caseSensitive = this.dataType == DataType.ALPHA_NUMERIC ? this.parseBoolean("caseSensitive", caseSensitive, true) : this.parseBoolean("caseSensitive", caseSensitive, false);
    }

    public void setMandatory(String level) {
        int mandatoryLevel = this.parseInteger("mandatory", level);
        if (mandatoryLevel != -2147483001) {
            this.mandatory = Mandatory.getMandatoryEntry(mandatoryLevel);
        } else {
            this.mandatory = Mandatory.NO;
            this.addWarningMessage("Mandatory value (String) forced to 'NO' for " + this.getModelLabel(level));
        }
    }

    public void setMandatory(int level) {
        int mandatoryLevel = this.parseInteger("mandatory", level);
        if (mandatoryLevel != -2147483001) {
            this.mandatory = Mandatory.getMandatoryEntry(mandatoryLevel);
        } else {
            this.mandatory = Mandatory.NO;
            this.addWarningMessage("Mandatory value (int) forced to 'NO' for " + this.getModelLabel(level));
        }
    }

    public void setUnknownLabel(String unknownLabel) {
        this.unknownLabel = unknownLabel;
        if (this.dataType == null) {
            this.valid = false;
            this.addErrorMessage("Cannot set 'unknown label' because wrong datatype: " + this.getModelLabel(unknownLabel));
            return;
        }
        if (this.maxSize < 1) {
            this.valid = false;
            this.addErrorMessage("Cannot set 'unknown label' because wrong max size: " + this.getModelLabel(unknownLabel));
            return;
        }
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            String fieldDescription = this.getName() + "- [" + this.getId() + "] - " + String.valueOf((Object)this.dataType);
            logger.info("setUnknownLabel() - Setting " + unknownLabel + " for field " + fieldDescription);
        }
        this.valid = this.checkCoherenceWithDatatype(unknownLabel, "'unknown label'");
        if (this.valid) {
            this.valid = this.checkCoherenceWithMaxSize(unknownLabel, "'unknown label'");
        }
        if (unknownLabel != null && unknownLabel.trim().length() == 0 && unknownLabel.length() > 0) {
            this.unknownLabel = null;
            this.addWarningMessage("Ignored blanks as 'unknown label' for " + this.getModelLabel(unknownLabel));
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (this.dataType == null) {
            this.valid = false;
            this.addErrorMessage("Cannot set default value because wrong datatype: " + this.getModelLabel(defaultValue));
            return;
        }
        if (this.maxSize < 1) {
            this.valid = false;
            this.addErrorMessage("Cannot set default value because wrong max size: " + this.getModelLabel(defaultValue));
            return;
        }
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            String message = this.getModelLabel() + " -> default = " + defaultValue;
            message = message + " (datatype: " + String.valueOf((Object)this.dataType) + "[" + this.maxSize + "])";
            logger.info("setDefaultValue() for " + message);
        }
        this.valid = this.checkCoherenceWithDatatype(defaultValue, "'default value'");
        if (this.valid) {
            this.valid = this.checkCoherenceWithMaxSize(defaultValue, "'unknown label'");
        }
        if (defaultValue != null && defaultValue.trim().length() == 0 && defaultValue.length() > 0) {
            this.defaultValue = null;
            this.addWarningMessage("Ignored blanks as 'default value' for " + this.getModelLabel(defaultValue));
        }
        if (debug) {
            logger.info("setDefaultValue() - Value " + defaultValue + " isValid ? " + this.valid);
        }
    }

    public void setKey(String key) {
        this.key = Key.parseKeyValue(key);
        if (this.key == Key.UNDEF) {
            this.key = Key.NO_KEY;
            this.addWarningMessage("Key value forced to 'NO' for " + this.getModelLabel(key));
        }
    }

    public void setName(String name, String id) {
        super.setName(name);
        if (name == null || name.length() == 0) {
            String fieldID = this.getId() > 0 ? this.getIdAsString() : id;
            this.addErrorMessage("Empty name value for field: <unknown> [id=" + fieldID + "] - Original value: " + name);
        }
    }

    public void setDataType(String dataType) {
        this.dataType = DataType.parseDataTypeValue(dataType);
        if (this.dataType == DataType.UNKNOWN) {
            this.addErrorMessage("Wrong data type value for " + this.getModelLabel(dataType));
        }
    }

    public boolean isEmpty(String string) {
        return string == null || string.length() <= 0 || string.trim().length() <= 0;
    }

    public boolean isUnknownValue(String value) {
        if (this.unknownLabel == null) {
            return false;
        }
        return this.unknownLabel.equalsIgnoreCase(value);
    }

    protected boolean checkCoherenceWithDatatype(String value, String label) {
        boolean isValid = true;
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("checkCoherenceWithDatatype() - Value " + value);
        }
        if (value != null && value.trim().length() > 0) {
            if (this.dataType == DataType.NUMERIC) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    isValid = false;
                    this.addErrorMessage("Wrong " + label + " datatype for numeric " + this.getModelLabel(value));
                }
            } else if (this.dataType == DataType.FLOATING) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    isValid = false;
                    this.addErrorMessage("Wrong " + label + " datatype for floating " + this.getModelLabel(value));
                }
            }
        }
        if (debug) {
            logger.info("checkCoherenceWithDatatype() - Value " + value + " isValid ? " + isValid);
        }
        return isValid;
    }

    protected boolean checkCoherenceWithMaxSize(String value, String label) {
        int size;
        boolean isValid = true;
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("checkCoherenceWithMaxSize() - Value " + value);
        }
        if (value != null && value.trim().length() > 0 && (size = value.length()) > this.maxSize) {
            isValid = false;
            this.addErrorMessage("Wrong " + label + " max size for field " + this.getModelLabel(value));
        }
        if (debug) {
            logger.info("checkCoherenceWithMaxSize() - Value " + value + " isValid ? " + isValid);
        }
        return isValid;
    }

    public void setSchemaToFields(List<SchemaToField> schemaToFields) {
        this.schemaToFields = schemaToFields;
    }

    public List<Key> getKey() {
        return this.key;
    }

    public void setKey(List<Key> key) {
        this.key = key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Mandatory getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Mandatory mandatory) {
        this.mandatory = mandatory;
    }

    public String getUnknownLabel() {
        return this.unknownLabel;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        Field.verbose = verbose;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public boolean isFatallyInvalid() {
        return this.getId() < 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        if (this.caseSensitive != other.caseSensitive) {
            return false;
        }
        if (this.dataType != other.dataType) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.mandatory != other.mandatory) {
            return false;
        }
        if (this.maxSize != other.maxSize) {
            return false;
        }
        if (this.range == null ? other.range != null : this.range.getId() != other.range.getId()) {
            return false;
        }
        if (this.schemaToFields == null ? other.schemaToFields != null : !GenericModel.areSameList(this.schemaToFields, other.schemaToFields)) {
            return false;
        }
        return !(this.unknownLabel == null ? other.unknownLabel != null : !this.unknownLabel.equals(other.unknownLabel));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        if (verbose) {
            String sep = "";
            builder.append(", key=");
            if (this.key != null) {
                for (Key singleKey : this.key) {
                    builder.append(sep);
                    builder.append((Object)singleKey);
                    sep = "-";
                }
            }
        }
        builder.append(", name=");
        builder.append(this.name);
        if (verbose) {
            builder.append(", desc=");
            builder.append(this.description);
        }
        builder.append(", dataType=");
        builder.append((Object)this.dataType);
        builder.append(", size=");
        builder.append(this.maxSize);
        builder.append(", case=");
        builder.append(this.caseSensitive);
        builder.append(", mandatory=");
        builder.append((Object)this.mandatory);
        if (verbose) {
            builder.append(", unknown=");
            builder.append(this.unknownLabel);
            builder.append(", defaultValue=");
            builder.append(this.defaultValue);
        }
        builder.append(", rangeID=");
        builder.append(this.getForeignIdAsString());
        builder.append(", schemasIDs=");
        List<SchemaToField> schemaToFields = this.schemaToFields;
        String sep = "";
        if (schemaToFields != null) {
            for (SchemaToField schemaToField : schemaToFields) {
                builder.append(sep);
                builder.append(schemaToField.getId());
                sep = "-";
            }
        } else {
            builder.append("lazy");
        }
        builder.append("]");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", name=");
        builder.append(this.name);
        if (this.functionID > 0) {
            builder.append(", function=");
            builder.append(this.functionID);
        }
        builder.append(", rangeID=");
        builder.append(this.getForeignIdAsString());
        builder.append("] ");
        builder.append(this.valid ? "(VALID)" : "(INVALID)");
        return builder.toString();
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("");
        builder.append("Name           : ");
        builder.append(this.name);
        builder.append("\n");
        builder.append("Description    : ");
        builder.append(this.description);
        builder.append("\n");
        builder.append("Field ID       : ");
        builder.append(this.getIdAsString());
        builder.append("\n");
        builder.append("DataType       : ");
        builder.append((Object)this.dataType);
        builder.append("\n");
        builder.append("Size           : ");
        builder.append(this.maxSize);
        builder.append("\n");
        builder.append("Mandatory      : ");
        builder.append((Object)this.mandatory);
        builder.append("\n");
        builder.append("Case Sensitive : ");
        builder.append(this.caseSensitive);
        builder.append("\n");
        String sep = "";
        builder.append("Key Type       : ");
        if (this.key != null) {
            for (Key singleKey : this.key) {
                builder.append(sep);
                builder.append((Object)singleKey);
                sep = ",";
            }
        }
        builder.append("\n");
        builder.append("Unknown Value  : ");
        builder.append(this.unknownLabel);
        builder.append("\n");
        builder.append("Default Value  : ");
        builder.append(this.defaultValue);
        builder.append("\n");
        builder.append("Range ID       : ");
        builder.append(this.getForeignIdAsString());
        builder.append("\n");
        Range range = this.getRange();
        builder.append("Range's sample : ");
        builder.append(range.getRangeSample());
        builder.append("\n");
        int rangeID = range.getId();
        Object rangeFile = rangeID > 0 ? "range_data_" + rangeID + ".txt" : "N/A (range is interval type)";
        builder.append("Range's source : ");
        builder.append(range.getDescription());
        builder.append("\n");
        builder.append("Range's type   : ");
        builder.append(range.isInterval() ? "interval" : "enumeration");
        builder.append("\n");
        builder.append("Range's data   : ");
        builder.append((String)rangeFile);
        builder.append("\n");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(Field.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        rangeDAO = (RangeDAO)((Object)daoFactory.getDAO(DAO.RANGE));
        schemaToFieldDAO = (SchemaToFieldDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_TO_FIELD));
        ruleToFieldDAO = (RuleToFieldDAO)((Object)daoFactory.getDAO(DAO.RULE_TO_FIELD));
    }
}

