/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.schema;

public enum DataType {
    UNKNOWN("Unknown data type (wrong configuration)", "U"),
    NUMERIC("Numeric integer field", "N"),
    ALPHA_NUMERIC("Alpha-numeric field (a text field)", "A"),
    FLOATING("Floating numeric field", "F");

    public final String description;
    public final String symbol;

    private DataType(String description, String symbol) {
        this.description = description;
        this.symbol = symbol;
    }

    public static DataType parseDataTypeValue(String value) {
        if (value != null) {
            for (DataType dataType : DataType.values()) {
                if (!value.equalsIgnoreCase(dataType.symbol)) continue;
                return dataType;
            }
        }
        return UNKNOWN;
    }

    public static boolean isCompatible(DataType input, DataType storage) {
        if (input == null || storage == null) {
            return false;
        }
        if (input == storage) {
            return true;
        }
        return (input == NUMERIC || input == FLOATING) && storage == ALPHA_NUMERIC;
    }
}

