/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationMessage
extends GenericModel {
    protected String code;
    protected MessageType messageType;
    protected String reference;
    protected List<RuleDefinition> ruleDefinitions;
    public static final ValidationMessage UNDEF = new ValidationMessage();
    public static final List<ValidationMessage> EMPTY = new ArrayList<ValidationMessage>();
    protected static RuleDefinitionDAO ruleDAO;
    protected static Logger logger;

    public ValidationMessage() {
        super(0, 0);
        this.setValid(false);
        this.setName("undefined_message");
        this.setDescription("Empty reference for a \"null\" ValidationMessage instance");
        this.setMessageType(MessageType.UNDEF);
    }

    public ValidationMessage(String[] array) {
        this();
        this.valid = true;
        this.setName(array[4]);
        this.setId(array[0]);
        this.setCode(array[1]);
        this.setMessageType(array[2]);
        this.setReference(array[3]);
        this.setDescription(array[4]);
    }

    public ValidationMessage(int id, String name, String description) {
        super(id, name, description);
    }

    public ValidationMessage(eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("ValidationMessage - Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ValidationMessage(dto) - Creating model for messageID: " + dto.getId());
        }
        this.setId(dto.getId());
        this.setName(dto.getCode());
        this.setDescription(dto.getDescription());
        this.setCode(dto.getCode());
        this.setMessageType(dto.getType());
        this.setReference(dto.getReference());
    }

    public List<RuleDefinition> getRuleDefinitions() {
        if (this.ruleDefinitions == null) {
            int messageID = this.getId();
            this.ruleDefinitions = ruleDAO.getByValidatioMessageID(messageID);
        }
        return this.ruleDefinitions;
    }

    public RuleDefinition getRuleDefinition(int ruleID) {
        List<RuleDefinition> list = this.getRuleDefinitions();
        for (RuleDefinition ruleDefinition : list) {
            if (ruleDefinition.getId() != ruleID) continue;
            return ruleDefinition;
        }
        return RuleDefinition.UNDEF;
    }

    public void setMessageType(String type) {
        this.messageType = MessageType.parseMessageType(type);
        if (this.messageType == MessageType.UNDEF) {
            this.addErrorMessage("Wrong MessageType for message " + this.getModelLabel(this.id));
        }
    }

    public String getCode() {
        return this.code;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType type) {
        this.messageType = type;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", code=");
        builder.append(this.code);
        builder.append(", ");
        builder.append(this.description);
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(ValidationMessage.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ruleDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
    }
}

