/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleScope;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RuleType {
    UNDEF(0, "Undef", "undefined rule's type (wrong configuration)", null, false, ValidationLevel.UNDEF),
    FILE_METADATA(1, "File metadata", "file's path, name, extension etc. (checked without opening the file)", RuleScope.FILE_METADATA, false, ValidationLevel.FILE),
    FILE_FORMAT(2, "File format", "file's encoding, format, size etc. (checked reading the file)", RuleScope.FILE_FORMAT, false, ValidationLevel.FILE),
    DUPLICATES(3, "Duplicates", "check if there are records duplicates for some specific fields", RuleScope.ALL_RECORDS, false, ValidationLevel.FILE),
    HEADER(4, "File header", "number of columns, header's separator, order of columns", RuleScope.HEADER, false, ValidationLevel.HEADER),
    RECORD_FORMAT(5, "Record format", "similar to the file's header check, but applied on each single record", RuleScope.RECORD, false, ValidationLevel.RECORD),
    FIELD_FORMAT(6, "Field format", "check the field's datatype, mandatory, size etc...", RuleScope.RECORD, false, ValidationLevel.FIELD),
    RANGE(7, "Range", "check that field's value belong to the field's range", RuleScope.RECORD, false, ValidationLevel.RANGE),
    CROSS_FIELD(8, "CrossField", "check that the target fields respect a positive/negative relation", RuleScope.RECORD, true, ValidationLevel.CROSS_FIELD),
    FUNCTION(9, "FunctionRule", "a function rule, which add virtual fields to the record", RuleScope.RECORD, true, ValidationLevel.CROSS_FIELD),
    CROSS_RECORD(11, "CrossRecord", "check a condition between different records", RuleScope.ALL_RECORDS, true, ValidationLevel.CROSS_RECORD);

    public final int id;
    public final String name;
    public final String description;
    public final RuleScope scope;
    public boolean ordered;
    public ValidationLevel validationLevel;
    private static final Map<Integer, RuleType> rulesTypesByID;
    protected static Logger logger;

    private RuleType(int id, String name, String description, RuleScope scope, boolean ordered, ValidationLevel validationLevel) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.scope = scope;
        this.ordered = ordered;
        this.validationLevel = validationLevel;
    }

    public static RuleType parseRuleTypeID(String value) {
        int id;
        if (logger.isTraceEnabled()) {
            logger.trace("parseRuleTypeID() - Parsing value : " + value);
        }
        try {
            id = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            id = RuleType.UNDEF.id;
            logger.error("parseRuleTypeID() - Wrong rule's type ID: " + value + " -> forced to UNDEF");
        }
        return RuleType.parseRuleTypeID(id);
    }

    public static RuleType parseRuleTypeID(int value) {
        for (RuleType type : RuleType.values()) {
            if (value != type.id) continue;
            return type;
        }
        return UNDEF;
    }

    public String getID() {
        return String.valueOf(this.id);
    }

    public int getLevel() {
        return this.validationLevel.level;
    }

    public static RuleType getByID(int id) {
        return rulesTypesByID.get(id);
    }

    static {
        rulesTypesByID = new HashMap<Integer, RuleType>();
        logger = LoggerFactory.getLogger(RuleType.class);
        for (RuleType ruleType : RuleType.values()) {
            rulesTypesByID.put(ruleType.id, ruleType);
        }
    }
}

