/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleToField
extends GenericModel {
    protected Protocol protocol;
    protected RuleDefinition rule;
    protected RuleTarget ruleTarget;
    protected int position;
    protected boolean key;
    protected Field field;
    public static int globalCounter = 1;
    public static final String FK_PROTOCOL_ID = "protocolId";
    public static final String FK_RULE_ID = "ruleId";
    public static final RuleToField UNDEF = new RuleToField();
    public static final List<RuleToField> EMPTY_LIST = new ArrayList<RuleToField>();
    protected static ProtocolDAO protocolDAO;
    protected static RuleDefinitionDAO ruleDefinitionDAO;
    protected static FieldDAO fieldDAO;
    protected static Logger logger;

    public RuleToField() {
        this.setValid(false);
        this.setId(0);
        this.setName("undefined_rule_to_field");
        this.setDescription("Empty reference for a \"null\" ruleToField instance");
    }

    public RuleToField(int id, String protocolID, String ruleID, String target, String position, String key, String fieldID) {
        super(id);
        this.setProtocolID(protocolID);
        this.setRuleID(ruleID);
        this.setRuleTarget(target);
        this.setPosition(position);
        this.setKey(key);
        this.setFieldID(fieldID);
    }

    public RuleToField(eu.europa.ec.jrc.qcs.dao.dto.RuleToField dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("RuleToField(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("RuleToField(dto) - Creating model from dto: " + dto.toPrettyString());
        }
        this.setId(dto.getId());
        this.setKey(dto.isKey());
        this.setPosition(dto.getPosition());
        if (logger.isTraceEnabled()) {
            logger.trace("RuleToField(dto) - RuleToField DTO key: " + dto.isKey());
        }
        eu.europa.ec.jrc.qcs.dao.dto.RuleTarget targetDTO = dto.getTarget();
        if (logger.isTraceEnabled()) {
            logger.trace("RuleToField(dto) - RuleToField DTO target: " + targetDTO.toPrettyString());
        }
        RuleTarget ruleTarget = RuleTarget.parseRuleTargetValue(targetDTO.getName());
        boolean actualTarget = ruleTarget.isActualTarget();
        if (logger.isTraceEnabled()) {
            logger.trace("RuleToField(dto) - Enum target " + String.valueOf((Object)ruleTarget) + " is actual target ? " + actualTarget);
        }
        if (actualTarget) {
            this.setFieldID(String.valueOf(dto.getField().getId()));
        } else {
            this.setFieldID(null);
        }
        this.setRuleTarget(ruleTarget);
        this.setProtocolID(String.valueOf(dto.getProtocol().getId()));
        this.setRuleID(String.valueOf(dto.getRuleDefinition().getId()));
        if (logger.isTraceEnabled()) {
            logger.trace("RuleToField(dto) - Created model : " + String.valueOf(this));
        }
    }

    public Protocol getProtocol() {
        int protocolID = this.getProtocolID();
        if (this.isWrongID(protocolID)) {
            return Protocol.UNDEF;
        }
        if (this.protocol == null) {
            this.protocol = (Protocol)protocolDAO.getByID(protocolID);
        }
        return this.protocol;
    }

    public RuleDefinition getRule() {
        int ruleID = this.getRuleID();
        if (this.isWrongID(ruleID)) {
            return RuleDefinition.UNDEF;
        }
        if (this.rule == null) {
            this.rule = (RuleDefinition)ruleDefinitionDAO.getByID(ruleID);
        }
        return this.rule;
    }

    public Field getField() {
        int fieldID = this.getFieldID();
        if (this.isWrongID(fieldID)) {
            return Field.UNDEF;
        }
        if (this.field == null) {
            this.field = (Field)fieldDAO.getByID(fieldID);
        }
        return this.field;
    }

    public void setProtocolID(String value) {
        this.setForeignId(FK_PROTOCOL_ID, value);
    }

    public int getProtocolID() {
        return this.getForeignId(FK_PROTOCOL_ID);
    }

    public void setRuleID(String value) {
        this.setForeignId(FK_RULE_ID, value);
    }

    public int getRuleID() {
        return this.getForeignId(FK_RULE_ID);
    }

    public void setRuleTarget(String target) {
        this.ruleTarget = RuleTarget.valueOf(target);
    }

    public void setFieldID(String value) {
        if (GenericModel.isNullInteger(value)) {
            this.setNullForeignId();
        } else {
            this.setForeignId(value);
        }
    }

    public int getFieldID() {
        return this.getForeignId();
    }

    public void setPosition(String position) {
        this.position = this.parseInteger("position", position);
    }

    public void setPosition(int position) {
        this.position = this.parseInteger("position", position);
    }

    public void setKey(String key) {
        this.key = this.parseBoolean("key", key, true);
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public RuleTarget getRuleTarget() {
        return this.ruleTarget;
    }

    public void setRuleTarget(RuleTarget ruleTarget) {
        this.ruleTarget = ruleTarget;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRule(RuleDefinition rule) {
        this.rule = rule;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean getKey() {
        return this.key;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleToField other = (RuleToField)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        if (this.key != other.key) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        return !(this.rule == null ? other.rule != null : !this.rule.equals(other.rule));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", protocolID=");
        builder.append(this.getIntegerLabel(this.getProtocolID()));
        builder.append(", ruleID=");
        builder.append(this.getIntegerLabel(this.getRuleID()));
        builder.append(", target=");
        builder.append((Object)this.getRuleTarget());
        if (this.getFieldID() == 0) {
            builder.append(", fieldID=*");
        } else {
            builder.append(", fieldID[");
            builder.append(this.getIntegerLabel(this.getPosition()));
            builder.append("]=");
            builder.append(this.getForeignIdAsString());
            builder.append(" key ? ");
            builder.append(this.getKey());
        }
        builder.append("}");
        return builder.toString();
    }

    public static String fieldsToString(List<RuleToField> ruleToFields) {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        builder.append("[fieldIDs: ");
        if (EMPTY_LIST.equals(ruleToFields)) {
            builder.append(" empty list]");
            return builder.toString();
        }
        for (RuleToField ruleToField : ruleToFields) {
            builder.append(sep);
            builder.append(ruleToField.getIntegerLabel(ruleToField.getFieldID()));
            sep = ",";
        }
        builder.append("]");
        return builder.toString();
    }

    public static String rulesToString(List<RuleToField> ruleToFields) {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        builder.append("[ruleIDs: ");
        if (EMPTY_LIST.equals(ruleToFields)) {
            builder.append(" empty list]");
            return builder.toString();
        }
        for (RuleToField ruleToField : ruleToFields) {
            builder.append(sep);
            builder.append(ruleToField.getIntegerLabel(ruleToField.getRuleID()));
            sep = ",";
        }
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(RuleToField.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        fieldDAO = (FieldDAO)((Object)daoFactory.getDAO(DAO.FIELD));
        ruleDefinitionDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
        protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
    }
}

