/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

public enum RuleTarget {
    UNDEF("Undefined rule's target", "UNDE", 0),
    WRONG("Wrong configuration in the persistence layer", "WRONG", 1),
    ALL_FIELDS("The rule targets all fields in the schema", "ALL_FIELDS", 2),
    SOME_FIELDS("The rule targets only a subset of fields in the schema", "SOME_FIELDS", 3);

    public final String description;
    public final String symbol;
    public final int id;

    private RuleTarget(String description, String symbol, int id) {
        this.description = description;
        this.symbol = symbol;
        this.id = id;
    }

    public boolean isActualTarget() {
        return this == SOME_FIELDS;
    }

    public static RuleTarget parseRuleTargetValue(String value) {
        if (value != null) {
            for (RuleTarget target : RuleTarget.values()) {
                if (!value.equalsIgnoreCase(target.symbol)) continue;
                return target;
            }
        }
        return UNDEF;
    }
}

